#include "TOOL.h"
#include "cTileWindow.h"

#include "cDisplay.h"

#include "TOOLDebug.h"
#include "cTilePropDialog.h"
#include "ASMapEditor.h"
#include "resource.h"

cTileWindow::cTileWindow(){
}

cTileWindow::~cTileWindow(){

}

bool cTileWindow::RegisterClass(){
	return cWindow::RegisterClass(
		"cTileWindow", 
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, 
		LoadCursor(0, IDC_ARROW),
		(HBRUSH)GetStockObject(WHITE_BRUSH));
	
}

LRESULT cTileWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		if(!OnCreate(wParam, lParam))
			return -1;
		return 0;
	case WM_DESTROY:
		OnDestroy(wParam, lParam);
		break;
	case WM_CLOSE:
		if(OnClose(wParam, lParam)) return 0;
		break;
	case WM_SIZE:
	case WM_MOVE:
		OnSize(wParam, lParam);
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_ERASEBKGND:
		return 1;
	case WM_KEYDOWN:
	case WM_KEYUP:
		OnKeyEvent(uMsg, wParam, lParam);
		return 0;
	case WM_MOUSEMOVE:
		OnMouseMove(wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		OnLButtonDown(wParam, lParam);
		return 0;
	case WM_LBUTTONUP:
		OnLButtonUp(wParam, lParam);
		return 0;
	case WM_LBUTTONDBLCLK:
		return 0;
	case WM_RBUTTONDOWN:
		return 0;
	case WM_RBUTTONUP:
		OnRButtonUp(wParam, lParam);
		return 0;
	case WM_RBUTTONDBLCLK:
		return 0;
	case WM_HSCROLL:
		OnHScroll(wParam, lParam);
		return 0;
	case WM_VSCROLL:
		OnVScroll(wParam, lParam);
		return 0;



	}
	return DefProc(uMsg, wParam, lParam);
}


bool cTileWindow::OnClose(WPARAM wParam, LPARAM lParam){
	return true;
}



// OnCreate ///////////////////////////////////////////////////////
bool cTileWindow::OnCreate(WPARAM wParam, LPARAM lParam){
	static LOGFONT LogFont = {
/*
   LONG lfHeight; 
   LONG lfWidth; 
   LONG lfEscapement; 
   LONG lfOrientation; 
   LONG lfWeight; 
   BYTE lfItalic; 
   BYTE lfUnderline; 
   BYTE lfStrikeOut; 
   BYTE lfCharSet; 
   BYTE lfOutPrecision; 
   BYTE lfClipPrecision; 
   BYTE lfQuality; 
   BYTE lfPitchAndFamily; 
   TCHAR lfFaceName[LF_FACESIZE]; 
*/
		14,	0, 0, 0, FW_NORMAL, 0, 0, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH, "MS Sans Serif" 
	};


	Clipper.Create(hWnd);
	Dragging = false;
	SelRect.Set(0, 0, 0, 0);
	TileRect.Set(0, 0, 0, 0);
	TilePropDrawing = false;

	hFont = CreateFontIndirect(&LogFont);
	hFramePen = CreatePen(PS_SOLID, 1, RGB(255, 255, 96));
	return true;
}

void cTileWindow::OnDestroy(WPARAM wParam, LPARAM lParam){
	DeleteObject(hFont);
	DeleteObject(hFramePen);
	Clipper.Destroy();
}


// OnSize ///////////////////////////////////////////////////////
void cTileWindow::OnSize(WPARAM wParam, LPARAM lParam){
	RecalcScrollBars();
	Invalidate();
}

// OnPaint ///////////////////////////////////////////////////////
void cTileWindow::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	int i;
	cRect ClientRect;
	cRect ScreenRect;
	cRect DestRect;
	int OrgX;
	int OrgY;
	int TileX;
	int TileY;
	char String[256];
	HDC hdc;
	HFONT hOldFont;
	HPEN hOldPen;
	HBRUSH hOldBrush;
	
	BeginPaint(&ps);
	EndPaint(&ps);

	GetClientRect(ClientRect);
	ScreenRect = ClientRect;
	ClientToScreen(ScreenRect);

	Display.GetBackPic()->ClearRect(&ScreenRect);

	if(pTileSet->GetTileCount()){
		OrgX = GetScrollPos(SB_HORZ);
		OrgY = GetScrollPos(SB_VERT);
		for(i = 0; i < pTileSet->GetTileCount(); i ++){
			DestRect.left = ScreenRect.left + (i % 16) * (pTileSet->GetTileWidth() + 1);
			DestRect.top = ScreenRect.top + (i / 16) * (pTileSet->GetTileHeight() + 1);
			DestRect.left -= OrgX * (pTileSet->GetTileWidth() + 1);
			DestRect.top -= OrgY * (pTileSet->GetTileHeight() + 1);
			DestRect.right = DestRect.left + pTileSet->GetTileWidth();
			DestRect.bottom = DestRect.top + pTileSet->GetTileHeight();
			if(ScreenRect.ClipRect(&DestRect)){
				TileX = i % 16;
				TileY = i / 16;
				if(TileRect.IsIn(TileX, TileY)){
					Display.GetBackPic()->BlendedBlt(
						DestRect.left, DestRect.top,
						&pTileSet->GetTile(i)->UnderPicture,
						0,
						PBE_LIGHT_COPY);
				}else{

					Display.GetBackPic()->BltFast(
						DestRect.left, DestRect.top,
						&pTileSet->GetTile(i)->UnderPicture);
				}
			}

		}
	// Ÿ Ӽ ׸
		if(Display.GetBackPic()->GetDC(&hdc)){
			hOldPen = (HPEN)SelectObject(hdc, hFramePen);
			hOldBrush = (HBRUSH)SelectObject(hdc, GetStockObject(NULL_BRUSH));
			if(TilePropDrawing){
				hOldFont = (HFONT)SelectObject(hdc, hFont);
				for(i = 0; i < pTileSet->GetTileCount(); i ++){
					
					DestRect.left = ScreenRect.left + (i % 16) * (pTileSet->GetTileWidth() + 1);
					DestRect.top = ScreenRect.top + (i / 16) * (pTileSet->GetTileHeight() + 1);
					DestRect.left -= OrgX * (pTileSet->GetTileWidth() + 1);
					DestRect.top -= OrgY * (pTileSet->GetTileHeight() + 1);
					DestRect.right = DestRect.left + pTileSet->GetTileWidth();
					DestRect.bottom = DestRect.top + pTileSet->GetTileHeight();
					if(ScreenRect.ClipRect(&DestRect)){
						sprintf(String, "%d\n%X", pTileSet->GetTile(i)->Height,
							pTileSet->GetTile(i)->Prop);
						DrawText(hdc, String, strlen(String), DestRect, DT_LEFT);
					}
				}
				SelectObject(hdc, hOldFont);
			}
			Rectangle(hdc, 
				ScreenRect.left + (TileRect.left - OrgX) * (pTileSet->GetTileWidth() + 1),
				ScreenRect.top + (TileRect.top - OrgY) * (pTileSet->GetTileHeight() + 1),
				ScreenRect.left + (TileRect.right - OrgX) * (pTileSet->GetTileWidth() + 1),
				ScreenRect.top + (TileRect.bottom - OrgY) * (pTileSet->GetTileHeight() + 1));
			SelectObject(hdc, hOldPen);
			SelectObject(hdc, hOldBrush);
			Display.GetBackPic()->ReleaseDC(hdc);
		}
	}

	
	if(!Display.GetFrontPic()->SetClipper(&Clipper)){
		DisplayLastErrorMessage();
	}


	if(!Display.GetFrontPic()->Blt(&ScreenRect, Display.GetBackPic(), &ScreenRect)){
	//	DisplayLastErrorMessage();
	}
	Display.GetFrontPic()->SetClipper(0);
}


// Mouse Handlers //////////////////////////////////////////////////
void cTileWindow::OnMouseMove(WPARAM wParam, LPARAM lParam){
	if(Dragging){
		DrawDragRect(SelRect);
		SelRect.right = LOWORD(lParam);
		SelRect.bottom = HIWORD(lParam);
		DrawDragRect(SelRect);

	}

}

void cTileWindow::OnLButtonDown(WPARAM wParam, LPARAM lParam){
	Dragging = true;
	SetCapture();
	SelRect.left = LOWORD(lParam);
	SelRect.top = HIWORD(lParam);
	SelRect.right = LOWORD(lParam);
	SelRect.bottom = HIWORD(lParam);
	DrawDragRect(SelRect);

}

void cTileWindow::OnLButtonUp(WPARAM wParam, LPARAM lParam){
	int OrgX;
	int OrgY;
	cRect BoundRect;

	// Ÿ Ѵ.
	if(Dragging){
		Dragging = false;
		ReleaseCapture();

		DrawDragRect(SelRect);

		SelRect.right = LOWORD(lParam);
		SelRect.bottom = HIWORD(lParam);

		SelRect.Normalize();

		OrgX = GetScrollPos(SB_HORZ);
		OrgY = GetScrollPos(SB_VERT);

		TileRect.left = OrgX + SelRect.left / (pTileSet->GetTileWidth() + 1);
		TileRect.top = OrgY + SelRect.top / (pTileSet->GetTileHeight() + 1);
		TileRect.right = OrgX + SelRect.right / (pTileSet->GetTileWidth() + 1) + 1;
		TileRect.bottom = OrgY + SelRect.bottom / (pTileSet->GetTileHeight() + 1) + 1;

		BoundRect.Set(0, 0, 16, pTileSet->GetTileCount() / 16);
		BoundRect.ClipRect(&TileRect);

		Invalidate();
	}
}

void cTileWindow::OnRButtonUp(WPARAM wParam, LPARAM lParam){
	// Ÿ Ƽ   ֵ Ѵ.
	cTilePropDialog dlg;
	int y, x;
	int TileID;
	cTile *pTile;
	cRect TilePixelRect;
	cPoint pt;

	if(TileRect.Width() == 0 || TileRect.Height() == 0)
		return;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);
	TilePixelRect.left = TileRect.left * (pTileSet->GetTileWidth() + 1);
	TilePixelRect.top = TileRect.top * (pTileSet->GetTileHeight() + 1);
	TilePixelRect.right = TileRect.right * (pTileSet->GetTileWidth() + 1);
	TilePixelRect.bottom = TileRect.bottom * (pTileSet->GetTileHeight() + 1);
	if(!TilePixelRect.IsIn(pt))
		return;

	pTile = 0;
	for(y = 0; y < TileRect.Height() && !pTile; y ++){
		for(x = 0; x < TileRect.Width() && !pTile; x ++){
			TileID = (TileRect.top + y) * 16 + TileRect.left + x;
			if(TileID < 0 || TileID >= pTileSet->GetTileCount())
				continue;
			pTile = pTileSet->GetTile(TileID);
		}
	}
	if(!pTile)
		return;

	dlg.pTilePicture = &pTile->UnderPicture;
	dlg.TileID = TileID;
	dlg.TileHeight = pTile->Height;
	dlg.TileProp = pTile->Prop;

	if(dlg.DoModal(&App, MAKEINTRESOURCE(IDD_TileProp), this) == IDOK){
		for(y = 0; y < TileRect.Height(); y ++){
			for(x = 0; x < TileRect.Width(); x ++){
				TileID = (TileRect.top + y) * 16 + TileRect.left + x;
				if(TileID < 0 || TileID >= pTileSet->GetTileCount())
					continue;
				pTileSet->GetTile(TileID)->Height = dlg.TileHeight;
				pTileSet->GetTile(TileID)->Prop = dlg.TileProp;
			
			}
		}
	}

}


int cTileWindow::GetTileIDAtPt(int x, int y){
	int OrgX;
	int OrgY;
	int TileX;
	int TileY;
	int i;

	if(!pTileSet || pTileSet->GetTileCount() <= 0)
		return -1;

	OrgX = GetScrollPos(SB_HORZ);
	OrgY = GetScrollPos(SB_VERT);

	TileX = OrgX + x / (pTileSet->GetTileWidth() + 1);
	TileY = OrgY + y / (pTileSet->GetTileHeight() + 1);

	if(TileX >= 16 || TileY > pTileSet->GetTileCount() / 16)
		return -1;

	i = TileY * 16 + TileX;
	if(i >= 0 || i < pTileSet->GetTileCount()){
		return i;
	}

	return -1;
}


void cTileWindow::OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam){
}


void cTileWindow::NewTileSet(){
	pTileSet->Destroy();
	pTileSet->Create();
	RecalcScrollBars();
	Invalidate();

}

bool cTileWindow::LoadTileSet(LPCTSTR FileName){
	cMedium Medium;

	Medium.SetFileName(FileName);
	if(!Medium.Open(cMedium::OM_READ))
		return false;

	// ϴ  Ͱ ִٸ .
	pTileSet->Destroy();
	if(!pTileSet->Load(&Medium)){
		Medium.Close();
		pTileSet->Create();
		return false;
	}
	Medium.Close();
	RecalcScrollBars();
	Invalidate();
	return true;
}

bool cTileWindow::SaveTileSet(LPCTSTR FileName){
	cMedium Medium;

	Medium.SetFileName(FileName);
	if(!Medium.Open(cMedium::OM_WRITE))
		return false;

	if(!pTileSet->Save(&Medium)){
		Medium.Close();
		return false;
	}
	Medium.Close();
	return true;

}


void cTileWindow::SetTileSet(cTileSet *_pTileSet){
	pTileSet = _pTileSet;
}

cTileSet *cTileWindow::GetTileSet(){
	return pTileSet;
}

void cTileWindow::RecalcScrollBars(){
	SCROLLINFO si;
	cRect ClientRect;

	if(pTileSet && pTileSet->GetTileCount()){
		GetClientRect(ClientRect);

		si.cbSize = sizeof(SCROLLINFO);
		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = 15;
		si.nPage = ClientRect.bottom / pTileSet->GetTileWidth();
		SetScrollInfo(SB_HORZ, &si);

		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = pTileSet->GetTileCount() / 16;
		si.nPage = ClientRect.bottom / pTileSet->GetTileHeight();
		SetScrollInfo(SB_VERT, &si);
	}
}


void cTileWindow::DrawDragRect(cRect Rect){
	HDC hdc;

	hdc = GetDC();

	SetROP2(hdc, R2_NOTXORPEN);

	Rect.Normalize();

	::MoveToEx(hdc, Rect.left, Rect.top, 0);
	::LineTo(hdc, Rect.right, Rect.top); 
	::LineTo(hdc, Rect.right, Rect.bottom); 
	::LineTo(hdc, Rect.left, Rect.bottom); 
	::LineTo(hdc, Rect.left, Rect.top); 

	ReleaseDC(hdc);
}

cRect cTileWindow::GetTileRect(){
	return TileRect;
}

void cTileWindow::SetTilePropDrawing(bool bDrawing){
	TilePropDrawing = bDrawing;
}
