#ifndef cTileWindow_H
#define cTileWindow_H

#include "cWindow.h"
#include "cTileSet.h"
#include "cClipper.h"

class cTileWindow : public cWindow{
protected:
	// ڽ   .
	cTileSet *pTileSet;
	cClipper Clipper;
	HFONT hFont;
	HPEN hFramePen;

	// 巡 Ķ
	bool Dragging;
	cRect SelRect;
	cRect TileRect;
	bool TilePropDrawing		;

	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual char *GetClassName(){ return "cTileWindow"; }

	// Message Handlers
	bool OnClose(WPARAM wParam, LPARAM lParam);
	bool OnCreate(WPARAM wParam, LPARAM lParam);
	void OnDestroy(WPARAM wParam, LPARAM lParam);
	void OnSize(WPARAM wParam, LPARAM lParam);
	void OnPaint(WPARAM wParam, LPARAM lParam);
	void OnMouseMove(WPARAM wParam, LPARAM lParam);
	void OnLButtonDown(WPARAM wParam, LPARAM lParam);
	void OnLButtonUp(WPARAM wParam, LPARAM lParam);
	void OnRButtonUp(WPARAM wParam, LPARAM lParam);
	void OnKeyEvent(UINT uMsg, WPARAM wParam, LPARAM lParam);

	void RecalcScrollBars();

	int GetTileIDAtPt(int x, int y);

	void DrawDragRect(cRect Rect);


public:
	cTileWindow();
	virtual ~cTileWindow();
	static bool RegisterClass();

	void NewTileSet();
	bool LoadTileSet(LPCTSTR FileName);
	bool SaveTileSet(LPCTSTR FileName);
	void SetTileSet(cTileSet *_pTileSet);
	cTileSet *GetTileSet();

	cRect GetTileRect();
	void SetTilePropDrawing(bool bDrawing);
};

#endif
