#include "TOOL.h"
#include "TOOLDebug.h"

static FILE *DebugFile = NULL;

void TDOpen(char *FileName){
	DebugFile = fopen(FileName, "wt");
	TDPrintf("TOOL Debug Reporting\n"); 
}

void TDClose(){
	TDPrintf("END"); 
	fclose(DebugFile);
	DebugFile = NULL;
}

int TDPrintf(char *Format, ...){
   va_list argptr;
   int Count;

   if(!DebugFile) return 0;

   va_start(argptr, Format);
   Count = vfprintf(DebugFile, Format, argptr);
   va_end(argptr);

   return Count;
}

void TDLogErrorMessage(){
}

void DisplayLastErrorMessage(){
	char pszMessage[1024];
	DWORD dwError;

	dwError = GetLastError();
	FormatMessage(
		FORMAT_MESSAGE_FROM_SYSTEM,      // source and processing options
		NULL,   // message source
		dwError,  // message identifier
		0, // language identifier
		pszMessage,    // message buffer
		1024,        // maximum size of message buffer
		0);  // array of message inserts
	MessageBox(NULL, pszMessage, "System Error", MB_OK);
}

