#include "TOOL.h"
#include "TOOLGraphics.h"
#include "TOOLUtils.h"

void NormalizeRect(RECT &Rect){
	if(Rect.left > Rect.right) Swap(Rect.left, Rect.right);
	if(Rect.top > Rect.bottom) Swap(Rect.top, Rect.bottom);
}
BOOL IsNormalRect(RECT &Rect){
	if(Rect.left <= Rect.right && Rect.top <= Rect.bottom)
		return true;
	return false;
}

BOOL IsPointInRect(int x, int y, int Left, int Top, int Right, int Bottom){
	if(x < Left || x > Right || y < Top || y > Bottom)
		return false;
	return true;
}

BOOL IsPointInRect(int x, int y, RECT &Rect){
	if(x < Rect.left || x > Rect.right || y < Rect.top || y > Rect.bottom)
		return false;
	return true;
}


BOOL IsIntersectRect(RECT &r1, RECT &r2){
	if(r1.left > r2.right 
		|| r1.top > r2.bottom
		|| r1.right < r2.left
		|| r1.bottom < r2.top) return false;
	return true;
}

void FitInRect(RECT &r1, RECT &RefRect, RECT &r2){
	if(r1.left < RefRect.left){
		r2.left += RefRect.left - r1.left;
		r1.left = RefRect.left;
	}
	if(r1.top < RefRect.top){
		r2.top += RefRect.top - r1.top;
		r1.top = RefRect.top;
	}
	if(r1.right > RefRect.right){
		r2.right -= r1.right - RefRect.right;
		r1.right = RefRect.right;
	}
	if(r1.bottom > RefRect.bottom){
		r2.bottom -= r1.bottom - RefRect.bottom;
		r1.bottom = RefRect.bottom;
	}
}

