#ifndef cArray_H
#define cArray_H


template<class Type>
class cArray{
protected:
	Type *Elements;
	int ElementCount;

public:
	cArray();
	virtual ~cArray();

	bool Create(int Size);
	virtual void Destroy();

	void Copy(int DestIndex, int Size, cArray &a, int SrcIndex);

	void Set(int index, Type Element){ Elements[index] = Element; }
	Type& Get(int index){ return Elements[index]; }

	int GetCount(){ return ElementCount; }
	Type &operator[](int Index){ return Elements[Index]; }

	void Insert(Type a, int Index); // 迭 ԰  ū δΰ ??
	void Delete(int Index); 

	void ScrollUp();

};

template<class Type>
cArray<Type>::cArray(){
	Elements = 0;
}

template<class Type>
cArray<Type>::~cArray(){
//	Destroy();
	assert(!Elements);
//	if(Elements) delete [] Elements;
}

template<class Type>
bool cArray<Type>::Create(int Size){
	Elements = new Type[Size];
	ElementCount = Size;

	return Elements != 0;
}

template<class Type>
void cArray<Type>::Destroy(){
	delete [] Elements;
	Elements = 0;
}

template<class Type>
void cArray<Type>::Copy(int DestIndex, int Size, cArray<Type> &a, int SrcIndex){
	int i;

	for(i = 0; i < Size; i ++){
		Set(i + DestIndex, a.Get(i + SrcIndex));
	}
}

template<class Type>
void cArray<Type>::ScrollUp(){
	int i;

	for(i = 1; i < ElementCount; i ++){
		Elements[i - 1] = Elements[i];
	}

}

template <class Type>
void cArray<Type>::Insert(Type a, int Index){
	Type *OldElements;
	int OldElementCount;
	int i;

	if(Elements){
		// 𰡰 ִ 迭̾ٸ
		OldElements = Elements;
		OldElementCount = ElementCount;

		//   ϳ ū 迭 .
		Create(OldElementCount + 1);

		for(i = 0; i < Index; i ++)
			Set(i, OldElements[i]);
		Set(Index, a);
		for(i = Index; i < OldElementCount; i ++)
			Set(i + 1, OldElements[i]);

		delete [] OldElements;
	}else{
		//  ִ 迭 ̾ٸ
		Create(1);
		Set(0, a);
	}

}

template <class Type>
void cArray<Type>::Delete(int Index){
	Type *OldElements;
	int OldElementCount;
	int i;

	if(Elements){
		if(ElementCount >= 1){
			// 𰡰 ִ 迭̾ٸ
			OldElements = Elements;
			OldElementCount = ElementCount;

			//   ϳ  迭 .
			Create(OldElementCount - 1);

			for(i = 0; i < Index; i ++)
				Set(i, OldElements[i]);
			for(i = Index + 1; i < OldElementCount; i ++)
				Set(i - 1, OldElements[i]);

			delete [] OldElements;
		}else{
			Destroy();
		}
	}
}


/*
template<class Type>
bool cArray<Type>::Load(cMedium* pMedium){
	int i, Count;

	pMedium->Read(&Count, sizeof(int));
	if(Elements){ // ޸𸮰 Ҵ 
		if(Count > ElementCount) return false;
	}else{ // ޸𸮰 Ҵ  
		//  ޸𸮸 ҴѴ.
		if(!Create(Count)) return false;
	}
	// ޸𸮷 ͸ оδ.
	for(i = 0; i < Count; i ++)
		Elements[i].Load(pMedium);

	return true;
}

template<class Type>
bool cArray<Type>::Save(cMedium* pMedium){
	if(!Elements) return false;
	pMedium->Write(&ElementCount, sizeof(int));
	for(int i = 0; i < ElementCount; i ++)
		Elements[i].Save(pMedium);
	return true;
}

*/



#endif
