/*
	 2 迭
*/
#ifndef cArray2D_H
#define cArray2D_H

#include <windows.h>

template <class Type>
class cArray2D{
protected:
	Type *Elements;

	int Width;
	int Height;

public:
	cArray2D();
	virtual ~cArray2D();

	bool Create(int _Height, int _Width, bool Clear = false);
	virtual void Destroy();
	cArray2D &operator=(cArray2D &a);
	void Copy(int yDest, int xDest, cArray2D *pSrc, int ySrc, int xSrc, int w, int h);

	Type &Get(int y, int x){ return Elements[y * Width + x]; }
	Type *GetPointer(int y, int x);
	void Set(int y, int x, Type Element){ Elements[y * Width + x] = Element; }

	void Clear(Type Value);

	void Rectangle(int Left, int Top, int Right, int Bottom, Type Element);


	int GetWidth(){ return Width; }
	int GetHeight(){ return Height; }

};


template<class Type> 
cArray2D<Type>::cArray2D(){
	Elements = NULL;
}

template<class Type>
cArray2D<Type>::~cArray2D(){
	Destroy();
}

template<class Type>
bool cArray2D<Type>::Create(int _Height, int _Width, bool Clear){
	Width = _Width;
	Height = _Height;

	cArray2D<Type>::Destroy();
	Elements = new Type [ Width * Height ];
	if(!Elements)
		return false;

	return true;
}

template<class Type>
void cArray2D<Type>::Destroy(){
	if(Elements){
		delete [] Elements;
		Elements = NULL;
	}
}

template<class Type>
cArray2D<Type> &cArray2D<Type>::operator=(cArray2D<Type> &a){
	memcpy(Elements, a.Elements, sizeof(Type) * Width * Height); 
	return *this;
}

template<class Type>
void cArray2D<Type>::Copy(int yDest, int xDest, cArray2D<Type> *pSrc, int ySrc, int xSrc, int h, int w){
	int y, x;

	for(y = 0; y < h; y ++){
		for(x = 0; x < w; x ++){
			Set(y + yDest, x + xDest, pSrc->Get(y + ySrc, x + xSrc));
		}
	}
}

template<class Type>
Type *cArray2D<Type>::GetPointer(int y, int x){
	if(x < 0 || y < 0 || x >= Width || y >= Height)
		return NULL;
	return Elements + y * Width + x; 

}

template<class Type>
void cArray2D<Type>::Clear(Type Value){
	int y, x;

	for(y = 0; y < Height; y ++){
		for(x = 0; x < Width; x ++){
			Set(y, x, Value);
		}
	}
}

// Drawing Array
template<class Type>
void cArray2D<Type>::Rectangle(int Left, int Top, int Right, int Bottom, Type Element){
	int y, x;

	if(Left < 0) Left = 0;
	if(Top < 0) Top = 0;
	if(Right > Width) Right = Width;
	if(Bottom > Height) Bottom = Height;
	
	for(y = Top; y < Bottom; y ++){
		for(x = Left; x < Right; x ++){
			Set(y, x, Element);
		}
	}
}


#endif
