/*
	cArray3D
	3 迭
	øƮ      ִ.
	  :
	÷ ˻縦  ʽϴ.

*/
#ifndef H_cArray3D
#define H_cArray3D

template<class T> class cArray3D{
protected:
	T *Element;
	int zPitch, yPitch;
	int xSize, ySize, zSize;

public:
	cArray3D();
	~cArray3D();

	void Destroy(); // 迭 ıѴ.
	BOOL Create(int z, int y, int x); // 迭 
	void Set(int z, int y, int x, T &Data); // 迭 Ҹ 
	void Get(int z, int y, int x, T &Data); // Ҹ 
	T *GetPtr(int z, int y, int x); //  ͸ 	
	
		
};

template <class T> cArray3D<T>::cArray3D(){
	Element = null;
}

template <class T> cArray3D<T>::~cArray3D(){
	Destroy();
}

template <class T> void cArray3D<T>::Destroy(){
	if(Element) delete [] Element;
	Element = null;
}

template <class T> BOOL cArray3D<T>::Create(int z, int y, int x){
	Destroy(); // 迭 Ǿ Ȯ

	xSize = x; 
	ySize = y; 
	zSize = z;

	yPitch = xSize; 
	zPitch = xSize * ySize;

	Element = new T[x * y * z];

	return Element != null;
}

template <class T> void cArray3D<T>::Set(int z, int y, int x, T &Data){
	Element[z * zPitch + y * yPitch + x] = Data;
}


template <class T> void cArray3D<T>::Get(int z, int y, int x, T &Data){
	Data = Element[z * zPitch + y * yPitch + x];
}

template <class T> T *cArray3D<T>::GetPtr(int z, int y, int x){
	return &Element[z * zPitch + y * yPitch + x];
}

#endif