/*
	α׷ ڵ忡  .

	Recursion   ȭ ؼ §.

  

			 ̸ | ̸ [  ]
			 л | ڿ
	л	  | "-" 
			  ()*
	ڿ	 """ ڿ """
	ڿ		 <"    ">
	Ϲڿ	 <͸   >
	ּڿ	 <">?"  ʴ  ڿ>
	̸		 (ĺ | ѱ) (ĺ | ѱ | )*
	ĺ		 "A" - "Z" | "a" - "z"
	ѱ		 "" - "R"
			 "0" - "9"
	ĭ		 (" " |  | )*

			 ĭ | ""
			 ĭ | "" | ""
			 ĭ | "" | ""
			 ĭ | "" | ""
	

	ReservedWords
	, , , , , , , 

*/
#include "TOOL.h"
#include "cBabyLangLexer.h"

/*
// ڿ  񱳸   
bool operator==(const int& Integer, const char*& String){
	return Integer == (String[0] | (String[1] << 8));
}

bool operator!=(const int& Integer, const char*& String){
	return Integer != (String[0] | (String[1] << 8));
}

bool operator==(const char*& String, const int& Integer){
	return Integer == (String[0] | (String[1] << 8));
}

bool operator!=(const char*& String, const int& Integer){
	return Integer != (String[0] | (String[1] << 8));
}
*/
// Methods

cBabyLangLexer::cBabyLangLexer(){

}

cBabyLangLexer::~cBabyLangLexer(){

}


void cBabyLangLexer::SetCode(LPCTSTR _pCode){
	pCursor = pCode = _pCode;
	LineNumber = 0;
}


cBabyLangLexer::eLexeme cBabyLangLexer::GetLexeme(char* _pLexeme, int LexemeLength){
	eLexeme LexemeID;

	LexemeID = GetPureLexeme(_pLexeme, LexemeLength);
	_pLexeme[pLexeme - _pLexeme] = '\0';

	return LexemeID;
}

cBabyLangLexer::eLexeme cBabyLangLexer::GetPureLexeme(char* _pLexeme, int LexemeLength){
	enum eState{
		S_ALL, S_ID_OR_RESERVED_WORD, S_ID, S_NUMBER, S_REAL_NUMBER, S_STRING_VALUE, S_LINE_REMARK, 
		S_ASSIGN, S_LESS_THAN, S_GREATER_THAN,
	} State;

	pLexeme = _pLexeme;
	State = S_ALL;

	for(;;){
		switch(State){
		case S_ALL:
			if(!*pCursor)
				return L_END_OF_CODE;

			if(*pCursor & 0x80){ // ѱ 
				*pLexeme ++ = *pCursor ++;
				*pLexeme ++ = *pCursor ++;
				State = S_ID_OR_RESERVED_WORD;
			}else if(isalpha(*pCursor)){
				*pLexeme ++ = *pCursor ++;
				State = S_ID_OR_RESERVED_WORD;
			}else if(isdigit(*pCursor)){
				*pLexeme ++ = *pCursor ++;
				State = S_NUMBER;
			}else if(isspace(*pCursor)){
				if(*pCursor == '\n'){
					LineNumber ++;
//					*pLexeme ++ = *pCursor ++;
//					return L_SEMICOLON;
				}
//				*pLexeme ++;
				*pCursor ++;
			}else{
				switch(*pCursor){
				case '\"':
					State = S_STRING_VALUE;
					pCursor ++;
					break;
				case '?':
					State = S_LINE_REMARK;
					pCursor ++;
					break;
				case '(':
					*pLexeme ++ = *pCursor ++;
					return L_OPEN_ROUND_BRACKET;
				case ')':
					*pLexeme ++ = *pCursor ++;
					return L_CLOSE_ROUND_BRACKET;
				case '[':
					*pLexeme ++ = *pCursor ++;
					return L_OPEN_SQUARE_BRACKET;
				case ']':
					*pLexeme ++ = *pCursor ++;
					return L_CLOSE_SQUARE_BRACKET;
				case ',':
					*pLexeme ++ = *pCursor ++;
					return L_COMMA;
				case '.':
					*pLexeme ++ = *pCursor ++;
					return L_PERIOD;
				case ':':
					*pLexeme ++ = *pCursor ++;
					State = S_ASSIGN;
					break;
				case ';':
					*pLexeme ++ = *pCursor ++;
					return L_SEMICOLON;
				case '+':
					*pLexeme ++ = *pCursor ++;
					return L_PLUS;
				case '-':
					*pLexeme ++ = *pCursor ++;
					return L_MINUS;
				case '*':
					*pLexeme ++ = *pCursor ++;
					return L_STAR;
				case '/':
					*pLexeme ++ = *pCursor ++;
					return L_SLASH;
				case '=':
					*pLexeme ++ = *pCursor ++;
					return L_EQUAL;
				case '<':
					*pLexeme ++ = *pCursor ++;
					State = S_LESS_THAN;
					break;
				case '>':
					*pLexeme ++ = *pCursor ++;
					State = S_GREATER_THAN;
					break;
				default:
					*pLexeme ++ = *pCursor ++;
					return L_ERROR;
				}
			}
			break;
		case S_ID_OR_RESERVED_WORD:
			if(*pCursor & 0x80){ // ѱ 
				*pLexeme ++ = *pCursor ++;
				*pLexeme ++ = *pCursor ++;
			}else if(isalpha(*pCursor)){
				*pLexeme ++ = *pCursor ++;
			}else if(isdigit(*pCursor)){
				*pLexeme ++ = *pCursor ++;
			}else{
				//  ȿ ⼭ ID  ɾ ؼ Ѵ.
				*pLexeme = '\0';
				return GetReservedWordID(_pLexeme);
				
//				return L_ID;
			}
			break;
		case S_NUMBER:
			if(*pCursor == '.'){
				*pLexeme ++ = *pCursor ++;
				State = S_REAL_NUMBER;
				break;
			}
			if(!isdigit(*pCursor))
				return L_NUMBER;
			*pLexeme ++ = *pCursor ++;
			break;
		case S_REAL_NUMBER:
			if(!isdigit(*pCursor))
				return L_REAL_NUMBER;
			*pLexeme ++ = *pCursor ++;
			break;
		case S_STRING_VALUE:
			if(*pCursor == '\"'){
				pCursor ++;
				return L_STRING_VALUE;
			}
			if(*pCursor == '\\'){ // Ư ڵ ġȯ̴.
				pCursor ++;
				switch(*pCursor++){
				case 'n':
					*pLexeme++ = '\n';
					break;
				case 't':
					*pLexeme++ = '\t';
					break;
				default:
					return L_ERROR;
				}
				break;
			}else{
				*pLexeme ++ = *pCursor ++;
			}
			break;
		case S_ASSIGN:
			if(*pCursor == '='){
				*pLexeme ++ = *pCursor ++;
				return L_ASSIGN;
			}
			return L_ERROR;
		case S_LESS_THAN:
			switch(*pCursor){
			case '=': // <=
				*pLexeme ++ = *pCursor ++;
				return L_LESS_THAN_OR_EQUAL;
			case '>': // <>
				*pLexeme ++ = *pCursor ++;
				return L_NOT_EQUAL;
			}
			return L_LESS_THAN; // >
		case S_GREATER_THAN:
			if(*pCursor == '='){ // >=
				*pLexeme ++ = *pCursor ++;
				return L_GREATER_THAN;
			}
			return L_GREATER_THAN; // >
		case S_LINE_REMARK:
			pCursor ++;
			if(*pCursor == '\n' || *pCursor == '\0')
				State = S_ALL;

			break;
		}
	}
}

cBabyLangLexer::eLexeme cBabyLangLexer::GetReservedWordID(const char* _pLexeme){
	// ־  Ʊ⸻ Ǿ ˻Ͽ  ID  Ѵ.
	//  Ǿ ƴҰ L_ID  Ѵ.
	class cReservedWordInfo{
	public:
		const char* String;
		eLexeme ID;
	} ReservedWordInfos[] = {
		"", L_ASSIGN,
		"", L_ASSIGN,
		"Ǵ", L_OR, // Ǵ
		"׸", L_AND, // ׸
		"ƴϴ", L_NOT, // ƴϴ
		"Ѵ", L_OUTPUT,
		"Է¹޴´", L_INPUT,
		"", L_OBJECTIVE_PARTICLE, //
		"", L_OBJECTIVE_PARTICLE, 
		"", L_AND_PARTICLE,
		"", L_AND_PARTICLE,
//		"", L_BEGIN,
//		"", L_END,
		"", L_WHILE,
		"ε", L_WHILE,
		"ϵ", L_WHILE,
		"", L_IF,
		"", L_IF,
		"", L_THEN,
		"̸", L_THEN,
		"̶", L_THEN,
		"ϰ", L_THEN,
		"ƴϸ", L_ELSE,
		"", L_OPEN_ROUND_BRACKET,
		"", L_CLOSE_ROUND_BRACKET,

		0, L_ID,
	}, * pReservedWordInfo;

	pReservedWordInfo = ReservedWordInfos;

	while(pReservedWordInfo->String){
		if(strcmp(pReservedWordInfo->String, _pLexeme) == 0)
			return pReservedWordInfo->ID;
		pReservedWordInfo ++;
	}
		
	return L_ID;

}

cBabyLangLexer::cCursor cBabyLangLexer::GetCursor(){ 
	cCursor csr;
	csr.pChar = pCursor;
	csr.LineNumber = LineNumber;
	return csr; 
}

void cBabyLangLexer::SetCursor(cCursor csr){
	pCursor = csr.pChar; 
	LineNumber = csr.LineNumber;
}
