#ifndef cBabyLangLexer_H
#define cBabyLangLexer_H

class cBabyLangLexer{
public:
	enum eLexeme{ // FSA(Finite State Automata) 
		L_END_OF_CODE = 0,
		L_ERROR,
		L_SPACE,
		L_ID, // Hello
		L_NUMBER, // 1234
		L_REAL_NUMBER, // 3.14
		L_STRING_VALUE, // "String"
		L_OPEN_ROUND_BRACKET, // (
		L_CLOSE_ROUND_BRACKET, // )
		L_OPEN_SQUARE_BRACKET, // [
		L_CLOSE_SQUARE_BRACKET, // ]
		L_COMMA, // ,
		L_PERIOD, // .
		L_SEMICOLON, // ;
		L_ASSIGN, // :=
		L_OR, // Ǵ
		L_AND, // ׸
		L_NOT, // ƴϴ
		L_PLUS, // +
		L_MINUS, // -
		L_STAR, // *
		L_SLASH, // /
		L_EQUAL, // =
		L_NOT_EQUAL, // <>, ><
		L_LESS_THAN, // <
		L_GREATER_THAN, // >
		L_LESS_THAN_OR_EQUAL, // <=
		L_GREATER_THAN_OR_EQUAL, // >=
		// Reserved Words
//		L_BEGIN, // 
//		L_END, // 
		L_OUTPUT,
		L_INPUT,
		// 
		L_WHILE,
		L_IF,
		L_THEN,
		L_ELSE,
		// Particles
		L_OBJECTIVE_PARTICLE,
		L_AND_PARTICLE,
	};

	class cCursor{
	public:
		LPCTSTR pChar;
		int LineNumber;
	};

protected:
	LPCTSTR pCode; // α׷ ڵ
	LPCTSTR pCursor; //    ִ ġ
	int LineNumber;

	char* pLexeme; //  ϱ  ӽ 

	// Lexical Analyzers
	eLexeme GetPureLexeme(char* _pLexeme, int LexemeLength);
	eLexeme GetReservedWordID(const char* _pLexeme);

	cCursor GetCursor();
	void SetCursor(cCursor csr);

public:
	cBabyLangLexer();
	virtual ~cBabyLangLexer();

	void SetCode(LPCTSTR _pCode);

	eLexeme GetLexeme(char* _pLexeme, int LexemeLength);
	int GetLineNumber(){ return LineNumber; }




};

#endif
