/*

Ʊ⸻  
	Ʊ⸻ , ,  ̴.

	
		 Ư Ÿ   ʰ


	
		̹ ǵǾ ִ 
			Է 
				() Է¹޴´
					 Űκ Է ޴´.
			 
				() Ѵ
					 ȭ Ѵ.
			 
				 = 
				 = 
					 Ǵ   ִ´.
			
				   ״ .




	

Alternative Form of BNF Grammar for BabyLang

鵵 ϳ ڷ  Ѵ.

α׷	 
		 Թ | 񱳹 | ݺ | ø | ⺻ |  | ּ
⺻		   ĭ "Ѵ" |
				  ĭ "Է¹޴´" |
ּ		 "?" Ϲڿ | "?<" ּڿ ">?"

				
ø	 "" (ĭ  (ĭ ";" ĭ )* ) ĭ ""
Թ		  ĭ = ĭ ( |  ĭ "̴")
񱳹		 ("" | "") ĭ  ĭ ("" | "" | "̶" | "׷") ĭ 
				(ĭ ("ƴϸ" | "׷ ") ĭ )
ݺ		  (ĭ ("" | "ε" | "ϵ")) ĭ 
	  ( | )  

Ǵ¼	 ׸ ("Ǵ" ׸)*
׸	  ("׸" )*
	 ( | ( " ƴϴ"))
	  (("+" | "-") )*
	  (("*" | "/") )*
		  |  | ( "(" ĭ  ĭ")" )


 Ʈ ǥѴ.(Ǹ   Ȯϱ Ͽ)
 
	





		 ̸ | ̸ [  ]
		 л | ڿ
л	  | "-" 
		  ()*
ڿ	 """ ڿ """
ڿ		 <"    ">
Ϲڿ	 <͸   >
ּڿ	 <">?"  ʴ  ڿ>
̸		 (ĺ | ѱ) (ĺ | ѱ | )*
ĺ		 "A" - "Z" | "a" - "z"
ѱ		 "" - "R"
		 "0" - "9"
ĭ		 (" " |  | )*

		 ""
		 "" | ""
		 "" | ""
		 "" | ""
		 "" | ""

		 ̸ | "Ѵ" | "Է¹޴´" 


*/
#include "TOOL.h"
#include "cBabyLangMachine.h"
#include "cBinarySearchTree.cpp"

// cValue ////////////////////////////////////////////////////////////////////////
cBabyLangMachine::cValue::cValue(){
	Type = VT_NONE;
}

void cBabyLangMachine::cValue::Set(int _Number){
	Type = VT_NUMBER;
	Number = _Number;
}

void cBabyLangMachine::cValue::Set(double _RealNumber){
	Type = VT_REAL_NUMBER;
	RealNumber = _RealNumber;
}

void cBabyLangMachine::cValue::Set(LPCTSTR _String){
	Type = VT_STRING;
	String = _String;
}

void cBabyLangMachine::cValue::Set(cVariable* _pVariable){
	Type = VT_POINTER;
	pVariable = _pVariable;
}

cBabyLangMachine::cValue& cBabyLangMachine::cValue::operator=(bool b){
	Type = VT_NUMBER;
	Number = b;
	return *this;
}


bool cBabyLangMachine::cValue::operator||(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number || a.Number;
	case VT_REAL_NUMBER:
		return RealNumber || a.RealNumber;
	case VT_STRING:
		return String.GetLength() || a.String.GetLength();
	case VT_POINTER:
		return pVariable || a.pVariable;
	}
	return false;
}

bool cBabyLangMachine::cValue::operator&&(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number && a.Number;
	case VT_REAL_NUMBER:
		return RealNumber && a.RealNumber;
	case VT_STRING:
		return String.GetLength() && a.String.GetLength();
	case VT_POINTER:
		return pVariable && a.pVariable;
	}
	return false;
}

bool cBabyLangMachine::cValue::operator!(){
	switch(Type){
	case VT_NUMBER:
		return !Number;
	case VT_REAL_NUMBER:
		return !RealNumber;
	case VT_STRING:
		return !String.GetLength();
	case VT_POINTER:
		return !pVariable;
	}
	return false;
}

bool cBabyLangMachine::cValue::operator==(bool b){
	if(b){
		switch(Type){
		case VT_NUMBER:
			return Number != 0;
		case VT_REAL_NUMBER:
			return RealNumber != 0.0;
		case VT_STRING:
			return String.GetLength() != 0;
		}
	}else{
		switch(Type){
		case VT_NUMBER:
			return Number == 0;
		case VT_REAL_NUMBER:
			return RealNumber == 0;
		case VT_STRING:
			return String.GetLength() == 0;
		}
	}
	return false;
}

bool cBabyLangMachine::cValue::operator!=(bool b){
	return operator==(!b);
}

bool cBabyLangMachine::cValue::operator==(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number == a.Number;
	case VT_REAL_NUMBER:
		return RealNumber == a.RealNumber;
	case VT_STRING:
		return String == a.String;
	}
	return false;
}

bool cBabyLangMachine::cValue::operator!=(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number != a.Number;
	case VT_REAL_NUMBER:
		return RealNumber != a.RealNumber;
	case VT_STRING:
		return String != a.String;
	}
	return false;
}

bool cBabyLangMachine::cValue::operator<(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number < a.Number;
	case VT_REAL_NUMBER:
		return RealNumber < a.RealNumber;
	case VT_STRING:
		return String < a.String;
	}
	return false;
}
bool cBabyLangMachine::cValue::operator>(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number > a.Number;
	case VT_REAL_NUMBER:
		return RealNumber > a.RealNumber;
	case VT_STRING:
		return String > a.String;
	}
	return false;
}
bool cBabyLangMachine::cValue::operator<=(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number <= a.Number;
	case VT_REAL_NUMBER:
		return RealNumber <= a.RealNumber;
	case VT_STRING:
		return String <= a.String;
	}
	return false;
}
bool cBabyLangMachine::cValue::operator>=(cValue& a){
	switch(Type){
	case VT_NUMBER:
		return Number >= a.Number;
	case VT_REAL_NUMBER:
		return RealNumber >= a.RealNumber;
	case VT_STRING:
		return String >= a.String;
	}
	return false;
}

cBabyLangMachine::cValue cBabyLangMachine::cValue::operator+(cValue& a){
	cValue c;

	switch(Type){
	case VT_NUMBER:
		c.Set(Number + a.Number);
		return c;
	case VT_REAL_NUMBER:
		c.Set(RealNumber + a.RealNumber);
		return c;
	case VT_STRING:
		c.Set(String + a.String);
		return c;
	}
	return c;
}

cBabyLangMachine::cValue cBabyLangMachine::cValue::operator-(cValue& a){
	cValue c;

	switch(Type){
	case VT_NUMBER:
		c.Set(Number - a.Number);
		return c;
	case VT_REAL_NUMBER:
		c.Set(RealNumber - a.RealNumber);
		return c;
	}
	return c;
}

cBabyLangMachine::cValue cBabyLangMachine::cValue::operator*(cValue& a){
	cValue c;

	switch(Type){
	case VT_NUMBER:
		c.Set(Number * a.Number);
		return c;
	case VT_REAL_NUMBER:
		c.Set(RealNumber * a.RealNumber);
		return c;
	}
	return c;
}

cBabyLangMachine::cValue cBabyLangMachine::cValue::operator/(cValue& a){
	cValue c;

	switch(Type){
	case VT_NUMBER:
		c.Set(Number / a.Number);
		return c;
	case VT_REAL_NUMBER:
		c.Set(RealNumber / a.RealNumber);
		return c;
	}
	return c;
}



// cVariable  ////////////////////////////////////////////////////////////////////////

void cBabyLangMachine::cVariable::SetName(LPCTSTR _Name){
	Name = _Name;
}

void cBabyLangMachine::cVariable::SetValue(cValue* pValue){
	Value = *pValue;
}

LPCTSTR cBabyLangMachine::cVariable::GetName(){
	return Name;
}

cBabyLangMachine::cValue* cBabyLangMachine::cVariable::GetValue(){
	return &Value;
}

bool cBabyLangMachine::cVariable::operator==(cVariable& a){
	return Name == a.Name;
}

bool cBabyLangMachine::cVariable::operator>(cVariable& a){
	return Name > a.Name;
}

bool cBabyLangMachine::cVariable::operator<(cVariable& a){
	return Name < a.Name;
}


// cBabyLangMachine  ////////////////////////////////////////////////////////////////////////

enum eBabyLangError{
	BLE_OK,
	BLE_SYNTAX,
	BLE_UNEXPECTED_CODE,
	BLE_NEED_VERB,
	BLE_EMPTY_VARIABLE,
	BLE_CALCULATE,
	BLE_CLOSE_ROUND_BRACKET_NEEDED,
	BLE_NEED_THEN_OR_ELSE,
	BLE_INFINITE_LOOP,
	BLE_COUNT
};

const char* cBabyLangMachine::GetErrorString(int ErrorNo){
	const int ErrorCount = BLE_COUNT;
	static const char* ErrorStrings[ErrorCount] = {
		" ϴ", 
		"  ֽϴ",
		"߰ ڵ尡 ֽϴ ׷  ʾҽϴ",
		"簡 ʿմϴ",
		"  ʾҽϴ",
		" 갪  ֽϴ\n0  ʾҳ ȮϽʽÿ",
		"')'  ʿմϴ",
		" ̰ų  쿡  ó ʿմϴ",
		"  ϴ.\nǽ ȮϽʽÿ",

	};

	if(ErrorNo < 0 || ErrorNo >= ErrorCount)
		ErrorNo = 0;

	return ErrorStrings[ErrorNo];
}


cBabyLangMachine::cBabyLangMachine(){

}

cBabyLangMachine::~cBabyLangMachine(){

}

int cBabyLangMachine::ExecuteCode(LPCTSTR pCode, cInputDevice* _pInput, cOutputDevice* _pOutput){
	// ־ ڿ ڵ带    ִ ɷ .
	int ErrorCode;

	pInput = _pInput;
	pOutput = _pOutput;

	SetCode(pCode);
	// Program -> Statement
	ErrorCode = Statement();
	if(ErrorCode)
		return ErrorCode;
	if(GetLexeme(Lexeme, 256) != L_END_OF_CODE)
		return BLE_UNEXPECTED_CODE;
	return ErrorCode;
}

// It's Compile Time !! ///////////////////////////////////////////////////////////////////
// ڵ ʹ Ƿ Ϻκи  𸥴.

int cBabyLangMachine::NestedStatement(){
// ø -> ""  (޸ )* "";
	eLexeme LexemeID;
	int ErrorCode;

	if(GetLexeme(Lexeme, 256) != L_OPEN_ROUND_BRACKET)
		return BLE_SYNTAX;


	ErrorCode = Statement();
	if(ErrorCode)
		return ErrorCode;

	LexemeID = GetLexeme(Lexeme, 256);
	while(LexemeID == L_COMMA){
		ErrorCode = Statement();
		if(ErrorCode)
			return ErrorCode;
		LexemeID = GetLexeme(Lexeme, 256);
	}

	if(LexemeID != L_CLOSE_ROUND_BRACKET)
		return BLE_SYNTAX;
	return BLE_OK;

}

int cBabyLangMachine::Statement(){
//	 -> ־  籸
	int ErrorCode;
	cVariable Variable;
	cCursor OldCursor;
	cCursor LoopStart, LoopEnd;
	int LoopDepth = 0;

	// ־    ͵ ó
	LoopStart = OldCursor = GetCursor();
	switch(GetLexeme(Lexeme, 256)){
	case L_END_OF_CODE:
		return BLE_OK;
	// þ
	case L_OPEN_ROUND_BRACKET:
		SetCursor(OldCursor);
		return NestedStatement();
	case L_IF:
		SetCursor(OldCursor);
		return IfStatement();
	}
	Variable.SetName(Lexeme);

	// ־ ó
	SetCursor(OldCursor);
	if(ErrorCode = Subject())
		return ErrorCode;

	// ֿ    
	OldCursor = GetCursor();
	switch(GetLexeme(Lexeme, 256)){
	case L_ASSIGN: // Թ 򰡵, Թ 簡   Ѵ.
		delete SystemStack.GetTail();
		SystemStack.RemoveTail();
		if(ErrorCode = Expression()) //  Ѵ.
			return ErrorCode;
		VariableTree.GetRef(Variable).SetValue(SystemStack.GetTail()); //    Ѵ.
		delete SystemStack.GetTail();
		SystemStack.RemoveTail();
		return BLE_OK;
	case L_WHILE: // ϵ,   Ѵ.
		while(*SystemStack.GetTail() == true){
			delete SystemStack.GetTail();
			SystemStack.RemoveTail();
			LoopDepth ++;
			if(LoopDepth > 1000) // ѷ Ѵ.
				return BLE_INFINITE_LOOP;
			if(ErrorCode = Statement())
				return ErrorCode;
			LoopEnd = GetCursor();
			SetCursor(LoopStart);
			if(ErrorCode = Expression())
				return ErrorCode;
			GetLexeme(Lexeme, 256); // ϵ  ĽѴ.
		}
		delete SystemStack.GetTail();
		SystemStack.RemoveTail();
		SetCursor(LoopEnd);
		return BLE_OK;
	//  Ѵ.
	case L_COMMA:
	case L_AND_PARTICLE: // ,  , 
	case L_OBJECTIVE_PARTICLE: //  
		SetCursor(OldCursor);
		if(ErrorCode = Objective())
			return ErrorCode;
		break;
	default: // ǵ     Ѵ.
		return BLE_SYNTAX;
	}

	// 籸 óѴ.
	return Verb();
}

int cBabyLangMachine::IfStatement(){
// 񱳹 ->    
	int ErrorCode;
	cVariable Variable;
	cCursor OldCursor;

	// ־    ͵ ó
	if(GetLexeme(Lexeme, 256) != L_IF)
		return BLE_SYNTAX;
	if(ErrorCode = Expression())
		return ErrorCode;
	if(*SystemStack.GetTail() == true){
		delete SystemStack.GetTail();
		SystemStack.RemoveTail();
		OldCursor = GetCursor();
		if(GetLexeme(Lexeme, 256) == L_THEN){
			if(ErrorCode = Statement())
				return ErrorCode;
		}else{
			SetCursor(OldCursor);
		}
		// 'ƴϸ'  ׳ Ѿ.
		if(ErrorCode = SkipStatementForElse())
			return ErrorCode;
		return BLE_OK;
	}else{
		delete SystemStack.GetTail();
		SystemStack.RemoveTail();
		// '̸'  ׳ Ѿ.
		if(ErrorCode = SkipStatementForThen())
			return ErrorCode;
		OldCursor = GetCursor();
		if(GetLexeme(Lexeme, 256) == L_ELSE){
			if(ErrorCode = Statement())
				return ErrorCode;
		}else{
			SetCursor(OldCursor);
		}
		return BLE_OK;
	}
	return BLE_NEED_THEN_OR_ELSE;
}

int cBabyLangMachine::SkipStatementForThen(){
//	 پ Ѿ -> ־  籸
	int NestedCount = 0;
	eLexeme LexemeID;
	cVariable Variable;
	cCursor OldCursor;

	for(;;){
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
		switch(LexemeID){
		case L_END_OF_CODE:
			return BLE_OK;
		case L_ELSE:
			if(NestedCount == 0){
				SetCursor(OldCursor);
				return BLE_OK;
			}
		case L_OPEN_ROUND_BRACKET:
			NestedCount ++;
			break;
		case L_CLOSE_ROUND_BRACKET:
			NestedCount --;
			break;
		}
	}
}

int cBabyLangMachine::SkipStatementForElse(){
//	 پ Ѿ -> ־  籸
	int NestedCount = 0;
	eLexeme LexemeID;
	cVariable Variable;
	cCursor OldCursor;
	bool InIf;

	for(;;){
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
		switch(LexemeID){
		case L_END_OF_CODE:
			return BLE_OK;
		case L_THEN:
			if(NestedCount == 0){
				InIf = false;
			}
			break;
		case L_ELSE:
			if(NestedCount == 0){
				if(GetLexeme(Lexeme, 256) == L_IF){
					InIf = true;
				}
			}
			break;
		case L_OPEN_ROUND_BRACKET:
			NestedCount ++;
			break;
		case L_COMMA:
			if(NestedCount == 0){
				SetCursor(OldCursor);
				return BLE_OK;
			}
			break;

		case L_CLOSE_ROUND_BRACKET:
			if(NestedCount == 0 && !InIf){
				SetCursor(OldCursor);
				return BLE_OK;
			}
			NestedCount --;
			break;
		}
	}
}


int cBabyLangMachine::Subject(){
//	־ -> ( |  | e)
	int ErrorCode;
//	cValue* pValue;
	cCursor OldCursor;


	OldCursor = GetCursor();
	switch(GetLexeme(Lexeme, 256)){ // ־   ִ ҵ
	case L_END_OF_CODE:
		return BLE_OK;
	// ־  ̴.
	case L_ID:
		if(ErrorCode = EvaluateIdentifier(Lexeme))
			return ErrorCode;
		SetCursor(OldCursor);
		return Expression();
	// ־  ̴,   Ѵ.
	case L_STRING_VALUE:
	case L_NUMBER:
	case L_REAL_NUMBER:
		SetCursor(OldCursor);
		return Expression();
	}
	SetCursor(OldCursor);
	return BLE_OK;
}

int cBabyLangMachine::Objective(){
	//   
	int ErrorCode;
	eLexeme LexemeID;

	LexemeID = GetLexeme(Lexeme, 256);

	while(LexemeID == L_AND_PARTICLE || LexemeID == L_COMMA){ //   ĽѴ.
		if(ErrorCode = Expression()) //AddValueIntoSystemStack();
			return ErrorCode;
		LexemeID = GetLexeme(Lexeme, 256);
	}

	if(LexemeID != L_OBJECTIVE_PARTICLE) //   Ľ
		return BLE_SYNTAX;

	return BLE_OK;
}

int cBabyLangMachine::AddValueIntoSystemStack(){
//   ý ÿ Ѵ.
	cVariable Variable;
	cValue* pValue;

	switch(GetLexeme(Lexeme, 256)){
	case L_STRING_VALUE:
		pValue = new cValue;
		pValue->Set(Lexeme);
		SystemStack.AddTail(pValue);
		return BLE_OK;
	case L_NUMBER:
		pValue = new cValue;
		pValue->Set(atoi(Lexeme));
		SystemStack.AddTail(pValue);
		return BLE_OK;
	case L_REAL_NUMBER:
		pValue = new cValue;
		pValue->Set(atof(Lexeme));
		SystemStack.AddTail(pValue);
		return BLE_OK;
	case L_ID:
		Variable.SetName(Lexeme);
		if(!VariableTree.IsIn(Variable))
			break;
		if(!AddVariableValueIntoSystemStack(&VariableTree.GetRef(Variable)))
			return BLE_EMPTY_VARIABLE;
		return BLE_OK;

	}
	return BLE_SYNTAX;
}

bool cBabyLangMachine::AddVariableValueIntoSystemStack(cVariable* pVariable){
	cValue* pValue;

	pValue = new cValue;
	*pValue = *pVariable->GetValue();
	SystemStack.AddTail(pValue);

	return true;	
}


int cBabyLangMachine::OutputRoutine(){
	// ý    Ѵ.
	cValue* pValue;

	while(SystemStack.GetCount()){
		pValue = SystemStack.GetHead();
		SystemStack.RemoveHead();
		switch(pValue->GetType()){
		case VT_NUMBER:
			pOutput->Printf("%d", (int)*pValue);
			break;
		case VT_REAL_NUMBER:
			pOutput->Printf("%f", (double)*pValue);
			break;
		case VT_STRING:
			pOutput->Printf("%s", (LPCTSTR)*pValue);
			break;
		}
		delete pValue;

	}
	return BLE_OK;
}

int cBabyLangMachine::Verb(){
	// 
	switch(GetLexeme(Lexeme, 256)){
	case L_OUTPUT:
		return OutputRoutine();
	}
	return BLE_NEED_VERB;
}

int cBabyLangMachine::Expression(){ // Ǵ 
// Ǵ¼	 ׸ ("Ǵ" ׸)*
	int ErrorCode;
	eLexeme LexemeID;
	cCursor OldCursor;

	if(ErrorCode = AndExpression())
		return ErrorCode;

	OldCursor = GetCursor();
	LexemeID = GetLexeme(Lexeme, 256);

	while(LexemeID == L_OR){
		if(ErrorCode = AndExpression())
			return ErrorCode;
		// ⼭   Ѵ.
		if(!SolveSystemStack(LexemeID))
			return BLE_CALCULATE;
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
	}

	SetCursor(OldCursor);
	return BLE_OK;
}

int cBabyLangMachine::AndExpression(){ // ׸ 
// ׸	  ("׸" )*
	int ErrorCode;
	eLexeme LexemeID;
	cCursor OldCursor;

	if(ErrorCode = NotExpression())
		return ErrorCode;

	OldCursor = GetCursor();
	LexemeID = GetLexeme(Lexeme, 256);

	while(LexemeID == L_AND){
		if(ErrorCode = NotExpression())
			return ErrorCode;
		// ⼭   Ѵ.
		if(!SolveSystemStack(LexemeID))
			return BLE_CALCULATE;
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
	}

	SetCursor(OldCursor);
	return BLE_OK;
}
int cBabyLangMachine::NotExpression(){ // ƴϴ 
// 	 (񱳼 | (񱳼 " ƴϴ"))
// 񱳼	  (("=" | "<" | ">" | "<=" | ">=") )*
	int ErrorCode;
	eLexeme LexemeID;
	cCursor OldCursor;

	if(ErrorCode = CompareExpression())
		return ErrorCode;

	OldCursor = GetCursor();
	LexemeID = GetLexeme(Lexeme, 256);

	if(LexemeID == L_NOT){
		// ⼭   Ѵ.
		if(!SolveSystemStack(LexemeID))
			return BLE_CALCULATE;
		return BLE_OK;
	}
	SetCursor(OldCursor);
	return BLE_OK;
}

int cBabyLangMachine::CompareExpression(){ //  
// 񱳼	  (("=" | "<" | ">" | "<=" | ">=") )*
	int ErrorCode;
	eLexeme LexemeID;
	cCursor OldCursor;

	if(ErrorCode = PlusExpression())
		return ErrorCode;

	OldCursor = GetCursor();
	LexemeID = GetLexeme(Lexeme, 256);

	while(LexemeID == L_EQUAL || LexemeID == L_NOT_EQUAL ||
		LexemeID == L_LESS_THAN || LexemeID == L_GREATER_THAN ||
		LexemeID == L_LESS_THAN_OR_EQUAL || LexemeID == L_GREATER_THAN_OR_EQUAL){
		if(ErrorCode = PlusExpression())
			return ErrorCode;
		// ⼭   Ѵ.
		if(!SolveSystemStack(LexemeID))
			return BLE_CALCULATE;
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
	}

	SetCursor(OldCursor);
	return BLE_OK;

}
int cBabyLangMachine::PlusExpression(){ //  
// 	  (("+" | "-") )*
	int ErrorCode;
	eLexeme LexemeID;
	cCursor OldCursor;

	if(ErrorCode = StarExpression())
		return ErrorCode;

	OldCursor = GetCursor();
	LexemeID = GetLexeme(Lexeme, 256);

	while(LexemeID == L_PLUS || LexemeID == L_MINUS){
		if(ErrorCode = StarExpression())
			return ErrorCode;
		// ⼭   Ѵ.
		if(!SolveSystemStack(LexemeID))
			return BLE_CALCULATE;
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
	}

	SetCursor(OldCursor);
	return BLE_OK;
}
int cBabyLangMachine::StarExpression(){ // 
// 	  (("*" | "/") )*
	int ErrorCode;
	eLexeme LexemeID;
	cCursor OldCursor;

	if(ErrorCode = ValueExpression())
		return ErrorCode;

	OldCursor = GetCursor();
	LexemeID = GetLexeme(Lexeme, 256);

	while(LexemeID == L_STAR || LexemeID == L_SLASH){
		if(ErrorCode = ValueExpression())
			return ErrorCode;
		// ⼭   Ѵ.
		if(!SolveSystemStack(LexemeID))
			return BLE_CALCULATE;
		OldCursor = GetCursor();
		LexemeID = GetLexeme(Lexeme, 256);
	}
	// ⼭   ǵ.
	SetCursor(OldCursor);
	return BLE_OK;
}

int cBabyLangMachine::ValueExpression(){
//	 -> "("  ")" | 
	int ErrorCode;
	eLexeme LexemeID;
	cVariable Variable;
	cValue* pValue;

	LexemeID = GetLexeme(Lexeme, 256);
	if(LexemeID == L_OPEN_ROUND_BRACKET){
		if(ErrorCode = Expression())
			return ErrorCode;
		LexemeID = GetLexeme(Lexeme, 256);
		if(LexemeID == L_CLOSE_ROUND_BRACKET)
			return BLE_OK;
		return BLE_CLOSE_ROUND_BRACKET_NEEDED;
	}

	//   ý ÿ Ѵ.
	switch(LexemeID){
	case L_STRING_VALUE:
		pValue = new cValue;
		pValue->Set(Lexeme);
		SystemStack.AddTail(pValue);
		return BLE_OK;
	case L_NUMBER:
		pValue = new cValue;
		pValue->Set(atoi(Lexeme));
		SystemStack.AddTail(pValue);
		return BLE_OK;
	case L_REAL_NUMBER:
		pValue = new cValue;
		pValue->Set(atof(Lexeme));
		SystemStack.AddTail(pValue);
		return BLE_OK;
	case L_ID:
		Variable.SetName(Lexeme);
		if(!VariableTree.IsIn(Variable))
			break;
		if(!AddVariableValueIntoSystemStack(&VariableTree.GetRef(Variable)))
			return BLE_EMPTY_VARIABLE;
		return BLE_OK;

	}
	return BLE_SYNTAX;
}

int cBabyLangMachine::EvaluateIdentifier(LPCTSTR Lexeme){
//  ۵
	cVariable Variable;

	Variable.SetName(Lexeme);
	if(!VariableTree.IsIn(Variable)){ 
		// ο ٸ, ̺ ߰Ѵ.
		VariableTree.Add(Variable);
	}
	return BLE_OK;
}

bool cBabyLangMachine::SolveSystemStack(eLexeme Operator){
	cValue* pa, * pb, * pc;

	switch(Operator){
	case L_OR:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = (*pa) || (*pb);
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_AND:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa && *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_NOT:
		SystemStack.GetTail()->operator!();
		return true;
	case L_EQUAL:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa == *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_NOT_EQUAL:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa != *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_LESS_THAN:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa < *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_GREATER_THAN:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa > *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_LESS_THAN_OR_EQUAL:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa <= *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_GREATER_THAN_OR_EQUAL:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa >= *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_PLUS:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa + *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_MINUS:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa - *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_STAR:
		pc = new cValue;
		pb = SystemStack.GetTail();
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa * *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	case L_SLASH:
		pb = SystemStack.GetTail();
		if(pb->GetType() == VT_NUMBER){
			if((int)*pb == 0)
				return false;
		}else if(pb->GetType() == VT_REAL_NUMBER){
			if((double)*pb == 0)
				return false;
		}
		pc = new cValue;
		SystemStack.RemoveTail();
		pa = SystemStack.GetTail();
		SystemStack.RemoveTail();
		*pc = *pa / *pb;
		SystemStack.AddTail(pc);
		delete pa;
		delete pb;
		return pc->GetType() != VT_NONE;
	}
	return false;
}
