#ifndef cBabyLangMachine_H
#define cBabyLangMachine_H

#include "cBabyLangLexer.h"
#include "cInputDevice.h"
#include "cOutputDevice.h"
#include "cString.h"
#include "cList.h"
#include "cBinarySearchTree.h"

class cBabyLangMachine : private cBabyLangLexer{
public:
	enum eVariableType{
		VT_NONE,
		VT_NUMBER,
		VT_REAL_NUMBER,
		VT_STRING,
		VT_POINTER
	};

	class cVariable;
	class cValue{
	protected:
		eVariableType Type;

		union{
			int Number;
			double RealNumber;
			cVariable* pVariable;
		};
		cString String;
	public:
		cValue();
		
		eVariableType GetType(){ return Type; }
		operator eVariableType(){ return Type; }
		operator int(){ return Number; }
		operator double(){ return RealNumber; }
		operator LPCTSTR(){ return String; }

		void Set(int _Number);
		void Set(double _RealNumber);
		void Set(LPCTSTR _String);
		void Set(cVariable* _pVariable);

		cValue& operator=(bool b);

		bool operator||(cValue& a);
		bool operator&&(cValue& a);
		bool operator!();

		bool operator==(cValue& a);
		bool operator!=(cValue& a);
		bool operator<(cValue& a);
		bool operator>(cValue& a);
		bool operator<=(cValue& a);
		bool operator>=(cValue& a);

		bool operator==(bool b);
		bool operator!=(bool b);


		cValue operator+(cValue& a);
		cValue operator-(cValue& a);
		cValue operator*(cValue& a);
		cValue operator/(cValue& a);

	};

	class cVariable{
	protected:
		cString Name;
		cValue Value;
	public:
		void SetName(LPCTSTR _Name);
		void SetValue(cValue* pValue);

		LPCTSTR GetName();
		cValue* GetValue();

		bool operator==(cVariable& a);
		bool operator>(cVariable& a);
		bool operator<(cVariable& a);
		
	};



protected:

	// Machine Resources
	// Registers
	cValue Accumulator;

	char Lexeme[256];

	// Stack
	typedef cList<cValue*> cValueList;
	cValueList SystemStack;
	//  ̺
	typedef cBinarySearchTree<cVariable> cVariableTree;
	cVariableTree VariableTree;

	cInputDevice* pInput;
	cOutputDevice* pOutput;

	// System Routines
	int OutputRoutine();
	// Compiling,   ߻ϸ ڵ带 ǵ.
	//  ٸ ڵ带 Ѵ. 
	int Statement();
	int SkipStatementForThen();
	int SkipStatementForElse();
//	int DirectObjectiveStatement();
	int NestedStatement();
	int IfStatement();

	int Subject();
	int Objective();
	int Verb();
	int AddValueIntoSystemStack(); //   ý ÿ Ѵ.
	bool AddVariableValueIntoSystemStack(cVariable* pVariable);

	int Expression(); // Ǵ 
	int AndExpression(); // ׸ 
	int NotExpression(); // ƴϴ 
	int CompareExpression(); //  
	int PlusExpression(); //  
	int StarExpression(); // 
	int ValueExpression(); // 

	int EvaluateIdentifier(LPCTSTR Lexeme);
	bool SolveSystemStack(eLexeme Operator);

public:
	static const char* GetErrorString(int ErrorNo);
	cBabyLangMachine();
	virtual ~cBabyLangMachine();

	int ExecuteCode(LPCTSTR pCode, cInputDevice* _pInput, cOutputDevice* _pOutput); // ־ ڵ带 
	int GetLineNumber(){ return cBabyLangLexer::GetLineNumber(); }

};

#endif
