#include "TOOL.h"
#include "cBinarySearchTree.h"

//////////////////////////////////////////////////////////////
//////////////////////////// cBinarySearchTree Node ///////////////////////
//////////////////////////////////////////////////////////////
template<class T> cBinarySearchTreeNode<T>::cBinarySearchTreeNode(){
	Parent = Left = Right = NULL;
}

template<class T> cBinarySearchTreeNode<T>::~cBinarySearchTreeNode(){
	Clear();
}

template<class T> void cBinarySearchTreeNode<T>::Clear(){
	if(Left) delete Left;
	Left = NULL;
	if(Right) delete Right;
	Right = NULL;
}
///////////////////////// Set, Add, Get ////////////////////
template<class T> void cBinarySearchTreeNode<T>::Set(T &nData){
	Data = nData;
}
template<class T> bool cBinarySearchTreeNode<T>::Add(T &nData){
	if(Data == nData){
		Data = nData;
		return true;
	}
	if(Data > nData){
		if(Left){
			Left->Add(nData);
		}else{
			Left = new cBinarySearchTreeNode<T>;
			if(!Left) return false;
			Left->Set(nData);
		}
	}else{
		if(Right){
			Right->Add(nData);
		}else{
			Right = new cBinarySearchTreeNode<T>;
			if(!Right) return false;
			Right->Set(nData);
		}
	}
	return true;
}

template<class T> bool cBinarySearchTreeNode<T>::Get(T &nData){
	if(Data == nData){
		nData = Data;
		return true;
	}
	if(nData < Data){
		if(Left) return Left->Get(nData);
		return false;
	}
	if(Right) return Right->Get(nData);
	return false;
}

template<class T> T& cBinarySearchTreeNode<T>::GetRef(T& nData){
	if(Data == nData){
		return Data;
	}
	if(nData < Data){
		if(Left) return Left->GetRef(nData);
		return nData;
	}
	if(Right) return Right->GetRef(nData);
	return nData;
}

template<class T> bool cBinarySearchTreeNode<T>::LinearGet(T &nData){
	if(Data == nData){
		nData = Data;
		return true;
	}
	if(Left && Left->LinearGet(nData)) return true;
	if(Right && Right->LinearGet(nData)) return true;
	return false;
}

template<class T> bool cBinarySearchTreeNode<T>::IsIn(T &nData){
	if(Data == nData) return true;

	if(nData < Data){
		if(Left) return Left->IsIn(nData);
		return false;
	}
	if(Right) return Right->IsIn(nData);
	return false;
}

template<class T> void cBinarySearchTreeNode<T>::Print(){
	if(Left) Left->Print();
	Data.Print();
	if(Right) Right->Print();

}

//////////////////////////////////////////////////////////////
/////////////////////////// cBinarySearchTree ////////////////////////////
//////////////////////////////////////////////////////////////
template<class T> cBinarySearchTree<T>::cBinarySearchTree(){
	Root = NULL;
}

template<class T> cBinarySearchTree<T>::~cBinarySearchTree(){
	Clear();
}

template<class T> void cBinarySearchTree<T>::Clear(){
	if(Root) delete Root;
	Root = NULL;
}
//////////////////////// Add, Get ////////////////////////////
template<class T> bool cBinarySearchTree<T>::Add(T &nData){
	if(Root) return Root->Add(nData);
	Root = new cBinarySearchTreeNode<T>;
	if(!Root) return false;
	Root->Set(nData);
	return true;
}

template<class T> bool cBinarySearchTree<T>::Get(T &Key){
	if(Root) return Root->Get(Key);
	return false;
}

template<class T> T& cBinarySearchTree<T>::GetRef(T &Key){
	if(Root) return Root->GetRef(Key);
	return Key;
}

template<class T> bool cBinarySearchTree<T>::LinearGet(T &Key){
	if(Root) return Root->LinearGet(Key);
	return false;
}

template<class T> bool cBinarySearchTree<T>::IsIn(T &Key){
	if(Root) return Root->IsIn(Key);
	return false;
}

template<class T> void cBinarySearchTree<T>::Print(){
	if(Root) Root->Print();
}

