#include "TOOL.h"
#include "cBumpDetector.h"

/*
	cBumpData 
*/

template <class Type>
cBumpData<Type>::cBumpData(cVector3D<Type> *_pPosition, Type *_pRadius, void *_pObject){
	pPosition = _pPosition;
	pRadius = _pRadius;
	pObject = _pObject;
}

template <class Type>
bool cBumpData<Type>::IsBumped(cBumpData *pData){
	//  ü  浹 ˻
	return pPosition->DotProduct(*pData->pPosition) < *pRadius * *pData->pRadius;
}

/*
	cBumpDetector 
*/

template <class Type>
bool cBumpDetector<Type>::Create(){
	return true;
}

template <class Type>
void cBumpDetector<Type>::Destroy(){
	Clear();
}


template <class Type>
void cBumpDetector<Type>::Add(cVector3D<Type> *pPosition, Type *pRadius, void *pObject){
	cBumpData<Type> *pBumpData;

	pBumpData = new cBumpData<Type>(pPosition, pRadius, pObject);
	BumpDataList.AddTail(pBumpData);
}

template <class Type>
void cBumpDetector<Type>::Delete(void *pObject){
	cBumpDataList::cCursor csr;

	for(csr = BumpDataList.Head(); csr != 0; csr ++){
		if((*csr)->pObject == pObject){
			BumpDataList.Delete(csr);
			return;
		}
	}
}

template <class Type>
void cBumpDetector<Type>::Clear(){
	while(BumpDataList.GetCount()){
		delete BumpDataList.GetHead();
		BumpDataList.RemoveHead();
	}

}


template <class Type>
int cBumpDetector<Type>::DetectBump(cBumpObjectList *pBumpObjectList){
	cBumpDataList::cCursor csr;
	cBumpDataList::cCursor csr2;
	cBumpData *pBumpData;
	cBumpData *pBumpData2;
	cBumpObject BumpObject;

	for(csr = BumpDataList.Head(); csr != 0; csr ++){
		pBumpData = *csr;
		csr2 = csr;
		csr2 ++;
		for(; csr2 != 0; csr2 ++){
			pBumpData2 = *csr2;
			if(pBumpData->IsBumped(pBumpData2)){
				BumpObject.pObject1 = pBumpData->pObject;
				BumpObject.pObject2 = pBumpData2->pObject;
				pBumpObjectList->AddTail(BumpObject);
			
			}
		}
	}
	return pBumpObjectList->GetCount();
}

template <class Type>
int cBumpDetector<Type>::DetectGridBump(cBumpObjectList *pBumpObjectList, int ySize, int xSize, Type MinUnitSize){
	cBumpData<Type> *pObjects[64000];
	cBumpData<Type> **pGroup;
	cBumpData<Type> *pBumpData;
	int ObjectCounts[64];
	int i, j, n;
	Type x, y;
	int xIndex, yIndex;
	cBumpDataList::cCursor csr;
	cBumpObject BumpObject;

	cVector3D<Type> MinPosition, MaxPosition;
	cVector3D<Type> UnitSize;

	assert(xSize >= 1 && xSize <= 8 && ySize >= 1 && ySize <= 8);

	if(BumpDataList.GetCount() <= 1)
		return 0;

	// ü ־   .
	for(i = 0; i < ySize * xSize; i ++){
		ObjectCounts[i] = 0;
	}
	// ü  
	MaxPosition = MinPosition = *BumpDataList.GetHead()->pPosition;
	for(csr = BumpDataList.Head(); csr != 0; csr ++){
		pBumpData = *csr;
		x = pBumpData->pPosition->x;
		y = pBumpData->pPosition->y;
		if(x < MinPosition.x) MinPosition.x = x;
		else if(x > MaxPosition.x) MaxPosition.x = x;
		if(y < MinPosition.y) MinPosition.y = y;
		else if(y > MaxPosition.y) MaxPosition.y = y;
	}

	UnitSize = MaxPosition - MinPosition;
	UnitSize.x = (UnitSize.x / (Type)(xSize - 1)) + 1;
	UnitSize.y = (UnitSize.y / (Type)(ySize - 1)) + 1;
	if(UnitSize.x < MinUnitSize) 
		UnitSize.x = MinUnitSize;
	if(UnitSize.y < MinUnitSize) 
		UnitSize.y = MinUnitSize;

	for(csr = BumpDataList.Head(); csr != 0; csr ++){
		pBumpData = *csr;
		xIndex = int((pBumpData->pPosition->x - MinPosition.x) / UnitSize.x);
		yIndex = int((pBumpData->pPosition->y - MinPosition.y) / UnitSize.y);
		i = yIndex * xSize + xIndex;
		pObjects[i * 1000 + ObjectCounts[i]] = pBumpData;
		ObjectCounts[i] ++;
	}


	for(n = 0; n < xSize * ySize; n ++){
		pGroup = &pObjects[n * 1000];
		for(i = 0; i < ObjectCounts[n]; i ++){
			for(j = i + 1; j < ObjectCounts[n]; j ++){
				if(pGroup[i]->IsBumped(pGroup[j])){
					BumpObject.pObject1 = pGroup[i]->pObject;
					BumpObject.pObject2 = pGroup[j]->pObject;
					pBumpObjectList->AddTail(BumpObject);
					
				}
			}
		}
	}
	return pBumpObjectList->GetCount();
}

