/*
	ü  浹 ˻Ѵ.
*/
#ifndef cBumpDetector_H
#define cBumpDetector_H

#include "cList.h"
#include "cVector3D.h"

template <class Type>
class cBumpData{ // 浹 ˻  ڷ
public:
	cVector3D<Type> *pPosition; // ġ 
	Type *pRadius; // 
	void *pObject; //  ü 

	cBumpData(cVector3D<Type> *_pPosition, Type *_pRadius, void *_pObject);
	bool IsBumped(cBumpData *pData);
};

class cBumpObject{
public:
	void *pObject1;
	void *pObject2;
};


typedef cList<cBumpObject> cBumpObjectList;

template <class Type>
class cBumpDetector{
protected:
	typedef cList<cBumpData<Type>*> cBumpDataList;

	cBumpDataList BumpDataList;
	
public:
	bool Create();
	virtual void Destroy();

	void Add(cVector3D<Type> *pPosition, Type *pRadius, void *pObject);
	void Delete(void *pObject);
	void Clear();

	int DetectBump(cBumpObjectList *pBumpObjectList);
	/*
		ü Grid ϰ  ׸ ȿ 浹 ˻縦 Ѵ.
		Return : 浹 ߻ ü 
	*/
	int DetectGridBump(cBumpObjectList *pBumpObjectList, int ySize, int xSize, Type MinUnitSize);

};

#endif
