#ifndef cControl_H
#define cControl_H

#include "cWindow.h"

class cCommonControl : public cWindow{
private:
	LONG OldWindowProc;

protected:
//	virtual char *GetClassName(){ return "button"; }
	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);


public:
	cCommonControl();
	virtual ~cCommonControl();

	bool Create(DWORD dwExStyle, 
		LPSTR lpWindowName, DWORD dwStyle, 
		int x, int y, int nWidth, int nHeight, 
		cWindow *_pParent, DWORD Id, bool bSubClass = false);

};


class cStaticControl : public cCommonControl{
protected:
	virtual char *GetClassName(){ return "static"; }

public:
};

class cButtonControl : public cCommonControl{
protected:
	virtual char *GetClassName(){ return "button"; }

public:
};

class cEditControl : public cCommonControl{
protected:
	virtual char *GetClassName(){ return "edit"; }

public:
};

class cRichEditControl : public cCommonControl{
protected:
	virtual char *GetClassName(){ return "RichEdit"; }

public:
};

class cHiddenEditControl : public cEditControl{
protected:
	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam);

public:

};

class cListControl : public cCommonControl{
protected:
	virtual char *GetClassName(){ return "listbox"; }

public:
};

class cListView : public cCommonControl{
protected:
	virtual char *GetClassName(){ return "listview"; }

public:
};

#endif
