#include "TOOL.h"
#include "cDBRecord.h"

static SQLHENV g_henv	= SQL_NULL_HANDLE;
static int g_nEnvRef	= 0;

cDatabase::cDatabase()
{
	m_hdbc = SQL_NULL_HANDLE;
}

cDatabase::~cDatabase()
{
	if (IsOpened())
		Close();
}

BOOL cDatabase::IsOpened()
{
	return (m_hdbc != SQL_NULL_HANDLE);
}

void cDatabase::Close()
{
	if (m_hdbc != SQL_NULL_HANDLE)
	{
		SQLFreeHandle (SQL_HANDLE_DBC, m_hdbc);
		m_hdbc = SQL_NULL_HANDLE;

		g_nEnvRef--;
		if (g_nEnvRef <= 0)
		{
			if (g_henv != SQL_NULL_HANDLE)
				SQLFreeHandle (SQL_HANDLE_ENV, g_henv);
			g_nEnvRef = 0;
		}
	}
}

BOOL cDatabase::Open(LPCTSTR lpszConnect)
{
	SQLRETURN nResult;                

	if (IsOpened())
		return FALSE;

	if (g_henv == SQL_NULL_HANDLE)
	{
		g_nEnvRef = 0;
		nResult = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, (SQLHANDLE*)&g_henv);
		if (!SQLOK(nResult))
		{
			g_henv = SQL_NULL_HANDLE;
			return FALSE;
		}
		nResult = SQLSetEnvAttr(g_henv, SQL_ATTR_ODBC_VERSION,
			(SQLPOINTER) SQL_OV_ODBC2, SQL_IS_INTEGER);
		if (!SQLOK(nResult))
		{
			SQLFreeHandle (SQL_HANDLE_ENV, g_henv);
			g_henv = SQL_NULL_HANDLE;
			return FALSE;
		}
	}

	nResult = SQLAllocHandle(SQL_HANDLE_DBC, g_henv, (SQLHANDLE*)&m_hdbc);
	if (!SQLOK(nResult))
	{
		m_hdbc = SQL_NULL_HANDLE;
		if (!g_nEnvRef && g_henv != SQL_NULL_HANDLE)
			SQLFreeHandle (SQL_HANDLE_ENV, g_henv);
		return FALSE;
	}

	TCHAR szConnOut[1024];
	SQLSMALLINT nNumOut;
	nResult = SQLDriverConnect (m_hdbc, NULL, 
		(SQLCHAR*)lpszConnect, SQL_NTS, 
		(SQLCHAR*)szConnOut, 1024, &nNumOut, SQL_DRIVER_NOPROMPT);

	if (!SQLOK(nResult)) 
	{
		SQLFreeHandle(SQL_HANDLE_DBC, m_hdbc);
		m_hdbc = SQL_NULL_HANDLE;
		if (!g_nEnvRef && g_henv != SQL_NULL_HANDLE)
			SQLFreeHandle (SQL_HANDLE_ENV, g_henv);
		return FALSE;
	}

	g_nEnvRef++;
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
CDBRecord::CDBRecord(){
	m_hdbc = SQL_NULL_HANDLE;
	m_hstmt = SQL_NULL_HANDLE;
}

CDBRecord::~CDBRecord(){
	Close();

}

bool CDBRecord::Open(){
	if(m_hdbc == SQL_NULL_HANDLE)
		return false;
	return SQLOK(SQLAllocHandle (SQL_HANDLE_STMT, m_hdbc, (SQLHANDLE*)&m_hstmt));
}

void CDBRecord::Close(){
	if(m_hstmt != SQL_NULL_HANDLE){
		SQLFreeHandle(SQL_HANDLE_STMT, m_hstmt);
		m_hstmt = SQL_NULL_HANDLE;
	}
}

bool CDBRecord::Query(LPCTSTR pFormat, ...){
	BYTE QueryBuffer[8192];
	int rv;
	va_list argList;

	va_start(argList, pFormat);
	QueryBuffer[0] = '\0';
	vsprintf((char*)QueryBuffer, pFormat, argList);
	va_end(argList);

	rv = SQLExecDirect(m_hstmt, QueryBuffer, SQL_NTS);

	if(!SQLOK(rv)){
#ifndef _DEBUG
//		AddErrorLog((LPCTSTR)QueryBuffer);
#endif
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);
	}

	return SQLOK(rv);
}

int CDBRecord::QueryIntSelect(LPCTSTR pFormat, ...){
	BYTE QueryBuffer[8192];
	int rv = -1;
	va_list argList;
	int nResult;

	va_start(argList, pFormat);
	QueryBuffer[0] = '\0';
	vsprintf((char*)QueryBuffer, pFormat, argList);
	va_end(argList);
	nResult = SQLExecDirect(m_hstmt, QueryBuffer, SQL_NTS);

	if (!SQLOK (nResult)){
		DisplayError (nResult, SQL_HANDLE_STMT, m_hstmt);
		return -1;
	}
	//  Ѵ.
	if(SQLFetch(m_hstmt) == SQL_SUCCESS){
		if(SQLGetData(m_hstmt, 1, SQL_C_ULONG, &rv, sizeof(int), 0) != SQL_SUCCESS)
			rv = -1;
	}else{
		rv = 0;
	}
	EndFetch();

	return rv;
}

bool CDBRecord::Fetch(){
	int rv;

	m_ColumnNumber = 0;
	rv = SQLFetch(m_hstmt);
#ifdef _DEBUG
	if(!SQLOK(rv) && rv != SQL_NO_DATA){
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);
	}
#endif
	return SQLOK(rv);
}

void CDBRecord::EndFetch(){
	int rv;

	rv = SQLCloseCursor(m_hstmt);

#ifdef _DEBUG
	if(!SQLOK(rv)){
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);
	}
#endif
}


CDBRecord& CDBRecord::operator>>(char& arg ){
	int rv;
	m_ColumnNumber ++;
	rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_STINYINT, &arg, sizeof(char), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(BYTE& arg ){
	m_ColumnNumber ++;
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_UTINYINT, &arg, sizeof(char), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}


CDBRecord& CDBRecord::operator>>(short& arg ){
	m_ColumnNumber ++;
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_SSHORT, &arg, sizeof(short), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(WORD& arg ){
	m_ColumnNumber ++;
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_USHORT, &arg, sizeof(WORD), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(int& arg ){
	SQLRETURN rv;
	m_ColumnNumber ++;
	rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_SLONG, &arg, sizeof(int), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(DWORD& arg ){
	m_ColumnNumber ++;
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_ULONG, &arg, sizeof(DWORD), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(cString& arg){
	int Width;
	
	m_ColumnNumber ++;
	SQLColAttribute(m_hstmt, m_ColumnNumber, SQL_DESC_OCTET_LENGTH, 0, 0, 0, &Width);
	
	arg.Create(Width + 1);

	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_CHAR, arg.Get(), Width, 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}


CDBRecord& CDBRecord::operator>>(char* arg){
	int Width;
	
	m_ColumnNumber ++;
	SQLColAttribute(m_hstmt, m_ColumnNumber, SQL_DESC_OCTET_LENGTH, 0, 0, 0, &Width);
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_CHAR, arg, Width, 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(BYTE* arg){
	int Width;
	SQLRETURN rv;
	
	m_ColumnNumber ++;
	SQLColAttribute(m_hstmt, m_ColumnNumber, SQL_DESC_LENGTH, 0, 0, 0, &Width);
	rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_BINARY, arg, Width, 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

CDBRecord& CDBRecord::operator>>(float& arg){
	m_ColumnNumber ++;
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_FLOAT, &arg, sizeof(float), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}



CDBRecord& CDBRecord::operator>>(TIMESTAMP_STRUCT& arg){
	m_ColumnNumber ++;
	int rv = SQLGetData(m_hstmt, m_ColumnNumber, SQL_C_TIMESTAMP, &arg, sizeof(TIMESTAMP_STRUCT), 0);
#ifdef _DEBUG
	if(!SQLOK(rv))
		DisplayError (rv, SQL_HANDLE_STMT, m_hstmt);	
#endif
	return *this;
}

void CDBRecord::DisplayError(SQLRETURN nResult, SWORD fHandleType, SQLHANDLE handle){
#ifdef _DEBUG
	UCHAR	szErrState[SQL_SQLSTATE_SIZE+1];		// SQL Error State string
	UCHAR	szErrText[SQL_MAX_MESSAGE_LENGTH+1];	// SQL Error Text string
	char	szBuffer[SQL_SQLSTATE_SIZE+SQL_MAX_MESSAGE_LENGTH+8192+1];

	SWORD	wErrMsgLen;				// Error message length
	UDWORD	dwErrCode;				// Native Error code
	SQLRETURN	nErrResult;			// Return Code from SQLGetDiagRec
	SWORD	sMsgNum = 1;

	szBuffer[0] = '\0';

	while (true){
		nErrResult = SQLGetDiagRec(fHandleType, handle, sMsgNum++, szErrState,
			(SQLINTEGER*)&dwErrCode, szErrText,	SQL_MAX_MESSAGE_LENGTH-1, &wErrMsgLen);
		if(!SQLOK(nErrResult))
			break;

		wsprintf(szBuffer, "SQL Error State: '%s'\nNative Error Code: %lX\nODBC Error: '%s'", (LPSTR)szErrState, dwErrCode, (LPSTR)szErrText);
		MessageBox(0, szBuffer, "SQL Error", MB_OK);
		_ASSERTE(FALSE);
#endif
	}
}


