#ifndef CDBRecord_H
#define CDBRecord_H


#define SQLOK(nResult) (nResult == SQL_SUCCESS || nResult == SQL_SUCCESS_WITH_INFO)

#include "cString.h"

class cDatabase
{
public:
	cDatabase();
	virtual ~cDatabase();

public:
	SQLHDBC m_hdbc;

	BOOL	IsOpened();
	BOOL	Open(LPCTSTR lpszConnect);
	void	Close();
};


class CDBRecord{
protected:
	SQLHDBC m_hdbc;
	SQLHSTMT m_hstmt;

	int m_ColumnNumber;

public:
	void SetDBConnection(SQLHDBC hdbc){ m_hdbc = hdbc; 	m_hstmt = SQL_NULL_HANDLE;}

	CDBRecord();
	CDBRecord(SQLHDBC hdbc){ SetDBConnection(hdbc); }
	virtual ~CDBRecord();

	bool Open(); 
	void Close();

	bool Query(LPCTSTR pFormat, ...);
	int QueryIntSelect(LPCTSTR pFormat, ...);
	virtual bool BindColumns(){ return false; };
	bool Fetch();
	void EndFetch();


	void DisplayError(SQLRETURN nResult, SWORD fHandleType, SQLHANDLE handle);

	CDBRecord& operator>>(char& arg );
	CDBRecord& operator>>(BYTE& arg );
	CDBRecord& operator>>(short& arg );	
	CDBRecord& operator>>(WORD& arg );	
	CDBRecord& operator>>(int& arg );	
	CDBRecord& operator>>(DWORD& arg );	
	CDBRecord& operator>>(cString& arg );	
	CDBRecord& operator>>(char* arg	);
	CDBRecord& operator>>(BYTE* arg);
	CDBRecord& operator>>(TIMESTAMP_STRUCT& arg);
	CDBRecord& operator>>(float& arg);

};


#endif
