#include "TOOL.h"
#include "cDisplay.h"

cDisplay Display;


cDisplay::cDisplay(){
	pDD = NULL;
	pDDPalette = NULL;
	hFont = 0;

}

cDisplay::~cDisplay(){
	Destroy();
}

bool cDisplay::Create(HWND _hWnd){
	if(pDD) return false;

	hWnd = _hWnd;
	if(DirectDrawCreateEx(NULL, (void**)&pDD, IID_IDirectDraw7, NULL) != DD_OK){
		MessageBox(NULL, "DirectX Initialization Failed.\nPlease reinstall DirectX3.0\n\nDirectDrawCreate() Failed", "DirectX Error!", MB_OK);
		return false;
	}
 
	CooperativeLevel = 0;
	// cPicture  cDisplay εѴ.
	SetCooperativeLevel(DDSCL_NORMAL);

	return true;
}

bool cDisplay::CreatePalette(){
	DDSURFACEDESC2 ddsd;
	DWORD rv;
	int i;

	DestroyPalette();

	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	if(pDD->GetDisplayMode(&ddsd) != DD_OK) return false;

	// ÷̰ 256   ǥ  ȷƮ Ѵ.
	switch(ddsd.ddpfPixelFormat.dwRGBBitCount){
	case 4:
		for(i = 0; i < 16; i ++){
			PaletteEntry[i].peRed = ((i & 4) >> 2) * 128 + ((i & 8) >> 3) * 128;
			PaletteEntry[i].peGreen = ((i & 2) >> 1) * 128 + ((i & 8) >> 3) * 128;
			PaletteEntry[i].peBlue = (i & 1) * 128 + ((i & 8) >> 3) * 128;
			PaletteEntry[i].peFlags = 0;
		}
		if(pDD->CreatePalette(DDPCAPS_4BIT, PaletteEntry, &pDDPalette, NULL) != DD_OK) return false;
		break;
	case 8:
		for(i = 0; i < 256; i ++){
			PaletteEntry[i].peRed = ((i & 48) >> 4) * 64 + ((i & 192) >> 6) * 64;
			PaletteEntry[i].peGreen = ((i & 12) >> 2) * 64 + ((i & 192) >> 6) * 64;
			PaletteEntry[i].peBlue = (i & 3) * 64 + ((i & 192) >> 6) * 64;
			PaletteEntry[i].peFlags = 0;
		}
		rv = pDD->CreatePalette(DDPCAPS_8BIT, PaletteEntry, &pDDPalette, NULL);
		if(rv != DD_OK)
			return false;
		break;
	default:
		return true;
	}
	
	return true;
}

void cDisplay::Destroy(){
	DestroyPalette();
	if(pDD){
		pDD->Release();
		pDD = NULL;
	}
}

void cDisplay::DestroyPalette(){
	if(pDDPalette){
		pDDPalette->Release();
		pDDPalette = NULL;
	}
}

bool cDisplay::SetCooperativeLevel(DWORD Mode){
	CooperativeLevel = Mode;
	if(pDD->SetCooperativeLevel(hWnd, Mode) != DD_OK)
		return false;

	if(!CreatePalette())
		return false;
	return true;
}

bool cDisplay::SetDisplayMode(cDisplayMode * pMode){

	if(pDD->SetDisplayMode(
		pMode->Width, 
		pMode->Height, 
		pMode->BitsPerPixel,
		pMode->RefreshRate, 0) != DD_OK)
		return false;

	DisplayMode = *pMode;
	if(!CreatePalette())
		return false;
	return true;
}

bool cDisplay::RestoreDisplayMode(){
	return pDD->RestoreDisplayMode() == DD_OK;
}


//     ÷̸ ´.
bool cDisplay::CreateDoubleBuffer(DWORD Width, DWORD Height, bool _FlipMode){
//	FlipMode = _FlipMode;
	DDPIXELFORMAT pf;

	if((CooperativeLevel & DDSCL_EXCLUSIVE) &&
		(CooperativeLevel & DDSCL_FULLSCREEN) &&
		_FlipMode){
		// ø   ǥ .
		if(!FrontPic.Create(1)) 
			return false;
		BackPic = FrontPic.GetBackPic();
		FlipMode = true;
	}else{
		// ø Ұ Ϲ ǥ .
		if(!FrontPic.Create()) return false;
		if(!BackPic.Create(Width, Height)) return false;
//		if(!(CooperativeLevel & DDSCL_FULLSCREEN))
//			CreateClipper();
		FlipMode = false;
	}
	if(pDDPalette){
		if(FrontPic.GetDDS()->SetPalette(pDDPalette) != DD_OK)
			return false;
	}
	// ÷ 带 Ѵ.
	if(!(CooperativeLevel & DDSCL_FULLSCREEN)){ // ü ȭ 尡 ƴ϶ ȼ   ÷̸带 Ѵ.
		DisplayMode.Width = Width;
		DisplayMode.Height = Height;
		BackPic.GetPixelFormat(&pf);
		DisplayMode.BitsPerPixel = pf.dwRGBBitCount;
		DisplayMode.RefreshRate = 0;

	}

	// ǥ  ٸ ȼ  Ѵ.
	switch(DisplayMode.BitsPerPixel){
	case 16:
		BackPic.SetPixel(0, 0, RGB(0, 255, 0));
		// 555 - 0rrrrrgg gggbbbbb
		// 565 - rrrrrggg gggbbbbb
		if(BackPic.GetDevicePixel(0, 0) & 0x0400){
			PixelFormat = PF_16BPP565;
		}else{
			PixelFormat = PF_16BPP555;
		}
		CreateBlendingTable();
		break;
	}

	return true;

}

void cDisplay::DestroyDoubleBuffer(){
	BackPic.Destroy();
	FrontPic.Destroy();
}






bool cDisplay::Flip(){
	cRect FlipArea;

	if(FlipMode){
		return FrontPic.Flip(&BackPic);
	}
	if(CooperativeLevel & DDSCL_FULLSCREEN){
		return FrontPic.BltFast(0, 0, &BackPic);
	}
	
	FrontPic.GetArea(&FlipArea);
	FlipArea.right = FlipArea.Width();
	FlipArea.bottom = FlipArea.Height();
	FlipArea.left = 0;
	FlipArea.top = 0;
	return FrontPic.Blt(0, &BackPic, &FlipArea);
}

void cDisplay::CreateBlendingTable(){
	//  ̸  ̺ .
	Table32* pTable;
	int d, s;
	int DestPower, SrcPower;

	pTable = BlendingTable[PBE_NORMAL];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			if(s == 0)
				pTable[d][s] = d;
			else
				pTable[d][s] = s;

		}
	}
	pTable = BlendingTable[PBE_NORMAL30];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			if(s < 2){
				SrcPower = s * 16;
			}else{
				SrcPower = 32;
			}
			DestPower = 32 - SrcPower;
			pTable[d][s] = d * DestPower / 32 + s * SrcPower / 32;
		}
	}
	pTable = BlendingTable[PBE_AVERAGE];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = (d + s) / 2;
		}
	}
	pTable = BlendingTable[PBE_LIGHT];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			if(s == 0)
				pTable[d][s] = d;
			else{
				pTable[d][s] = s + 8;
				if(pTable[d][s] >= 32)
					pTable[d][s] = 31;
			}
		}
	}
	
	pTable = BlendingTable[PBE_LIGHT_COPY];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = s + 8;
			if(pTable[d][s] >= 32)
				pTable[d][s] = 31;
		}
	}
	pTable = BlendingTable[PBE_DARK];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			if(s == 0)
				pTable[d][s] = d;
			else{
				pTable[d][s] = s / 2;
			}
		}
	}
	pTable = BlendingTable[PBE_ADD];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = s + d;
			if(pTable[d][s] >= 32)
				pTable[d][s] = 31;
		}
	}
	pTable = BlendingTable[PBE_AND];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = s & d;
			if(pTable[d][s] >= 32)
				pTable[d][s] = 31;
		}
	}
	pTable = BlendingTable[PBE_OR];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = s | d;
			if(pTable[d][s] >= 32)
				pTable[d][s] = 31;
		}
	}
	pTable = BlendingTable[PBE_MIN];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = min(s, d);
		}
	}
	pTable = BlendingTable[PBE_MAX];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = max(s, d);
		}
	}

	pTable = BlendingTable[PBE_COLOR_DODGE];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			pTable[d][s] = (BYTE)((d * 32.0f) / (32 - s));
			if(pTable[d][s] >= 32)
				pTable[d][s] = 31;
		}
	}
	pTable = BlendingTable[PBE_SHADE];
	for(d = 0; d < 32; d ++){
		for(s = 0; s < 32; s ++){
			if(s)
				pTable[d][s] = d / 4;
			else
				pTable[d][s] = d;
		}
	}
}

