/*
	̷Ʈ ο츦 ̿Ͽ ÷̸ ߻ȭ Ѵ.
*/
#ifndef cDisplay_H
#define cDisplay_H

#include "cPicture.h"

class cDisplayMode{
public:
	UINT	Width;
	UINT	Height;
	UINT	BitsPerPixel;
	UINT	RefreshRate;

	void Set(UINT _Width, UINT _Height, UINT _BitsPerPixel = 8, UINT _RefreshRate = 0){
		Width = _Width;
		Height = _Height;
		BitsPerPixel = _BitsPerPixel;
		RefreshRate = _RefreshRate;
	}
};

enum ePixelFormat{
	PF_16BPP565,
	PF_16BPP555,
};

typedef BYTE Table32[32] ;

class cDisplay{
private:
	// ȿ ̺
	BYTE BlendingTable[PBE_PrepareCount][32][32];


protected:
	LPDIRECTDRAW7 pDD;
	HWND hWnd;

	LPDIRECTDRAWPALETTE pDDPalette;
	PALETTEENTRY PaletteEntry[256];

	cDisplayMode DisplayMode;
	
	DWORD CooperativeLevel;

	cPicture FrontPic;
	cPicture BackPic;

	bool FlipMode;

	ePixelFormat PixelFormat;


	HFONT hFont;

//	bool CreateClipper();
//	void DestroyClipper();

	bool CreatePalette();
	void DestroyPalette();
	void CreateBlendingTable();
public:
	cDisplay();
	virtual ~cDisplay();

	bool Create(HWND _hWnd);
	void Destroy();

	bool SetCooperativeLevel(DWORD Mode);
	bool SetDisplayMode(cDisplayMode *pMode);
	bool RestoreDisplayMode();

	bool CreateDoubleBuffer(DWORD Width, DWORD Height, bool _FlipMode = FALSE);
	void DestroyDoubleBuffer();

//	LPDIRECTDRAWCLIPPER GetClipper(){ return pDDClipper; }
	operator LPDIRECTDRAW7(){ return pDD; }
	LPDIRECTDRAW7 GetDD(){ return pDD; }

	void SetFont(HFONT _hFont){ hFont = _hFont; }
	HFONT GetFont(){ return hFont; }
		
	cPicture *GetFrontPic(){ return &FrontPic; }
	cPicture *GetBackPic(){ return &BackPic; }

	ePixelFormat GetPixelFormat(){ return PixelFormat; }

	bool Flip();

	Table32* GetBlendingTable(int n){ return BlendingTable[n]; }

};

extern cDisplay Display;

#endif
