#ifndef H_cFile
#define H_cFile

#include <stdio.h>
#include "cStack.h"

class cFile{
protected:
	char	*FileName;
	FILE	*File;
	cStack<fpos_t>	PosStack;
public:
	cFile();
	~cFile();

	BOOL Open(char *Mode);
	BOOL Open(char *FileName, char *Mode);
	void Close();

	FILE *GetFile();

	int	Read(void *Dest, int Size, int Block = 1);
	int Write(void *Src, int Size, int Block = 1);
	int WriteSpace(int Count);

	char *Gets(char *String, int n);
	int Puts(char *String);
	int Printf(char *Format, ...);

	int Getc();
	int Putc(int c);
	BOOL GetString(char *Buffer, int n);
	int Ungetc(int Char);

	BOOL Seek(int Offset, int Origin);
	BOOL SkipSpace();
	BOOL FindChar(char c);

	// File Position Management
	void ClearPosStack();
	BOOL PushPos();
	BOOL PopPos();
	void DelTop();

	void SetFileName(char *nFileName); // Set File Name
};

#endif