/*
	ӹ ḮƮ
*/
#ifndef cList_H
#define cList_H


template<class T> class cList{
protected:
	struct sNode{
		T Data;
		sNode *pPrev, *pNext;
	};

public:

	class cCursor{
	public:
		sNode *pNode;

		cCursor(){ pNode = 0; }
		cCursor(sNode *_pNode){ pNode = _pNode; }
		inline void operator=(cCursor &a){ pNode = a.pNode; }

		inline void operator++(){
			if(pNode) pNode = pNode->pNext;
		}
		inline void operator++(int){
			if(pNode) pNode = pNode->pNext;
		}
		inline void operator--(){
			if(pNode) pNode = pNode->pPrev;
		}
		inline void operator--(int){
			if(pNode) pNode = pNode->pPrev;
		}
		inline void operator+=(int n){
			if(n >= 0) while(n --) operator++(); 
			else operator-=(-n);
		}
		inline void operator-=(int n){
			if(n >= 0) while(n --) operator--();
			else operator+=(-n);
		}

		inline bool operator==(cCursor &a){
			if(pNode == a.pNode) return true;
			return false;
		}
		inline bool operator!=(cCursor &a){
			if(pNode != a.pNode) return true;
			return false;
		}

		inline bool operator ==(void *p){
			if(pNode == p) return true;
			return false;
		}
		inline bool operator !=(void *p){
			if(pNode != p) return true;
			return false;
		}

		inline T &operator *(){
			return pNode->Data;
		}
	};

protected:

	sNode *pHead;
	sNode *pTail;
	int Count;

public:
	cList();
	~cList();

	void Clear();
	bool IsEmpty();
	int GetCount();

	cCursor Head(){ return cCursor(pHead); }
	cCursor Tail(){ return cCursor(pTail); }

	void InsertFront(cCursor Cursor, T _Data);
	void InsertBack(cCursor Cursor, T _Data);
	cCursor Delete(cCursor Cursor);

	void AddHead(T _Data);
	void AddTail(T _Data);
	void RemoveHead();
	void RemoveTail();
	void Remove(T _Data);

	T GetHead(){ return pHead->Data; }
	T GetTail(){ return pTail->Data; }

	T &Get(cCursor Cursor){ return *Cursor; }
	void Set(cCursor Cursor, T _Data){ *Cursor = _Data; }




};


template<class T>cList<T>::cList(){
	pHead = pTail = 0;
	Count = 0;
}

template<class T>cList<T>::~cList(){
	Clear();
}

template<class T>void cList<T>::Clear(){
	sNode *pTemp;

	while(pHead){
		pTemp = pHead;
		pHead = pHead->pNext;
		delete pTemp;
	}
	pTail = 0;
	Count = 0;
}

template<class T> bool cList<T>::IsEmpty(){
	return pHead == 0;
}

template<class T>int cList<T>::GetCount(){
	return Count;
}

/////////////////////////////////////////////// Access
template<class T>
void cList<T>::InsertFront(cCursor Cursor, T _Data){
	sNode *pTemp;

	if(!Cursor.pNode){ // Ŀ ƹ͵ Ű  ʴٸ
		if(pHead) return; 

		pTail = pHead = new sNode;
		pHead->Data = _Data;
		pHead->pNext = pHead->pPrev = 0;
	}else{
		if(Cursor == pHead){
			//  տ 
			pTemp = pHead;
			pHead = new sNode;
			pHead->Data = _Data;
			pHead->pPrev = 0;
			pHead->pNext = pTemp;
			pTemp->pPrev = pHead;
		}else{
			pTemp = new sNode;
			pTemp->Data = _Data;
			pTemp->pPrev = Cursor.pNode->pPrev;
			pTemp->pNext = Cursor.pNode;
			Cursor.pNode->pPrev = pTemp;
			Cursor.pNode->pPrev->pNext = pTemp;
		}
	}
	Count ++;
}

template<class T>
void cList<T>::InsertBack(cCursor Cursor, T nData){
	sNode *pTemp;

	if(!Cursor.pNode){ // Ŀ ƹ͵ Ű  ʴٸ
		if(pHead) return; 

		pTail = pHead = new sNode;
		pHead->Data = _Data;
		pHead->pNext = pHead->pPrev = 0;
	}else{
		if(Cursor == pTail){
			//  ڿ 
			pTemp = pTail;
			pTail = new sNode;
			pTail->Data = _Data;
			pTail->pPrev = pTemp;
			pTail->pNext = 0;
			pTemp->pNext = pTail;
		}else{
			pTemp = new sNode;
			pTemp->Data = _Data;
			pTemp->pPrev = Cursor.pNode;
			pTemp->pNext = Cursor.pNode->pNext;
			Cursor.pNode->pNext = pTemp;
			Cursor.pNode->pNext->pPrev = pTemp;
		}
	}
	Count ++;
}

template<class T>
cList<T>::cCursor cList<T>::Delete(cCursor Cursor){
	sNode *pTemp;

	if(!Cursor.pNode) return Cursor;
	if(pHead == Cursor.pNode && pTail == Cursor.pNode){
		delete pHead;
		pTail = pHead = 0;
		Cursor.pNode = 0;
	}else if(pHead == Cursor.pNode){
		Cursor.pNode = pHead->pNext;
		Cursor.pNode->pPrev = 0;
		delete pHead;
		pHead = Cursor.pNode;
	}else if(pTail == Cursor.pNode){
		Cursor.pNode = pTail->pPrev;
		Cursor.pNode->pNext = 0;
		delete pTail;
		pTail = Cursor.pNode;
	}else{
		pTemp = Cursor.pNode;
		Cursor.pNode->pPrev->pNext = Cursor.pNode->pNext;
		Cursor.pNode->pNext->pPrev = Cursor.pNode->pPrev;
		Cursor.pNode = Cursor.pNode->pNext;
		delete pTemp;
	}
	Count --;

	return Cursor;
}

template<class T>
void cList<T>::AddHead(T _Data){
	if(pHead == 0){
		pTail = pHead = new sNode;
		pHead->Data = _Data;
		pHead->pPrev = pHead->pNext = 0;
	}else{
		pHead->pPrev = new sNode;
		pHead->pPrev->pNext = pHead;
		pHead = pHead->pPrev;
		pHead->Data = _Data;
		pHead->pPrev = 0;
	}
	Count ++;
}

template<class T>
void cList<T>::AddTail(T _Data){
	if(pHead == 0){
		pTail = pHead = new sNode;
		pHead->Data = _Data;
		pHead->pPrev = pHead->pNext = 0;
	}else{
		pTail->pNext = new sNode;
		pTail->pNext->pPrev = pTail;
		pTail = pTail->pNext;
		pTail->Data = _Data;
		pTail->pNext = 0;
	}
	Count ++;
}

template<class T>
void cList<T>::RemoveHead(){
	sNode *pTemp;

	if(!pHead) return;
	pTemp = pHead;

	if(pTail == pHead){
		pTail = pHead = 0;
	}else{
		pHead = pHead->pNext;
		pHead->pPrev = 0;
	}
	delete pTemp;
	
	Count --;
}

template<class T>
void cList<T>::RemoveTail(){
	sNode *pTemp;

	if(!pTail) return;

	pTemp = pTail;

	if(pHead == pTail){
		pTail = pHead = 0;
	}else{
		pTail = pTail->pPrev;
		pTail->pNext = 0;
	}
	delete pTemp;

	Count --;

}

template<class T>
void cList<T>::Remove(T _Data){
	cCursor csr;

	for(csr = Head(); csr != 0; csr ++){
		if((*csr) == _Data){
			Delete(csr);
			return;
		}
	}
}



#endif
