#include "TOOL.h"
#include "cName.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/*cName::cName(){
	pName = NULL;
}
*/
cName::cName(int _NameLength){
	NameLength = _NameLength;
	pName = new char [NameLength];
	pName[0] = 0;
}

cName::cName(const cName &a){
	NameLength = a.NameLength;
	pName = new char [NameLength];
	strcpy(pName, a.pName);
}

cName::~cName(){
	if(pName) delete [] pName;
}

BOOL cName::SetName(const char *NewName){
	if(pName == NULL || NewName == NULL) return false;
	strncpy(pName, NewName, NameLength);
	return true;
}

void cName::operator=(const cName &a){
	if(pName) delete [] pName;
	NameLength = a.NameLength;
	pName = new char [NameLength];
	strcpy(pName, a.pName);
}

/////////////////////////////////////////////////
BOOL operator==(const cName &a, const cName &b){
	return strcmp(a.pName, b.pName) == 0;
}

BOOL operator!=(const cName &a, const cName &b){
	return strcmp(a.pName, b.pName) != 0;
}

BOOL operator<(const cName &a, const cName &b){
	return strcmp(a.pName, b.pName) < 0;
}

BOOL operator>(const cName &a, const cName &b){
	return strcmp(a.pName, b.pName) > 0;
}
