#include "TOOL.h"
#include "cPicture.h"
#include "cDisplay.h"
#include "cClipper.h"

cPicture::cPicture(){
	PictureType = PT_NONE;
	yAdjust = xAdjust = 0;
	SetRect(&Rect, 0, 0, 0, 0);
	pDDS = 0;
}

cPicture::~cPicture(){
}

bool cPicture::Load(cMedium * pMedium){
	return Create(pMedium->GetFileName());
}

bool cPicture::Save(cMedium * pMedium){
	DDSURFACEDESC2 ddsd;
	BITMAPFILEHEADER FileHeader;
	BITMAPINFOHEADER InfoHeader;
	HBITMAP hBitmap;
	HDC hdcSurface, hdcBitmap;
	void *pBitmapData;

	GetSurfaceDesc(&ddsd);

	hBitmap = CreateBitmap(ddsd.dwWidth, ddsd.dwHeight, 1, 24, 0);
	if(!hBitmap)
		return false;

	if(!GetDC(&hdcSurface)){
		DeleteObject(hBitmap);
		return false;
	}
	hdcBitmap = CreateCompatibleDC(hdcSurface);
	BitBlt(hdcBitmap, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcSurface, 0, 0, SRCCOPY);

	pBitmapData = new DWORD[ddsd.dwWidth * ddsd.dwHeight];
	if(GetDIBits(hdcBitmap, hBitmap, 0, ddsd.dwHeight, pBitmapData, 0, DIB_RGB_COLORS) != (int)ddsd.dwHeight){
		delete [] pBitmapData;
		DeleteObject(hBitmap);
		return false;
	}
	DeleteDC(hdcBitmap);
	ReleaseDC(hdcSurface);

	ZeroMemory(&FileHeader, sizeof(FileHeader));
	FileHeader.bfType = 'B' | 'M' * 0x0100;
	FileHeader.bfOffBits = sizeof(FileHeader) + sizeof(InfoHeader);
	FileHeader.bfReserved1 = 0;
	FileHeader.bfReserved2 = 0;

	ZeroMemory(&InfoHeader, sizeof(InfoHeader));
    InfoHeader.biSize = sizeof(InfoHeader);
    InfoHeader.biWidth = ddsd.dwWidth; 
    InfoHeader.biHeight = ddsd.dwHeight;  
    InfoHeader.biPlanes = 1;  
    InfoHeader.biBitCount = (UINT)24;
    InfoHeader.biCompression = BI_RGB;  
    InfoHeader.biSizeImage = 0;  

	FileHeader.bfSize = sizeof(FileHeader) + sizeof(InfoHeader) + InfoHeader.biWidth * InfoHeader.biHeight * InfoHeader.biPlanes * InfoHeader.biBitCount / 8;
//	Size = InfoHeader.biWidth * InfoHeader.biHeight * InfoHeader.biPlanes * InfoHeader.biBitCount / 8
	pMedium->Write(&FileHeader, sizeof(FileHeader), 1);
	pMedium->Write(&InfoHeader, sizeof(InfoHeader), 1);
	pMedium->Write(pBitmapData, sizeof(DWORD), ddsd.dwWidth * ddsd.dwHeight);

	delete [] pBitmapData;
	DeleteObject(hBitmap);

	return TRUE;

}

bool cPicture::Save(const char* FileName){
	cMedium Medium;

	Medium.SetFileName(FileName);
	if(!Medium.Open(cMedium::OM_WRITE))
		return false;

	Save(&Medium);

	Medium.Close();
	return true;
}

/*
void GetClipRect(CPoint& ptDest, CRect rcSrcOrg, CRect& rcSrcClipped)
{
	int nClipLeft = 0, nClipRight = 0;
	int nClipTop = 0, nClipBottom = 0;

	if (rcSrcOrg.left < 0)
		nClipLeft = -rcSrcOrg.left;
	else if (rcSrcOrg.right >= GameApp.nScreenWidth)
		nClipRight = rcSrcOrg.right - GameApp.nScreenWidth;
	if (rcSrcOrg.top < 0)
		nClipTop = -rcSrcOrg.top;
	else if (rcSrcOrg.bottom >= GameApp.nScreenHeight)
		nClipBottom = rcSrcOrg.bottom - GameApp.nScreenHeight;

	ptDest.x = rcSrcOrg.left + nClipLeft;
	ptDest.y = rcSrcOrg.top  + nClipTop;

	rcSrcClipped.left	= nClipLeft;
	rcSrcClipped.top	= nClipTop;
	rcSrcClipped.right	= rcSrcOrg.Width()  - nClipRight;
	rcSrcClipped.bottom	= rcSrcOrg.Height() - nClipBottom;
}
*/
//////////////////////////////////////////////////////////////////////
// ǥ 
//////////////////////////////////////////////////////////////////////
bool cPicture::Create(int BackBufferCount){
	DDSURFACEDESC2 ddsd;

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);

	if(BackBufferCount > 0){
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_COMPLEX | DDSCAPS_FLIP;
		ddsd.dwBackBufferCount = BackBufferCount;
	}else{
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	}

	if(Display.GetDD()->CreateSurface(&ddsd, &pDDS, 0) != DD_OK) {
		return false;
	}
	PictureType = PT_ORIGINAL;
	GetSurfaceDesc(&ddsd);
	SetRect(&Rect, 0, 0, ddsd.dwWidth, ddsd.dwHeight);
	return true;
}

bool cPicture::GetPixelFormat(LPDDPIXELFORMAT ppf){
	DDSURFACEDESC2 ddsd;
	GetSurfaceDesc(&ddsd);
	*ppf = ddsd.ddpfPixelFormat;
	return pDDS->GetPixelFormat(ppf) == DD_OK;
}


bool cPicture::Create(DWORD Width, DWORD Height, DWORD dwFlags){
	DDSURFACEDESC2 ddsd; 

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | dwFlags; 
	ddsd.dwWidth = Width;
	ddsd.dwHeight = Height; 

	if(Display.GetDD()->CreateSurface(&ddsd, &pDDS, 0) != DD_OK) 
		return false;
	PictureType = PT_ORIGINAL;
	SetRect(&Rect, 0, 0, Width, Height);
	return true;
}


bool cPicture::Create(cPicture *pSrc){
	DDSURFACEDESC2 ddsd;
	
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);

	if(pSrc->GetDDS()->GetSurfaceDesc(&ddsd) != DD_OK)
		return false;

	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; 

	if(Display.GetDD()->CreateSurface(&ddsd, &pDDS, 0) != DD_OK)
		return false;
	Rect = pSrc->Rect;
	PictureType = PT_ORIGINAL;
	return true;
}

bool cPicture::CreateReference(cPicture *pSrc, int Left, int Top, int Right, int Bottom){
	pDDS = pSrc->pDDS;
	SetRect(&Rect, Left, Top, Right, Bottom);
	PictureType = PT_CROPPED; // ׸ 
	return TRUE;
}

void cPicture::SetArea(LPDIRECTDRAWSURFACE7 _pDDS, RECT *pRect){
	// ̷Ʈ ο ǥ Ϻθ ׸ Ѵ.
	pDDS = _pDDS;
	pDDS->AddRef();
	Rect = *pRect;
}

// ׸ Ϸ  ǥ  .
bool cPicture::Create(const char *_FileName){
	HDC hdcSurface, hdcBitmap;
	HBITMAP hBitmap;
	BITMAP BitmapInfo;

	hBitmap = (HBITMAP) LoadImage(0, _FileName, IMAGE_BITMAP,
		0, 0, LR_LOADFROMFILE);
	if(hBitmap == 0) return false;

	// Ʈ  о ´.
	if(!GetObject(hBitmap, sizeof(BITMAP), &BitmapInfo)){
		DeleteObject(hBitmap);
		return false;
	}

	// Ʈʿ ߾ ǥ  .
	Destroy();
	if(!Create(BitmapInfo.bmWidth, BitmapInfo.bmHeight)){
		DeleteObject(hBitmap);
		return false;
	}
	// Ʈ ǥ Ѵ.
	LRESULT hr = pDDS->GetDC(&hdcSurface);
	if(hr != DD_OK){
		DeleteObject(hBitmap);
		return false;
	}
	hdcBitmap = CreateCompatibleDC(hdcSurface);
	SelectObject(hdcBitmap, hBitmap);
	BitBlt(hdcSurface, 0, 0, BitmapInfo.bmWidth, BitmapInfo.bmHeight, 
		hdcBitmap, 0, 0, SRCCOPY);
	DeleteDC(hdcBitmap);
	pDDS->ReleaseDC(hdcSurface);
	DeleteObject(hBitmap);
	PictureType = PT_ORIGINAL;
	SetRect(&Rect, 0, 0, BitmapInfo.bmWidth, BitmapInfo.bmHeight);

	SetColorKey(DDCKEY_SRCBLT, 0, 0);
	
	FileName = _FileName;
	return true;
}

//////////////////////////////////////////////////////////////////////
// ǥ 
//////////////////////////////////////////////////////////////////////
void cPicture::Destroy(){
//	if(!pDDS) return;

	switch(PictureType){
	case PT_ORIGINAL:
		pDDS->Release();
		pDDS = 0;
	}
	PictureType = PT_NONE;
}

bool cPicture::GetSize(LPSIZE psz){
	DDSURFACEDESC2 ddsd;
	
	if(PictureType == PT_CROPPED){
		psz->cx = GetWidth();
		psz->cy = GetHeight();
		return true;
	}
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	if(!pDDS) return FALSE;
	if(pDDS->GetSurfaceDesc(&ddsd) != DD_OK) return FALSE;
	
	psz->cx = ddsd.dwWidth;
	psz->cy = ddsd.dwHeight;
	return true;

}

int cPicture::GetWidth(){
//	DDSURFACEDESC2 ddsd;

//	if(PictureType == PT_CROPPED){
		return Rect.right - Rect.left;
//	}
/*	
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	if(!pDDS) return FALSE;
	if(pDDS->GetSurfaceDesc(&ddsd) != DD_OK) return FALSE;
	
	return ddsd.dwWidth;
	*/
}

int cPicture::GetHeight(){
//	DDSURFACEDESC2 ddsd;
	
//	if(PictureType == PT_CROPPED){
		return Rect.bottom - Rect.top;
//	}
/*	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	if(!pDDS) return FALSE;
	if(pDDS->GetSurfaceDesc(&ddsd) != DD_OK) return FALSE;
	
	return ddsd.dwHeight;
*/
}


bool cPicture::SetClipper(cClipper *pClipper){
	if(pClipper)
		return pDDS->SetClipper(pClipper->GetClipper()) == DD_OK;
	return pDDS->SetClipper(0) == DD_OK;
}

//////////////////////////////////////////////////////////////////////
//  
//////////////////////////////////////////////////////////////////////
LPDIRECTDRAWSURFACE7 cPicture::GetBackPic(int Index){
	LPDIRECTDRAWSURFACE7 pDDSBack;
	DDSCAPS2 ddscaps;

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	if(pDDS->GetAttachedSurface(&ddscaps, &pDDSBack) != DD_OK) 
		return 0;
	return pDDSBack;
}

//////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////
/*
bool cPicture::Restore(){
// Ҿ ǥ Ѵ.
	DDSURFACEDESC2 ddsd;

//	if(PictureType == PIECE_SURFACE) return true;

	if(pDDS->IsLost() != DDERR_SURFACELOST) return true;

	pDisplay->DestroyDoubleBuffer();
	pDisplay->CreateDoubleBuffer();

	if(pDDS->IsLost() != DDERR_SURFACELOST) return true;

	ddsd.dwSize = sizeof(DDSURFACEDESC2);

	if(pDDS->GetSurfaceDesc(&ddsd) != DD_OK)
		return false;

	Destroy();
*/
/*
	switch(PictureType){
	case PT_ORIGINAL:
		if(Display.GetDD()->CreateSurface(&ddsd, &pDDS, 0) != DD_OK)
			return false;
		break;
	case PT_ORIGINAL:
		if(pMedium){
			if(!Create(pMedium)) 
				return false;
		}else{
			if(Display.GetDD()->CreateSurface(&ddsd, &pDDS, 0) != DD_OK)
				return false;
		}
		break;
	}
*/
/*
	return true;
}
*/

void cPicture::operator=(LPDIRECTDRAWSURFACE7 _pDDS){
	DDSURFACEDESC2 ddsd;

	if(_pDDS == 0) return;
	Destroy();

	pDDS = _pDDS;
	pDDS->AddRef();

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	GetSurfaceDesc(&ddsd);

	xAdjust = 0;
	yAdjust = 0;

	SetRect(&Rect, 0, 0, ddsd.dwWidth, ddsd.dwHeight);
	PictureType = PT_ORIGINAL;

}



// Lock/Unlock //////////////////////////////////////////////////
void * cPicture::Lock(LPRECT lpDestRect, DWORD dwFlags){
	DDSURFACEDESC2 ddsd;

	if(lpDestRect){
		if(lpDestRect->right < 0 || lpDestRect->top < 0 ||
			lpDestRect->left > GetWidth() || lpDestRect->top > GetHeight())
			return 0;

		LockDestRect.left = lpDestRect->left + Rect.left;
		LockDestRect.top = lpDestRect->top + Rect.top;
		LockDestRect.right = lpDestRect->right + Rect.left;
		LockDestRect.bottom = lpDestRect->bottom + Rect.top;
	}else{
		LockDestRect = Rect;
	}

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	if(pDDS->Lock(&LockDestRect, &ddsd, dwFlags, 0) != DD_OK)
		return 0;
	Pitch = ddsd.lPitch;
	return ddsd.lpSurface;
}

void cPicture::Unlock(void *pMem){
	pDDS->Unlock(&LockDestRect);
}


bool cPicture::GetDC(HDC *phdc){
	if(pDDS->GetDC(phdc) != DD_OK)
		return false;
	hOldFont = (HFONT)SelectObject(*phdc, Display.GetFont());
	return true;
}

bool cPicture::ReleaseDC(HDC hdc){
	SelectObject(hdc, hOldFont);
	return pDDS->ReleaseDC(hdc) == DD_OK; 
}


COLORREF cPicture::GetPixel(int x, int y){
	HDC hdc;
	COLORREF rgb;

	if(pDDS->GetDC(&hdc) == DD_OK){
		rgb = ::GetPixel(hdc, Rect.left + x, Rect.top + y);
		pDDS->ReleaseDC(hdc);
		return rgb;

	}
	return RGB(0, 0, 0);
}

void cPicture::SetPixel(int x, int y, COLORREF c){
	HDC hdc;
	COLORREF rgb;

	if(pDDS->GetDC(&hdc) == DD_OK){
		rgb = ::SetPixel(hdc, x, y, c);
		pDDS->ReleaseDC(hdc);

	}
}

DWORD cPicture::GetDevicePixel(int x, int y){
	RECT rcDest;
	void* pMem;
	DWORD c;

	rcDest.left = x;
	rcDest.top = y;
	rcDest.right = x + 1;
	rcDest.bottom = y + 1;

	pMem = Lock(&rcDest);
	if(!pMem)
		return 0;

	switch(Display.GetPixelFormat()){
	case PF_16BPP565:
	case PF_16BPP555:
		c = *((WORD*)pMem); // + y * Pitch + x);
		break;
	default:
		c = 0;
	}
	Unlock(pMem);

	return c;
}

void cPicture::SetDevicePixel(int x, int y, DWORD c){
	void* pMem;

	pMem = Lock();
	if(!pMem)
		return;

	switch(Display.GetPixelFormat()){
	case PF_16BPP565:
	case PF_16BPP555:
		*((WORD*)pMem + y * Pitch + x) = (WORD)c;
		break;
	}
	Unlock(pMem);
}



bool cPicture::SetColorKey(DWORD dwFlags, DWORD Low, DWORD High){
	DDCOLORKEY ColorKey;

	ColorKey.dwColorSpaceLowValue = Low;
	ColorKey.dwColorSpaceHighValue = High;

	return pDDS->SetColorKey(dwFlags, &ColorKey) == DD_OK;
}

bool cPicture::Blt(LPRECT lpDestRect, cPicture *pSrc, 
				   LPRECT lpSrcRect, DWORD dwFlags, LPDDBLTFX lpDDBltFx){
	cRect rcSrc;
	cRect rcDest;
	cRect OldSrcRect;
	cRect OldDestRect;
	HRESULT hr;
	float sdRateX, sdRateY;

	if(lpDestRect){
		rcDest = *lpDestRect;
	}else{
		rcDest = Rect;
	}

	if(lpSrcRect){
		rcSrc = *lpSrcRect;
		rcSrc += pSrc->Rect.LeftTop();
		sdRateX = (float)rcDest.Width() / rcSrc.Width();
		sdRateY = (float)rcDest.Height() / rcSrc.Height();

		// ҽ Ŭ
		OldSrcRect = rcSrc;
		if(!pSrc->Rect.ClipRect(&rcSrc))
			return true;

		rcDest.left += int((rcSrc.left - OldSrcRect.left) * sdRateX);
		rcDest.top += int((rcSrc.top - OldSrcRect.top) * sdRateY);
		rcDest.right += int((rcSrc.right - OldSrcRect.right) * sdRateX);
		rcDest.bottom += int((rcSrc.bottom - OldSrcRect.bottom) * sdRateY);

	}else{
		rcSrc = pSrc->Rect;
		sdRateX = (float)rcDest.Width() / rcSrc.Width();
		sdRateY = (float)rcDest.Height() / rcSrc.Height();
	}
	if(sdRateX == 0.0f || sdRateY == 0.0f)
		return true;
	
	// Dest  Ŭ
	OldDestRect = rcDest;
	if(!Rect.ClipRect(&rcDest))
		return true;
	rcSrc.left += int((rcDest.left - OldDestRect.left) / sdRateX);
	rcSrc.top += int((rcDest.top - OldDestRect.top) / sdRateY);
	rcSrc.right += int((rcDest.right - OldDestRect.right) / sdRateX);
	rcSrc.bottom += int((rcDest.bottom - OldDestRect.bottom) / sdRateY);
	if(!rcSrc.IsNormal())
		return true;
	if(!rcDest.IsNormal())
		return true;

	hr = pDDS->Blt(&rcDest, *pSrc, &rcSrc, dwFlags, lpDDBltFx);

	switch(hr){
	case DDERR_GENERIC  : assert(false); break;
	case DDERR_INVALIDCLIPLIST  : assert(false); break;
	case DDERR_INVALIDOBJECT  : assert(false); break;
	case DDERR_INVALIDPARAMS  : assert(false); break;
	case DDERR_INVALIDRECT  : assert(false); break;
	case DDERR_NOALPHAHW  : assert(false); break;
	case DDERR_NOBLTHW  : assert(false); break;
	case DDERR_NOCLIPLIST  : assert(false); break;
	case DDERR_NODDROPSHW  : assert(false); break;
	case DDERR_NOMIRRORHW  : assert(false); break;
	case DDERR_NORASTEROPHW  : assert(false); break;
	case DDERR_NOROTATIONHW  : assert(false); break;
	case DDERR_NOSTRETCHHW  : assert(false); break;
	case DDERR_NOZBUFFERHW  : assert(false); break;
	case DDERR_SURFACEBUSY  : assert(false); break;
	case DDERR_SURFACELOST  : assert(false); break;
	case DDERR_UNSUPPORTED  : assert(false); break;
	case DDERR_WASSTILLDRAWING : assert(false); break;
	}

	return hr == DD_OK;
}

bool cPicture::BltFast(int x, int y, cPicture *pSrc, 
					   LPRECT lpSrcRect, DWORD dwFlags){
	cRect rcSrc;
	cRect rcDest;
	cRect OldDestRect;
	int OldX, OldY;

	if(lpSrcRect){
		rcSrc = *lpSrcRect;
		rcSrc += pSrc->Rect.LeftTop();
		// ҽ Ŭ
		OldX = rcSrc.left;
		OldY = rcSrc.top;
		if(!pSrc->Rect.ClipRect(&rcSrc))
			return true;

		x += rcSrc.left - OldX;
		y += rcSrc.top - OldY;

	}else{
		rcSrc = pSrc->Rect;
	}
	
	// Dest  Ŭ
	rcDest.Set(x, y, x + rcSrc.Width(), y + rcSrc.Height());
	OldDestRect = rcDest;
	if(!Rect.ClipRect(&rcDest))
		return true;
	rcSrc += rcDest - OldDestRect;
	if(!rcSrc.IsNormal())
		return true;

	HRESULT hr;

	hr = pDDS->BltFast(rcDest.left, rcDest.top, *pSrc, &rcSrc, dwFlags);
/*	if(hr != DD_OK){
		CString str;
		str.Format("Blt Fast Fail Code %d", hr && 0xffff);
		AfxMessageBox(str);
		PostQuitMessage(0);
	}
*/
	return hr == DD_OK;
}

bool cPicture::BltAdjust(int x, int y, cPicture *pSrc, DWORD dwFlags){
	return BltFast(x + pSrc->xAdjust, y + pSrc->yAdjust, pSrc, 0, dwFlags);
}

bool cPicture::Blt(int x, int y, cPicture *pSrc, DWORD dwFlags){
	RECT rcDest;
	HRESULT hr;

	if(!pDDS)
		return false;

	rcDest.left = Rect.left + x;
	rcDest.top = Rect.top + y;
	rcDest.right = rcDest.left + pSrc->GetWidth();
	rcDest.bottom = rcDest.top + pSrc->GetHeight();

	hr = pDDS->Blt(&rcDest, *pSrc, &pSrc->Rect, dwFlags, 0);

/*
	if(hr == DDERR_SURFACELOST){
		Restore();
		pSrc->Restore();

		hr = pDDS->Blt(&rcDest, *pSrc, &pSrc->Rect, dwFlags, 0);
	}
*/
	return hr == DD_OK;
}



bool cPicture::ClearRect(LPRECT prc, DWORD c){
	DDBLTFX fx;

	fx.dwSize = sizeof(fx);
	fx.dwFillColor = c;

	return pDDS->Blt(prc, 0, 0, DDBLT_COLORFILL | DDBLT_WAIT, &fx) == DD_OK;
}


bool cPicture::Flip(cPicture* pSrc, DWORD Flags){
	return pDDS->Flip(*pSrc, Flags) == DD_OK;
}



void ShadowTextOut(HDC hdc, int x, int y, LPCTSTR pStr, COLORREF fgColor, COLORREF bgColor){
	int Len;

	Len = strlen(pStr);

	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, bgColor);
	TextOut(hdc, x + 1, y + 1, pStr, Len);
	SetTextColor(hdc, fgColor);
	TextOut(hdc, x, y, pStr, Len);
}


// Blending Blitting ////////////////////////////////////////////////////////////////////////////////
bool cPicture::BlendedBltAdjust(int x, int y, cPicture *pSrc, ePictureBlendingEffect Blending){
	return BlendedBlt(x + pSrc->xAdjust, y + pSrc->yAdjust, pSrc, 0, Blending);
}

bool cPicture::BlendedBlt(int x, int y, cPicture *pSrc, cRect* lpSrcRect, ePictureBlendingEffect Blending){
	//  ÷ Ѵ.
	cRect rcSrc;
	cRect LogSrcRect;
	cRect rcDest;
	cRect OldDestRect;
	cRect LogDestRect;
	int OldX, OldY;

	if(lpSrcRect){
		rcSrc = *lpSrcRect;
		// ҽ Ŭ
		LogSrcRect.Set(0, 0, pSrc->Rect.Width(), pSrc->Rect.Height());

		OldX = rcSrc.left;
		OldY = rcSrc.top;
		if(!LogSrcRect.ClipRect(&rcSrc))
			return true;

		x += rcSrc.left - OldX;
		y += rcSrc.top - OldY;
	}else{
		rcSrc.Set(0, 0, pSrc->Rect.Width(), pSrc->Rect.Height());
	}
	
	// Dest  Ŭ
	LogDestRect.Set(0, 0, Rect.Width(), Rect.Height());
	rcDest.Set(x, y, x + rcSrc.Width(), y + rcSrc.Height());
	OldDestRect = rcDest;
	if(!LogDestRect.ClipRect(&rcDest))
		return true;
	rcSrc += rcDest - OldDestRect;
	if(!rcSrc.IsNormal())
		return true;

	WORD* pDestMem, * pSrcMem;

	rcDest.Set(x, y, x + rcSrc.Width(), y + rcSrc.Height());
	pDestMem = (WORD*)Lock(&rcDest);
	if(!pDestMem)
		return false;

	pSrcMem = (WORD*)pSrc->Lock(&rcSrc);
	if(!pSrcMem){
		Unlock(pDestMem);
		return false;
	}

	if(Blending < PBE_PrepareCount){
		BlendedBlt(pDestMem, Pitch / 2, pSrcMem, pSrc->GetPitch() / 2, rcDest.Width(), rcDest.Height(), Display.GetBlendingTable(Blending));
	}else{
		BlendedBlt(pDestMem, Pitch / 2, pSrcMem, pSrc->GetPitch() / 2, rcDest.Width(), rcDest.Height(), Blending);
	}

	pSrc->Unlock(pSrcMem);
	Unlock(pDestMem);

	return true;
}


// Blended Blitting Methodes;
void cPicture::BlendedBlt(WORD* pDestMem, int DestPitch, WORD* pSrcMem, int SrcPitch, 
						  int Width, int Height, BYTE (*pTable)[32]){
	register y, x, d, s;

	if(Display.GetPixelFormat() == PF_16BPP555){
		for(y = Height; y; y --){
			for(x = Width; x; x --){
				d = *pDestMem;
				s = *pSrcMem;
				*pDestMem = 
					((int)(pTable[(d & 0x7C00) >> 10][(s & 0x7C00) >> 10]) << 10) |
					((int)(pTable[(d & 0x03E0) >> 5][(s & 0x03E0) >> 5]) << 5) |
					(int)(pTable[d & 0x001F][s & 0x001F]);
				pDestMem ++;
				pSrcMem ++;
			}
			pDestMem += DestPitch - Width;
			pSrcMem += SrcPitch - Width;
		}

	}else{ // 565 - rrrr rggg gggb bbbb
		for(y = Height; y; y --){
			for(x = Width; x; x --){ // 79ef
				d = *pDestMem;
				s = *pSrcMem;
				*pDestMem = (WORD)
					((int)(pTable[(d & 0xF800) >> 11][(s & 0xF800) >> 11]) << 11) |
					((int)(pTable[(d & 0x07C0) >> 6][(s & 0x07C0) >> 6]) << 6) |
					(int)(pTable[d & 0x001F][s & 0x001F]);
				pDestMem ++;
				pSrcMem ++;
			}
			pDestMem += DestPitch - Width;
			pSrcMem += SrcPitch - Width;
		}
	}

}

void cPicture::BlendedBlt(WORD* pDestMem, int DestPitch, WORD* pSrcMem, int SrcPitch, 
						  int Width, int Height, int Blending){
	register y, x, d, s;

	if(Display.GetPixelFormat() == PF_16BPP555){
		switch(Blending){
		case PBE_Red:
			for(y = Height; y; y --){
				for(x = Width; x; x --){
					d = *pDestMem;
					s = *pSrcMem;
					if(s) *pDestMem = s & 0x7C00;
					pDestMem ++;
					pSrcMem ++;
				}
				pDestMem += DestPitch - Width;
				pSrcMem += SrcPitch - Width;
			}
			break;
		case PBE_Green:
			for(y = Height; y; y --){
				for(x = Width; x; x --){
					d = *pDestMem;
					s = *pSrcMem;
					if(s) *pDestMem = s & 0x03E0;
					pDestMem ++;
					pSrcMem ++;
				}
				pDestMem += DestPitch - Width;
				pSrcMem += SrcPitch - Width;
			}
			break;
		case PBE_Blue:
			for(y = Height; y; y --){
				for(x = Width; x; x --){
					d = *pDestMem;
					s = *pSrcMem;
					if(s){
						*pDestMem = s & 0x001F;
					}
					pDestMem ++;
					pSrcMem ++;
				}
				pDestMem += DestPitch - Width;
				pSrcMem += SrcPitch - Width;
			}
			break;
		}

	}else{ // 565 - rrrr rggg gggb bbbb
		switch(Blending){
		case PBE_Red:
			for(y = Height; y; y --){
				for(x = Width; x; x --){
					d = *pDestMem;
					s = *pSrcMem;
					if(s) *pDestMem = s & 0xF800;
					pDestMem ++;
					pSrcMem ++;
				}
				pDestMem += DestPitch - Width;
				pSrcMem += SrcPitch - Width;
			}
			break;
		case PBE_Green:
			for(y = Height; y; y --){
				for(x = Width; x; x --){
					d = *pDestMem;
					s = *pSrcMem;
					if(s) *pDestMem = s & 0x07C0;
					pDestMem ++;
					pSrcMem ++;
				}
				pDestMem += DestPitch - Width;
				pSrcMem += SrcPitch - Width;
			}
			break;
		case PBE_Blue:
			for(y = Height; y; y --){
				for(x = Width; x; x --){
					d = *pDestMem;
					s = *pSrcMem;
					if(s){
						*pDestMem = s & 0x001F;
					}
					pDestMem ++;
					pSrcMem ++;
				}
				pDestMem += DestPitch - Width;
				pSrcMem += SrcPitch - Width;
			}
			break;
		}
	}

}

void cPicture::GetSurfaceDesc(LPDDSURFACEDESC2 pddsd){
	pddsd->dwSize = sizeof(DDSURFACEDESC2);
	pDDS->GetSurfaceDesc(pddsd);
}

cString *cPicture::GetFileName(){
	return &FileName;
}
