/*
	 ׸ .
	׸ ̷Ʈ ο ǥ Ϻκ   ִ.
*/
#ifndef cPicture_H 
#define cPicture_H

#include "cMedium.h"
#include "cShape.h"
#include "cString.h"

class cDisplay;
class cClipper;

enum ePictureBlendingEffect{
	// COPY( ), BLT( )
	PBE_NORMAL, //  
	PBE_NORMAL30, // 24    31 ƽ
	PBE_AVERAGE, //   
	PBE_LIGHT, //   ׸
	PBE_LIGHT_COPY, //   ׸,  ǥ 
	PBE_DARK, //   ׸
	PBE_ADD, // 
	PBE_AND, // 
	PBE_OR, // 
	PBE_MIN, // ּҰ 
	PBE_MAX, // ִ밪 
	PBE_COLOR_DODGE,
	PBE_SHADE,

	PBE_PrepareCount,

	PBE_Red, //  и ׸
	PBE_Green, //  и ׸
	PBE_Blue, //  и ׸

	PBE_Count

};
class cPicture{
private:
	RECT LockDestRect;

public:
	enum ePictureType{
		PT_NONE = 0, // ǥ غǾ  ʴ.
		PT_ORIGINAL, // 
		PT_CROPPED // ٸ ǥ 
	};

// ǥ 
protected:
	LPDIRECTDRAWSURFACE7 pDDS; // ׸  ϴ ǥ
	ePictureType PictureType; // ׸ 

	cRect Rect; // ǥ 簢  ׸ ȴ.
	int xAdjust, yAdjust; //  ġ
	int Pitch;

	HFONT hOldFont;

	void BlendedBlt(WORD* pDestMem, int DestPitch, WORD* pSrcMem, int SrcPitch, int Width, int Height, BYTE (*pTable)[32]);
	void BlendedBlt(WORD* pDestMem, int DestPitch, WORD* pSrcMem, int SrcPitch, int Width, int Height, int Blending);

	cString FileName;

public:
	cPicture();
	virtual ~cPicture();

	// ׸  ̽
	bool Create(int BackBufferCount = 0);
	bool Create(cPicture *pSrc);
	bool Create(DWORD Width, DWORD Height, DWORD dwFlags = DDSCAPS_SYSTEMMEMORY);
	bool Create(const char *_FileName);
	bool CreateReference(cPicture *pSrc, int Left, int Top, int Right, int Bottom);
	void Destroy();

	// Recorder
	virtual bool Load(cMedium * pMedium);
	virtual bool Save(cMedium * pMedium);
	bool Save(const char* FileName);

	LPDIRECTDRAWSURFACE7 GetBackPic(int Index = 0);
	void operator =(LPDIRECTDRAWSURFACE7 _pDDS);
	operator LPDIRECTDRAWSURFACE7(){ return pDDS; }
	LPDIRECTDRAWSURFACE7 GetDDS(){ return pDDS; }

	//
	bool SetClipper(cClipper *pClipper);

	// ׸ Ӽ 
	ePictureType GetType(){ return PictureType; }

	bool GetSize(LPSIZE psz);
	int GetWidth();
	int GetHeight();
	int GetPitch(){ return Pitch; }
	cRect* GetRect(){ return &Rect; }

	void SetArea(LPDIRECTDRAWSURFACE7 _pDDS, RECT *pRect);
	void SetArea(cRect* pRect){ Rect = *pRect; }
	void GetArea(cRect* pRect){ *pRect = Rect; }

	bool SetColorKey(DWORD dwFlags, DWORD Low, DWORD High = 0);
	void SetAdjust(int _xAdjust, int _yAdjust){ xAdjust = _xAdjust; yAdjust = _yAdjust; }
	int GetAdjustX(){ return xAdjust; }
	int GetAdjustY(){ return yAdjust; }

	void GetSurfaceDesc(LPDDSURFACEDESC2 pddsd);

	// ׸
	bool BltFast(int x, int y, cPicture *pSrc, LPRECT lpSrcRect = 0, DWORD dwFlags = DDBLTFAST_WAIT);
	bool BltAdjust(int x, int y, cPicture *pSrc, DWORD dwFlags = DDBLTFAST_WAIT);
	bool Blt(LPRECT lpDestRect, cPicture *pSrc, LPRECT lpSrcRect = 0, DWORD dwFlags = DDBLT_WAIT, LPDDBLTFX lpDDBltFx = NULL);
	bool Blt(int x, int y, cPicture *pSrc, DWORD dwFlags = DDBLT_WAIT);
	// ȥ ׸
	bool BlendedBltAdjust(int x, int y, cPicture *pSrc, ePictureBlendingEffect Blending);
	bool BlendedBlt(int x, int y, cPicture *pSrc, cRect* lpSrcRect, ePictureBlendingEffect Blending);


	bool Flip(cPicture* pSrc, DWORD Flags = DDFLIP_WAIT);


	// DC
	bool GetDC(HDC *phdc);
	bool ReleaseDC(HDC hdc);

	COLORREF GetPixel(int x, int y);
	void SetPixel(int x, int y, COLORREF c);
	bool GetPixelFormat(LPDDPIXELFORMAT ppf);

	DWORD GetDevicePixel(int x, int y);
	void SetDevicePixel(int x, int y, DWORD c);

//	int GetFontWidth();
//	int GetFontHeight();

	void * cPicture::Lock(LPRECT lpDestRect = NULL, DWORD dwFlags = DDLOCK_WAIT);
	void Unlock(void *pMem);

	// Drawing
	bool ClearRect(LPRECT prc = 0, DWORD c = 0);

	cString *GetFileName();

};

// GDI Helper Functions
void ShadowTextOut(HDC hdc, int x, int y, LPCTSTR pStr, COLORREF fgColor = RGB(255, 255, 255), COLORREF bgColor = RGB(0, 0, 0));

#endif 
