#include "TOOL.h"
#include "cPictureBook.h"

cPictureBook::cPictureBook(){

}

cPictureBook::~cPictureBook(){

}

bool cPictureBook::Create(int Size){
	int i;

	if(!cPictureArray::Create(Size))
		return false;

	for(i = 0; i < GetCount(); i ++){
		Set(i, 0);
	}
	return true;
}

void cPictureBook::Destroy(){
	int i;

	if(Elements){
		for(i = 0; i < GetCount(); i ++){
			if(Get(i))
				delete Get(i);
		}
		cPictureArray::Destroy();
	}
}


cPicture *cPictureBook::GetPicture(int Idx){
	if(Idx >= ElementCount || Idx < 0){
		Idx = 0;
	}
	if(Elements[Idx] == 0)
		Set(Idx, new cPicture);
	return Get(Idx);
}


bool cPictureBook::LoadPicture(int idx, const char *FileName){
//	cMedium *pMedium;

//	pMedium = new cMedium(FileName);
	
	return GetPicture(idx)->Create(FileName);
}

bool cPictureBook::CropPicture(int DestIdx, int SrcIdx, int Left, int Top, int Right, int Bottom){
	cPicture *SrcPic;
	cPicture *DestPic;

	SrcPic = GetPicture(SrcIdx);
	DestPic = GetPicture(DestIdx);
	return DestPic->CreateReference(SrcPic, Left, Top, Right, Bottom);
}

bool cPictureBook::AutoCropPicture(const char *FileName, 
		int PictureCount, int Width, int Height){
	int i, x, y;
	int PictureWidth;

	if(!Create(PictureCount + 1))
		return FALSE;

	if(!LoadPicture(GetCount() - 1, FileName))
		return FALSE;

	PictureWidth = GetPicture(GetCount() - 1)->GetWidth();

	x = 0; y = 0;

	for(i = 0; i < PictureCount; i ++){
		CropPicture(i, ElementCount - 1, x, y, x + Width, y + Height);
		x += Width;
		if(x + Width > PictureWidth){
			x = 0;
			y += Height;
		}
	}
	return TRUE;
}


bool cPictureBook::AcceptScript(const char *FileName){
	char Buff[256], Lexeme[256];
	int a, b, c, d, e, f, g, h;
	FILE *pFile;

	pFile = fopen(FileName, "rt");
	if(!pFile) return false;

	while(true){
		if(!fgets(Buff, 256, pFile)) break;

		if(strncmp(Buff, "Create", 6) == 0){
			if(sscanf(Buff + 6, "%*[(] %d %*[)] %*[;]", &a) == 1){
				Create(a);
			}
		}else if(strncmp(Buff, "AutoCropPicture", 15) == 0){
			if(sscanf(Buff + 15, "%*[(] %*[\"] %s %*[\"] %*[,] %d %*[,] %d %*[,] %d %*[)] %*[;]", Lexeme, &a, &b, &c) == 4){
				AutoCropPicture(Lexeme, a, b, c);
			}
		}else if(strncmp(Buff, "LoadPicture", 11) == 0){
			if(sscanf(Buff + 11, "%*[(] %d %*[,] %*[\"] %[^*?\"'] %*[\"] %*[,] %d %*[,] %d %*[)] %*[;]", &a, Lexeme, &b, &c) == 4){
				LoadPicture(a, Lexeme);
				GetPicture(a)->SetAdjust(b, c);
			}
		}else if(strncmp(Buff, "CropPicture", 11) == 0){
			if(sscanf(Buff + 11, "%*[(] %d %*[,] %d %*[,] %d %*[,] %d %*[,] %d %*[,] %d %*[,] %d %*[,] %d %*[,] %*[)] %*[;]", &a, &b, &c, &d, &e, &f, &g, &h) == 8){
				CropPicture(a, b, c, d, e, f);
				GetPicture(a)->SetAdjust(g, h);
			}
		}
	}

	fclose(pFile);
	return true;

}

int cPictureBook::GetPictureIndex(LPCTSTR PictureName){
	int i;

	for(i = 0; i < GetCount(); i ++){
		if(GetPicture(i)->GetFileName()->Compare(PictureName, false) == 0)
			return i;
	}
	return -1;
}

int cPictureBook::InsertNullPicture(int PrevIndex){
	cPictureArray::Insert(0, PrevIndex);
	return PrevIndex;
}

void cPictureBook::DeletePicture(int Index){
	if(Get(Index))
		delete Get(Index);
	cPictureArray::Delete(Index);

}
