#ifndef cPictureBook_H
#define cPictureBook_H

#include "cPicture.h"
#include "cArray.h"

typedef cArray<cPicture *> cPictureArray;

class cPictureBook : public cPictureArray{
public:
	cPictureBook();
	virtual ~cPictureBook();

	bool Create(int Size);
	virtual void Destroy();

	cPicture *GetPicture(int Idx);
	bool LoadPicture(int Idx, const char *FileName);
	bool CropPicture(int DestIdx, int SrcIdx, int Left, int Top, int Right, int Bottom);
	bool AutoCropPicture(const char *FileName, int PictureCount, int Width, int Height);
	bool AcceptScript(const char *FileName);
	bool BindFile(const char *FileName){ return AcceptScript(FileName); }

	int GetPictureIndex(LPCTSTR PictureName);
	int InsertNullPicture(int PrevIndex);
	void DeletePicture(int Index);
};

#endif
