#include "TOOL.h"
#include "cPointerSet.h"

template<class Type>
cPointerSet<Type>::cPointerSet(){
	Pointers = 0;
}

template<class Type>
cPointerSet<Type>::~cPointerSet(){
	if(Pointers) delete [] Pointers;
}

template<class Type>
bool cPointerSet<Type>::Create(int Size){
	PointerCount = Size;
	Pointers = new Type *[PointerCount];
	return Pointers != 0;
}

template<class Type>
void cPointerSet<Type>::Destroy(){
	if(Pointers) delete [] Pointers;
	Pointers = 0;
}

template<class Type>
void cPointerSet<Type>::Swap(int i, int j){
	Type *p;
	p = Pointers[i];
	Pointers[i] = Pointers[j];
	Pointers[j] = p;
}


template<class Type>
void cPointerSet<Type>::QuickSort(){
	QuickSort(0, PointerCount - 1);
}


template<class Type>
void cPointerSet<Type>::QuickSort(int Left, int Right){
	int i, j = Left, Key;

	if(Left >= Right) return;

	Key = Pointers[Left]->GetKey();

	for(i = Left + 1; i <= Right; i ++){
		if(Pointers[i]->GetKey() < Key){
			j ++;
			Swap(i, j);
		}
	}
	Swap(Left, j);
	QuickSort(Left, j - 1);
	QuickSort(j + 1, Right);
}
