#include "TOOL.h"
#include "cShape.h"
#include "TOOLUtils.h"


// cShape ///////////////////////////////////////////////////

// cPoint ///////////////////////////////////////////////////
bool cPoint::operator==(cPoint& a){
	return x == a.x && y == a.y;
}

bool cPoint::operator!=(cPoint& a){
	return x != a.x || y != a.y;
}

cPoint cPoint::operator+=(cPoint& a){
	x += a.x;
	y += a.y;
	return *this;
}

cPoint cPoint::operator-=(cPoint& a){
	x -= a.x;
	y -= a.y;
	return *this;
}

cPoint operator+(cPoint& a, cPoint& b){
	cPoint c;
	c.x = a.x + b.x;
	c.y = a.y + b.y;
	return c;
}

cPoint operator-(cPoint& a, cPoint& b){
	cPoint c;
	c.x = a.x - b.x;
	c.y = a.y - b.y;
	return c;
}

// cRect //////////////////////////////////////////////////////////

cPoint cRect::LeftTop(){
	cPoint pt;
	pt.x = left;
	pt.y = top;
	return pt;
}

cPoint cRect::RightBottom(){
	cPoint pt;
	pt.x = right;
	pt.y = bottom;
	return pt;
}


cRect& cRect::operator+=(cPoint& a){
	left += a.x;
	top += a.y;
	right += a.x;
	bottom += a.y;
	return *this;
}

cRect& cRect::operator-=(cPoint& a){
	left -= a.x;
	top -= a.y;
	right -= a.x;
	bottom -= a.y;
	return *this;
}

cRect cRect::operator+(cPoint& a){
	cRect rc;

	rc.left = left + a.x;
	rc.top = top + a.y;
	rc.right = right + a.x;
	rc.bottom = bottom + a.y;
	return rc;
}

cRect cRect::operator-(cPoint& a){
	cRect rc;

	rc.left = left - a.x;
	rc.top = top - a.y;
	rc.right = right - a.x;
	rc.bottom = bottom - a.y;
	return rc;
}

bool cRect::ClipRect(cRect *pRect){
	// Ŭ ؼ ܿ 簢 ִٸ true
	// ƴϸ false
	if(left >= pRect->right ||
		top >= pRect->bottom ||
		right <= pRect->left ||
		bottom <= pRect->top)
		return false;

	if(left > pRect->left)
		pRect->left = left;

	if(top > pRect->top)
		pRect->top = top;

	if(right < pRect->right)
		pRect->right = right;

	if(bottom < pRect->bottom)
		pRect->bottom = bottom;

	return true;
}

bool cRect::IsNormal(){
	return left < right && top < bottom;
}

void cRect::Normalize(){
	if(left > right) Swap(left, right);
	if(top > bottom) Swap(top, bottom);
}

cRect& cRect::operator+=(cRect& a){
	left += a.left;
	top += a.top;
	right += a.right;
	bottom += a.bottom;
	return *this;
}

cRect& cRect::operator-=(cRect& a){
	left -= a.left;
	top -= a.top;
	right -= a.right;
	bottom -= a.bottom;
	return *this;
}

cRect operator+(cRect &a, cRect &b){
	cRect c;
	c = a;
	c += b;
	return c;
}

cRect operator-(cRect &a, cRect &b){
	cRect c;
	c = a;
	c -= b;
	return c;
}


