#ifndef cShape_H
#define cShape_H


class cPoint : public tagPOINT{
public:
	cPoint(){}

	cPoint(DWORD val){
		x = LOWORD(val);
		y = HIWORD(val);
	}
	cPoint(int _x, int _y){
		x = _x;
		y = _y;
	}

	cPoint operator-=(cPoint& a);
	cPoint operator+=(cPoint& a);

	bool operator==(cPoint& a);
	bool operator!=(cPoint& a);

	friend cPoint operator-(cPoint& a, cPoint& b);
	friend cPoint operator+(cPoint& a, cPoint& b);


	operator LPPOINT(){ return LPPOINT(this); }
//	operator DWORD(){ return DWORD(*this); }

};


class cShape{
public:
};

class cCircle{
public:
	int x;
	int y;
	int Radius;

	void Set(int _x, int _y, int _Radius){
		x = _x;
		y = _y;
		Radius = _Radius;
	}
};

class cSphere : public cCircle{
public:
	int z;

	void Set(int _x, int _y, int _z, int _Radius){
		x = _x;
		y = _y;
		z = _z;
		Radius = _Radius;
	}
};

class cRect : public tagRECT{
public:
	void Set(int _Left, int _Top, int _Right, int _Bottom){
		left = _Left;
		top = _Top;
		right = _Right;
		bottom = _Bottom;
	}
	void ClipRect(int _left, int _top, int _right, int _bottom){
		if(left < _left) left = _left;
		if(top < _top) top = _top;
		if(right > _right) right = _right;
		if(bottom > _bottom) bottom = _bottom;
	}
	bool IsIn(int x, int y){
		return (x >= left && y >= top && x < right && y < bottom);
	}
	bool IsIn(cPoint pt){
		return (pt.x >= left && pt.y >= top && pt.x < right && pt.y < bottom);
	}
	int Width(){ return right - left; }
	int Height(){ return bottom - top; }
	cPoint LeftTop();
	cPoint RightBottom();

	operator LPRECT(){ return LPRECT(this); }

	cRect& operator=(RECT& a){ *((LPRECT)this) = a; return *this; }
	cRect& operator+=(cRect& a);
	cRect& operator-=(cRect& a);

	friend cRect operator+(cRect &a, cRect &b);
	friend cRect operator-(cRect &a, cRect &b);

	cRect& operator+=(cPoint& a);
	cRect& operator-=(cPoint& a);

	cRect operator+(cPoint& a);
	cRect operator-(cPoint& a);

	bool ClipRect(cRect *pRect);

	bool IsNormal();
	void Normalize();

};


typedef cRect cEllipse;


#endif 
