#include "TOOL.h"
#include "cSharedObject.h"

template<class cClass>
cSharedObject<cClass>::cSharedObject(){
	RefCount = 0;
	pObject = 0;
}

template<class cClass>
cSharedObject<cClass>::~cSharedObject(){
	ReleaseAll();
}

template<class cClass>
cClass* cSharedObject<cClass>::RefObject(){
	if(pObject){
		RefCount ++;
		return pObject;
	}
	RefCount = 1;
	pObject = new cClass;
	return pObject;
}

template<class cClass>
cClass* cSharedObject<cClass>::GetObject(){
	return pObject;
}

template<class cClass>
int cSharedObject<cClass>::ReleaseObject(){
	RefCount --;
	if(RefCount <= 0){
		delete pObject;
		pObject = 0;
	}
	return RefCount;
}

template<class cClass>
void cSharedObject<cClass>::ReleaseAll(){
	RefCount = 0;
	if(pObject){
		delete pObject;
		pObject = 0;
	}
}
