#include "TOOL.h"

#include "cSoundChannel.h"
#include "cSoundPlayer.h"

cSoundChannel::cSoundChannel(){
	pDSB = 0;

}

cSoundChannel::~cSoundChannel(){

}

bool cSoundChannel::Create(int Length, int Channels, int SamplesPerSec, int BitsPerSample){
	PCMWAVEFORMAT pcmwf; 
	DSBUFFERDESC dsbdesc; 

	if(!SoundPlayer.pDS) return false;

	memset(&pcmwf, 0, sizeof(PCMWAVEFORMAT)); 
	pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM; 
	pcmwf.wf.nChannels = Channels; 
	pcmwf.wf.nSamplesPerSec = SamplesPerSec; 
	pcmwf.wf.nBlockAlign = 4; 
	pcmwf.wf.nAvgBytesPerSec = pcmwf.wf.nSamplesPerSec * pcmwf.wf.nBlockAlign; 
	pcmwf.wBitsPerSample = BitsPerSample;
	
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	dsbdesc.dwFlags = DSBCAPS_CTRL3D | DSBCAPS_CTRLVOLUME ; 
	dsbdesc.dwBufferBytes = Length; // 3 * pcmwf.wf.nAvgBytesPerSec; 
	dsbdesc.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf; 
	if(SoundPlayer.pDS->CreateSoundBuffer(&dsbdesc, &pDSB, 0) != DS_OK)
		return false;
	return true;

}

void cSoundChannel::Destroy(){
	if(pDSB) pDSB->Release();
	pDSB = 0;
}


void cSoundChannel::Start(bool Looping){
	if(!pDSB) return;
	pDSB->Play(0, 0, (Looping == true)? DSBPLAY_LOOPING : 0);
}

void cSoundChannel::Stop(){
	if(!pDSB) return;
	pDSB->Stop();
}


bool cSoundChannel::CreateFromWaveFile(char * _FileName){
	char * pData;
	HMMIO hmfr;
	MMCKINFO parent, child;
	WAVEFORMATEX wfmtx;

	strncpy(FileName, _FileName, 256);

	parent.ckid = (FOURCC)0;
	parent.cksize = 0;
	parent.fccType = (FOURCC)0;
	parent.dwDataOffset = 0;
	parent.dwFlags = 0;

	child = parent;

	hmfr = mmioOpen(FileName, NULL, MMIO_READ | MMIO_ALLOCBUF);
	if (hmfr == 0) return false;

	/* descend into the RIFF */
	parent.fccType = mmioFOURCC('W', 'A', 'V', 'E');

	if (mmioDescend(hmfr, &parent, NULL, MMIO_FINDRIFF)){
		mmioClose(hmfr, 0);
		return false;
	}

	/* descend to the WAVEfmt */
	child.ckid = mmioFOURCC('f', 'm', 't', ' ');

	if (mmioDescend(hmfr, &child, &parent, 0)){
		mmioClose(hmfr, 0);
		return false;
	}

	/* read the WAVEFMT from the wave file */
	if (mmioRead(hmfr, (char*)&wfmtx, sizeof(wfmtx)) != sizeof(wfmtx)){
		mmioClose(hmfr, 0);
		return false;
	}

	/* We only handle PCM format WAVEs */
	if (wfmtx.wFormatTag != WAVE_FORMAT_PCM){
		mmioClose(hmfr, 0);
		return false;
	}

	if (mmioAscend(hmfr, &child, 0)){
		mmioClose(hmfr, 0);
		return false;
	}

	/* descend to the data chunk */
	child.ckid = mmioFOURCC('d', 'a', 't', 'a');

	if (mmioDescend(hmfr, &child, &parent, MMIO_FINDCHUNK)){
		mmioClose(hmfr, 0);
		return false;
	}

	pData = new char[child.cksize];

	assert(pData);

	/* read the wave data */
	if ((DWORD)mmioRead(hmfr, pData, child.cksize) != child.cksize){
		mmioClose(hmfr, 0);
		delete pData;
		return false;
	}

	mmioClose(hmfr, 0);

	if(Create(child.cksize)){
		LoadWave(pData, child.cksize);
	}
	delete [] pData;

	return true;
}


bool cSoundChannel::LoadWave(char * pData, int Len){
	LPVOID write1;
	DWORD length1;
	LPVOID write2;
	DWORD length2;
	HRESULT hr;

	hr = pDSB->Lock(0, Len, &write1, &length1, 
		&write2, &length2, 0);

	if (hr == DSERR_BUFFERLOST){
		pDSB->Restore();
		hr = pDSB->Lock(0, Len, &write1, &length1,
			&write2, &length2, 0);
	}
	if(hr != 0) return false;

	CopyMemory(write1, pData, length1);

	if (write2){
		CopyMemory(write2, pData + length1, length2);
	}

	hr = pDSB->Unlock(write1, length1, write2, length2);

	return hr == DS_OK;
}
