#include "TOOL.h"
#include "cSoundPlayer.h"

cSoundPlayer SoundPlayer;

cSoundPlayer::cSoundPlayer(){
	pDS = 0;

}

cSoundPlayer::~cSoundPlayer(){
}

bool cSoundPlayer::Open(HWND _hWnd){
	hWnd = _hWnd;
	if(DirectSoundCreate(0, &pDS, 0) != DS_OK) return false;
	if(!SetCooperativeLevel(DSSCL_NORMAL)) return false;
	return true;
}

void cSoundPlayer::Close(){
	while(GetCount()){
		GetHead()->Destroy();
		delete GetHead();
		RemoveHead();
	}

	if(pDS) pDS->Release();
	pDS = 0;
}

bool cSoundPlayer::SetCooperativeLevel(DWORD Mode){
	return pDS->SetCooperativeLevel(hWnd, Mode) == DS_OK;
}

cSoundChannel * cSoundPlayer::CreateChannel(){
	cSoundChannel * pChannel;

	pChannel = new cSoundChannel;
	assert(pChannel);
	
	AddTail(pChannel);

	return pChannel;
}

