#include "TOOL.h"
#include "cString.h"
#include "cMedium.h"
#include "TOOLUtils.h"

char* NULL_STRING = "\0";
 
#define min(a, b)  (((a) < (b)) ? (a) : (b)) 

static char Buffer[16384];
/////////////////////////////////////////////////////////////////////
cString::cString(){
	String = NULL_STRING;
	Length = 0;
	Allocate = false;
}

cString::cString(long nSize){
	String = NULL_STRING;
	Length = 0;
	Allocate = false;
	Create(nSize);
}

cString::cString(const char *nString){
	String = NULL_STRING;
	Length = 0;
	Allocate = false;
	Create(nString);
}

cString::cString(cString &A){
	String = NULL_STRING;
	Length = 0;
	Allocate = false;
	Create(A);
}

cString::~cString(){
	Destroy();
}
//////////////////////////////////////////////////////////////////////////
void cString::Create(long nSize){
	Destroy();
	if(nSize <= 0){
		String = NULL_STRING;
		Allocate = false;
		Length = 0;
		return;
	}
	Length = nSize;
	String = new char[Length];
	String[0] = '\0';
	Allocate = true;
}

void cString::Create(const char *nString){
	Destroy();
	if(nString){
		Length = strlen(nString) + 1;
		if(Length == 0){
			String = NULL_STRING;
			return;
		}
		String = new char [Length];
		String[0] = '\0';
		Allocate = true;
		Copy(nString);
	}
}

void cString::Create(cString &A){
	Create((const char*)A);
}

void cString::Destroy(){
	if(Allocate){
		delete [] String;
	}
	String = NULL_STRING;
	Length = 0;
	Allocate = false;
}

///////////////////////////////////////////
char *cString::Get(){
	return String;
}

/////////////////////////////// String as an Array
long cString::GetLength(){
	return strlen(String);
}
char cString::Get(long i){
	return String[i];
}
void cString::Set(long i, int c){
	String[i] = c;
}

//////////////////////////////// Block Operation
void cString::Copy(const char *nString){
	strncpy(String, nString, Length);
}
void cString::Copy(cString &A){
	strncpy(String, A.String, min(Length, A.Length + 1));
}
void cString::CopyAt(const char *nString, int p, int n){
	strncpy(String + p, nString, n);
}
void cString::CopyAt(cString &A, int p, int n){
	strncpy(String + p, A.String, n);
}
/////////////////////////////// Expression
void cString::operator=(const char *nString){
	Create(nString);
}
void cString::operator=(cString &A){
	Create(A);
}
cString cString::operator+(cString &A){
	cString t;
	t.Create(Length + A.Length);
	t.Copy(*this);
	t.CopyAt(A, Length, A.Length);
	return t;
}
cString cString::operator+(const char *A){
	long len = strlen(A);
	cString t;
	t.Create(Length + len);
	t.Copy(*this);
	t.CopyAt(A, Length, len);
	return t;
}
cString operator+(const char *s, cString &A){
	long len = strlen(s);
	cString t;
	t.Create(A.Length + len);
	t.Copy(s);
	t.CopyAt(A, len, A.Length);
	return t;
}

void cString::operator+=(const char *a){
	long len = strlen(a);
	cString t;

	t = *this;
	Create(Length + len);
	Copy(t);
	CopyAt(a, t.Length, len);
}

void cString::operator+=(cString &A){
	cString t;

	t = *this;
	Create(Length + A.Length);
	Copy(t);
	CopyAt(A, t.Length, A.Length);
}
/////////////////////////////////////// Extraction
cString cString::Middle(long p, long n){
	cString t(n + 1);
	strncpy(t.String, String + p, n);
	t.String[n] = '\0';
	return t;

}
cString cString::Left(long n){
	cString t(n + 1);
	strncpy(t.String, String, n);
	t.String[n] = '\0';
	return t;
}
cString cString::Right(long n){
	cString t(n + 1);
	strncpy(t.String, String + Length - n, n);
	t.String[n] = '\0';
	return t;
}

//////////////////////////////// Comparison
int cString::Compare(const char *nString, bool Case){
//	long len = strlen(nString) + 1;
//	if(Length < len) return -1;
//	if(Length > len) return 1;
	if(Case)
		return strcmp(String, nString);
	return strcmpi(String, nString);

}
int cString::Compare(cString &A, bool Case){
	return Compare(A.String, Case);
}
bool cString::operator==(const char *nString){
	if(Compare(nString) == 0) return true;
	return false;
}
bool cString::operator==(cString &A){
	if(Compare(A) == 0) return true;
	return false;
}

bool cString::operator<(cString& a){
	return Compare(a) < 0;
}

bool cString::operator>(cString& a){
	return Compare(a) > 0;
}

bool cString::operator<=(cString& a){
	return Compare(a) <= 0;
}

bool cString::operator>=(cString& a){
	return Compare(a) >= 0;
}


////////////////////////////////////// Conversion
void cString::ToLower(){
	strlwr(String);
}
void cString::ToUpper(){
	strupr(String);
}

void cString::BinaryFromInt(int n){
	DWORD Mask;
	int i;

	Create(33);
	
	for(i = 31; i >= 0; i --){
		Mask = 1;
		Mask <<= i;
		if(Mask & n){
			Set(31 - i, '1');
		}else{
			Set(31 - i, '0');
		}
	}
	Set(32, 0);


}

int cString::BinaryToInt(){
	int n;
	int i;

	n = 0;
	for(i = GetLength(); i >= 0; i --){
		if(Get(i) == '1'){
			n = n + Power(2, i);
		}
	}

	return 0;
}

//////////////////////////////////// Searching
long cString::Find(int c, long p){
	char *ptr;
	ptr = strchr(String + p, c);
	if(ptr) return ptr - String;
	return -1;
}

long cString::Find(const char *s, long p){
	char *ptr;
	ptr = strstr(String + p, s);
	if(ptr) return ptr - String;
	return -1;
}

long cString::Find(cString &A, long p){
	char *ptr;

	ptr = strstr(String + p, A.String);
	if(ptr) return ptr - String;
	return -1;
}

int cString::Format(const char * Format, ...){
	va_list vaList;
	int rv;

	va_start(vaList, Format);

	Destroy();
	rv = vsprintf(Buffer, Format, vaList);

	Create(Buffer);

	va_end(vaList);
	return rv;
}

int cString::Formatv(const char* Format, va_list pArg){
	int rv;

	rv = vsprintf(Buffer, Format, pArg);
	Destroy();
	Create(Buffer);
	return rv;
}

int cString::Scan(const char * Format, ...){
/*	va_list vaList;
	int rv;

	va_start(vaList, Format);

	Destroy();
	rv = vsscanf(Buffer, Format, vaList);

	va_end(vaList);
	return rv;
	*/
	return 0;
}

// Recorder //////////////////////////////////////////
bool cString::Load(cMedium *pMedium){
	int _Length;

	Destroy();
	pMedium->Read(&_Length, sizeof(_Length));
	if(_Length){
		Create(_Length + 1);
		pMedium->Read(String, sizeof(char), _Length);
		String[_Length] = 0;
	}else{
		String = NULL_STRING;
	}
	return true;
}

bool cString::Save(cMedium *pMedium){
	pMedium->Write(&Length, sizeof(Length));
	if(Length){
		pMedium->Write(String, sizeof(char), Length);
	}
	return true;
}

