/*
	cString

	A cString object consists of a variable-length of characters.
*/
#ifndef cString_H
#define cString_H

#include "cRecorder.h"

class cString : public cRecorder{
protected:
	char *String;
	long Length; // Length of the String including NULL
	bool Allocate;

public:
	// Construction
	cString();
	cString(long nLength);
	cString(const char *nString);
	cString(cString &A);
	~cString();

	void Create(long nSize);
	void Create(const char *String);
	void Create(cString &A);

	void Destroy();

	// Buffer Access
	char *Get();

	// The String as an Array
	long GetLength();
	char Get(long i);
	void Set(long i, int c);

	// Block Operation
	void Copy(const char *nString);
	void Copy(cString &A);
	void CopyAt(const char *nString, int p, int n);
	void CopyAt(cString &A, int p, int n);

	// Expression
	void operator=(const char *String);
	void operator=(cString &A);
	cString operator+(const char *A);
	cString operator+(cString &A);
	friend cString operator+(const char *s, cString &A);
	void operator+=(const char *a);
	void operator+=(cString &A);

	// Extraction
	cString Middle(long p, long n);
	cString Left(long n);
	cString Right(long n);

	// Comparison
	int Compare(const char *nString, bool Case = true);
	int Compare(cString &A, bool Case = true);
	bool operator==(const char *nString);
	bool operator==(cString &A);
	bool operator<(cString& a);
	bool operator>(cString& a);
	bool operator<=(cString& a);
	bool operator>=(cString& a);

	// Conversion
	void ToLower();
	void ToUpper();

	void BinaryFromInt(int n);
	int BinaryToInt();

	// Searching
	long Find(int c, long p = 0);
	long Find(const char *String, long p = 0);
	long Find(cString &String, long p = 0);

	int Format(const char * Format, ...);
	int Formatv(const char * Format, va_list pArg);
	int Scan(const char * Format, ...);


	// Recorder
	virtual bool Load(cMedium *pMedium);
	virtual bool Save(cMedium *pMedium);

		

	operator LPCTSTR(){ return String; }
};

cString operator+(char *s, cString &A);

extern char* NULL_STRING;

#endif
