#include "TOOL.h"

#include "cStringArray.h"
#include <algorithm>


cStringArray::cStringArray(){
	Strings = NULL;
	Indices = NULL;
}

cStringArray::~cStringArray(){
	Destroy();
}

BOOL cStringArray::Create(int _charCount, int _LineCount){
	int i;

	charCount = _charCount;
	LineCount = _LineCount;

	if(charCount < 2) charCount = 3;

	// ڿ ͸ غ
	Strings = new char *[LineCount];
	if(!Strings) return false;
	ZeroMemory(Strings, sizeof(char *) * LineCount);

	for(i = 0; i < LineCount; i ++){
		Strings[i] = new char [charCount + 1];
		if(!Strings[i]){
			Destroy();
			return false;
		}
		ZeroMemory(Strings[i], sizeof(char) * charCount + 1);
	}
	// Ʈ ȯ  ϱ  ̺ غѴ.
	Indices = new char *[LineCount];
	if(!Indices){
		Destroy();
		return false;
	}
	for(i = 0; i < LineCount; i ++){
		Indices[i] = Strings[i];
	}
	return true;
}

void cStringArray::Destroy(){
	int i;
	if(Strings){
		for(i = 0; i < LineCount; i ++)
			if(Strings[i]) delete Strings[i];
		delete Strings;
		Strings = NULL;
	}
	if(Indices){
		delete Indices;
		Indices = NULL;
	}
}

BOOL cStringArray::AddString(char *String, int Index){
// printf  ڿ  Ѵ.
	int x, y, i, Len;

	if(Index < 0 || Index > LineCount) Index = LineCount - 1;
//	if(Index > 0) ScrollUp(0, Index);
	x = strlen(Indices[Index]);
	y = Index;
	Len = strlen(String);
	for(i = 0; i < Len && String[i]; i ++){
		if((BYTE)String[i] & 0x80){ // ڰ ѱ 
			if(x < charCount - 1){ //  ϱ⿡    
				(Indices[y])[x] = String[i];
				x ++; i ++;
				(Indices[y])[x] = String[i];
				x ++;
			}else{
				x = charCount;
				i --;
			}
		}else{
			switch(String[i]){
			case '\n':
				(Indices[y])[x] = '\0';
				x = charCount;
				break;
			default:
				(Indices[y])[x] = String[i];
				x ++; 
				break;
			}
		}
		if(x >= charCount){
			(Indices[y])[x] = '\0';
			x = 0;
			y ++;
			if(y >= LineCount){
				y = LineCount - 1;
				ScrollUp(0, y);
			}
		}
	}
	(Indices[y])[x] = '\0';
	return true;
}

char *cStringArray::GetString(int Index){
	if(Index < 0 || Index >= LineCount) return NULL;
	return Indices[Index];
}


void cStringArray::ScrollUp(int BeginLine, int EndLine){
// ڿ 迭   ũ Ѵ.
//  ܳ  ִ.
//  óӵ 븦  ε 迭 Ѵ.
	int i;
	char *tmp;

	if(!Strings) return;
	if(BeginLine < 0) BeginLine = 0;
	if(EndLine < 0) EndLine = LineCount - 1;
	if(BeginLine > EndLine) std::swap<int>(BeginLine, EndLine);
	if(BeginLine < 0) BeginLine = 0;
	if(EndLine >= LineCount) EndLine = LineCount - 1;
	(Indices[BeginLine])[0] = '\0';
	tmp = Indices[BeginLine];
	for(i = 0; i < EndLine; i ++){
		Indices[i] = Indices[i + 1];
	}
	Indices[EndLine] = tmp;
}

BOOL cStringArray::Printf(char *Format, ...){
	char buff[512];
	va_list vaList;

	va_start(vaList, Format);

	if(vsprintf(buff, Format, vaList) <= 0)
		return false;
	AddString(buff);
	return true;
}

BOOL cStringArray::Printfv(char *format, va_list VaList){
	char buff[512];

	if(vsprintf(buff, format, VaList) <= 0)
		return false;
	AddString(buff);
	return true;
}
