#include "TOOL.h"
#include "cTileMap.h"

#include "TOOLUtils.h"

cTileMap::cTileMap(){

}

cTileMap::~cTileMap(){

}

bool cTileMap::Create(int Width, int Height){
	if(!cSpotArray::Create(Height, Width))
		return false;
	return true;
}

bool cTileMap::Resize(int _Width, int _Height){
	cSpotArray TempArr;
	int OldWidth, OldHeight;

	OldWidth = Width;
	OldHeight = Height;

	if(_Width <= 0 || _Width > 1024 || _Height <= 0 || _Height > 1024)
		return false;

	TempArr.Create(Height, Width);
	TempArr = *this;
	
	cSpotArray::Destroy();
	if(!cSpotArray::Create(_Height, _Width))
		return false;

	Copy(0, 0, &TempArr, 0, 0, Min(OldHeight, Height), Min(OldWidth, Width));
	TempArr.Destroy();

	return true;
}

void cTileMap::Destroy(){
	cSpotArray::Destroy();
}



bool cTileMap::ShowMap(cPicture* pDestPic, int Left, int Top, LPRECT pSrcRect, bool UnderTile){
//  ǥ ȼ ǥ̴.
// pDestPic Left, Top ġ  pSrcRect κ ׷.
	cRect SrcRect;
	int xBegin, xEnd;
	int yBegin, yEnd;
	int xSrc, ySrc, xAdj;
	int xDest, yDest;
	int TileWidth, TileHeight;

	bool bClearBack = false;
	cPicture* pTilePic;

	if(pTileSet->GetTileCount() <= 0)
		return false;

	TileWidth = pTileSet->GetTileWidth();
	TileHeight = pTileSet->GetTileHeight();

	SrcRect = *pSrcRect;

	// 1.  簢  ׸ Ѿ 츦 ó
	if(SrcRect.left < 0){
		Left -= SrcRect.left;
		SrcRect.left = 0;
		bClearBack = true;
	}
	if(Left < 0){
		SrcRect.left -= Left;
		Left = 0;
	}
	xBegin = SrcRect.left / TileWidth;
	if(SrcRect.top < 0){
		Top -= SrcRect.top;
		SrcRect.top = 0;
		bClearBack = true;
	}
	if(Top < 0){
		SrcRect.top -= Top;
		Top = 0;
	}
	yBegin = SrcRect.top / TileHeight;
	if(SrcRect.right >= Width * TileWidth){
		SrcRect.right = Width * TileWidth - 1;
		bClearBack = true;
	}
	xEnd = SrcRect.right / TileWidth;
	if(SrcRect.bottom >= Height * TileHeight){
		SrcRect.bottom = Height * TileHeight - 1;
		bClearBack = true;
	}
	yEnd = SrcRect.bottom / TileHeight;

	xAdj = - (SrcRect.left % TileWidth);

	ySrc = yBegin;
	yDest = Top - (SrcRect.top % TileHeight);

	if(UnderTile){
		if(bClearBack)
			pDestPic->ClearRect();

		while(ySrc <= yEnd){
			xSrc = xBegin;
			xDest = Left + xAdj;
			while(xSrc <= xEnd){
				pTilePic = &GetTile(cSpotArray::Get(ySrc, xSrc).TileNo)->UnderPicture;
				if(pTilePic){
					if(!pDestPic->BltFast(xDest, yDest, pTilePic))
						assert(false);
				}
				xSrc ++;
				xDest += TileWidth;
			}
			ySrc ++;
			yDest += TileHeight;
		}
	}else{ // OverTile
/*	
		while(ySrc <= yEnd){
			xSrc = xBegin;
			xDest = Left + xAdj;
			while(xSrc <= xEnd){
				pTilePic = &GetTile(cSpotArray::Get(ySrc, xSrc).TileNo)->OverPicture;
				if(!pDestPic->BltFast(xDest, yDest, pTilePic, 0, DDBLTFAST_SRCCOLORKEY | DDBLTFAST_WAIT))
					assert(false);
				xSrc ++;
				xDest += TileWidth;
			}
			ySrc ++;
			yDest += TileHeight;
		}*/
	}

	return true;
}

cTile *cTileMap::GetTile(int y, int x){
	return pTileSet->GetTile(cSpotArray::Get(y, x).TileNo); 
}

cTile *cTileMap::GetTile(int n){ 
	return pTileSet->GetTile(n); 
}

void cTileMap::SetTile(int y, int x, int Tile){ 
	cSpotArray::Get(y, x).TileNo = Tile; 
}

bool cTileMap::GetSpot(int y, int x, cSpot *pSpot){
	if(0 <= y && y < Height && 0 <= x && x < Width){
		*pSpot = cSpotArray::Get(y, x);
		return true;
	}
	return false;
}


// Drawing Map
void cTileMap::Rectangle(int Left, int Top, int Right, int Bottom, int Tile){
	int y, x;

	if(Left < 0) Left = 0;
	if(Top < 0) Top = 0;
	if(Right > Width) Right = Width;
	if(Bottom > Height) Bottom = Height;
	
	for(y = Top; y < Bottom; y ++){
		for(x = Left; x < Right; x ++){
			SetTile(y, x, Tile);
		}
	}
}

void cTileMap::HorzLine(int Left, int Top, int Right, int Tile){
	int x;

	if(Left < 0) Left = 0;
	if(Top < 0) Top = 0;
	if(Right > Width) Right = Width;

	for(x = Left; x < Right; x ++)
		SetTile(Top, x, Tile);
}

void cTileMap::VertLine(int Left, int Top, int Bottom, int Tile){
	int y;

	if(Left < 0) Left = 0;
	if(Top < 0) Top = 0;
	if(Bottom > Height) Bottom = Height;

	for(y = Top; y < Bottom; y ++)
		SetTile(y, Left, Tile);
}


bool cTileMap::LoadTile(LPCTSTR TileFileName){
	cMedium Medium;

	Medium.SetFileName(TileFileName);
	if(!Medium.Open(cMedium::OM_READ))
		return false;
	if(!pTileSet->Load(&Medium)){
		assert(!"Unable to load TileSet file.");
		return false;
	}
	Medium.Close();
	return true;
}


void cTileMap::ReleaseTile(){
	pTileSet->Destroy();
}


void cTileMap::SetTileSet(cTileSet *_pTileSet){
	pTileSet = _pTileSet;
}

cTileSet *cTileMap::GetTileSet(){
	return pTileSet;

}

class cTileMapFileHeader{
public:
	WORD Width;
	WORD Height;
};

bool cTileMap::Load(cMedium *pMedium){
	cTileMapFileHeader Header;

	pMedium->Read(&Header, sizeof(cTileMapFileHeader));
	if(!Create(Header.Width, Header.Height))
		return false;
	pMedium->Read(Elements, sizeof(cSpot), Width * Height);
	return true;
}

bool cTileMap::Save(cMedium *pMedium){
	cTileMapFileHeader Header;

	Header.Width = (WORD)Width;
	Header.Height = (WORD)Height;

	pMedium->Write(&Header, sizeof(cTileMapFileHeader));
	pMedium->Write(Elements, sizeof(cSpot), Width * Height);
	return true;
}

