#include "TOOL.h"
#include "cTileSet.h"

cTileSet::cTileSet(){
	TileCount = 0;

}

cTileSet::~cTileSet(){

}

bool cTileSet::Create(int _TileWidth, int _TileHeight){
	TileCount = 0;
	Tiles = 0;
	
	TileWidth = _TileWidth;
	TileHeight = _TileHeight;
	return true;
}

/*
bool cTileSet::CreateFromScript(LPCTSTR FileName){
	char pBuffer[1024];
	char pToken[256];// pToken2[256];
	int Index, Number;
	FILE* pFile;
	char* pChar;
	char PictureFileName[256];

	pFile = fopen(FileName, "rt");
	if(!pFile)
		return false;

	TileWidth = 32;
	TileHeight = 32;

	do{
		pBuffer[0] = 0;
		if(!fgets(pBuffer, 1024, pFile))
			break;

		// ɾ ´.
		if(sscanf(pBuffer, "%[A-Za-z?]", &pToken) != 1)
			continue;

		switch(pToken[0]){
		case '?': // ּ  Ѿ
			break;
		default: //  
			// ǥ Space ȯ
			pChar = pBuffer;
			while(*pChar){
				if(*pChar == '\"'){
					*pChar = ' ';
				}
				pChar ++;
			}

			if(strcmpi(pToken, "PictureCount") == 0){
				sscanf(pBuffer, "PictureCount = %d", &Number);
				PictureBookCount = Number;
				if(!PictureBook.Create(PictureBookCount)){
					fclose(pFile);
					return false;
				}
			}else if(strcmpi(pToken, "Picture") == 0){
				if(sscanf(pBuffer, "Picture[%d] = %s", &Index, pToken) == 2){
					strcpy(PictureFileName, "");//Picture\\Map\\");
					strcat(PictureFileName, pToken);
					if(!PictureBook.LoadPicture(Index, PictureFileName)){
						fclose(pFile);
						assert(!"Under Picture File is not found.");
						return false;
					}
				}else{
					fclose(pFile);
					return false;
				}

			}else{ // ǵ  ɾ
				assert(!"Undefined Tile Desc Command");
				fclose(pFile);
				return false;
			}
		}

	} while(*pBuffer);

	fclose(pFile);

	if(PictureBook.GetCount() <= 0)
		return false;

	

	

	return true;
}

*/

void cTileSet::Destroy(){
	PictureBook.Destroy();
//	OverPictureBook.Destroy();
	DestroyTileIndex();
}

int cTileSet::GenerateTileIndex(){
	// ׸ ε  .
	cPicture *pPicture;
	int i, idx;
	int y, x;

	// Ÿ   .
	TileCount = 0;
	for(i = 0; i < PictureBook.GetCount(); i ++){
		pPicture = PictureBook.GetPicture(i);
		TileCount += pPicture->GetWidth() / TileWidth * pPicture->GetHeight() / TileHeight;
	}

	Tiles = new cTile[TileCount];
	idx = 0;

	// Ÿ ε .
	for(i = 0; i < PictureBook.GetCount(); i ++){
		pPicture = PictureBook.GetPicture(i);
		for(y = 0; y <= pPicture->GetHeight() - TileHeight; y += TileHeight){
			for(x = 0; x <= pPicture->GetWidth() - TileWidth; x += TileWidth){
				Tiles[idx].UnderPicture.CreateReference(
					pPicture, x, y, x + TileWidth, y + TileHeight);

				idx ++;
			}
		}
	}
	return idx;
}

void cTileSet::DestroyTileIndex(){
	delete [] Tiles;
	Tiles = 0;
}

int cTileSet::GetTileWidth(){
	return TileWidth;
}

int cTileSet::GetTileHeight(){
	return TileHeight;
}

bool cTileSet::InsertBitmap(LPCTSTR FileName, int PrevIndex){
	// ϴ Ʈ  Ǿ ġ ãƳ.
	int Index;

	Index = PictureBook.InsertNullPicture(PrevIndex);
	if(!PictureBook.GetPicture(Index)->Create(FileName))
		return false;

	// Ÿ ε Ѵ.
	UpdateTileIndex();

	return true;
}

void cTileSet::DeleteBitmap(int Index){
	PictureBook.DeletePicture(Index);
	UpdateTileIndex();
}

cPictureBook *cTileSet::GetPictureBook(){
	return &PictureBook;
}


class cTileSetFileHeader{
public:
	short TileWidth;
	short TileHeight;
	short BitmapCount;
	short TileCount;
};

class cTileSetFileBitmapData{
public:
	char FileName[256];
};

class cTileSetFileTileData{
public:
	int Height;
	int Prop;
};


bool cTileSet::Load(cMedium *pMedium){
	cTileSetFileHeader Header;
	cTileSetFileBitmapData BitmapData;
	cTileSetFileTileData TileData;
	int i;
	char PathName[256];
	char BitmapFileName[256];

	pMedium->Read(&Header, sizeof(cTileSetFileHeader));
	
	TileWidth = Header.TileWidth;
	TileHeight = Header.TileHeight;

	// Ʈ ε
	if(!PictureBook.Create(Header.BitmapCount))
		return false;

	strcpy(PathName, pMedium->GetFileName());
	// н ϰ  
	for(i = strlen(PathName) - 1; i > 0 && PathName[i] != '\\'; i --){
		PathName[i] = '\0';
	}
	for(i = 0; i < Header.BitmapCount; i ++){
		pMedium->Read(&BitmapData, sizeof(cTileSetFileBitmapData));
		
		strcpy(BitmapFileName, PathName);
		strcat(BitmapFileName, BitmapData.FileName);

		if(!PictureBook.GetPicture(i)->Create(BitmapFileName))
			return false;
	}

	// Ÿ  ε
	UpdateTileIndex();
	for(i = 0; i < TileCount; i ++){
		pMedium->Read(&TileData, sizeof(cTileSetFileTileData));
		Tiles[i].Height = TileData.Height;
		Tiles[i].Prop = TileData.Prop;
	}

	return true;
}

bool cTileSet::Save(cMedium *pMedium){
	cTileSetFileHeader Header;
	cTileSetFileBitmapData BitmapData;
	cTileSetFileTileData TileData;
	int i;

	Header.TileWidth = TileWidth;
	Header.TileHeight = TileHeight;
	Header.BitmapCount = PictureBook.GetCount();
	Header.TileCount = TileCount;
	pMedium->Write(&Header, sizeof(cTileSetFileHeader));
	
	// Ʈ  
	for(i = 0; i < PictureBook.GetCount(); i ++){
		strcpy(BitmapData.FileName, *PictureBook.Get(i)->GetFileName());
		pMedium->Write(&BitmapData, sizeof(cTileSetFileBitmapData));
	}

	// Ÿ  ε
	for(i = 0; i < TileCount; i ++){
		TileData.Height = Tiles[i].Height;
		TileData.Prop = Tiles[i].Prop;

		pMedium->Write(&TileData, sizeof(cTileSetFileTileData));
	}

	return true;

}

void cTileSet::UpdateTileIndex(){
	if(Tiles)
		DestroyTileIndex();
	GenerateTileIndex();
}
