#ifndef cTileSet_H
#define cTileSet_H

#include "cPictureBook.h"
#include "cTile.h"
#include "cRecorder.h"

class cTileSet : public cRecorder{
private:
	cPictureBook PictureBook;

	int TileCount;
	cTile *Tiles;

	int TileWidth;
	int TileHeight;

	int GenerateTileIndex();
	void DestroyTileIndex();

public:
	cTileSet();
	virtual ~cTileSet();

//	bool CreateFromScript(LPCTSTR FileName);
	bool Create(int _TileWidth = 32, int _TileHeight = 32);
	void Destroy();

	// Editing
	bool InsertBitmap(LPCTSTR FileName, int Index);
	void DeleteBitmap(int Index);

	cPictureBook *GetPictureBook();

	int GetTileCount(){ return TileCount; }
	cTile *GetTile(int n){ return &Tiles[n]; }

	int GetTileWidth();
	int GetTileHeight();

	bool Load(cMedium *pMedium);
	bool Save(cMedium *pMedium);

	void UpdateTileIndex();


};

#endif
