#include "TOOL.h"
#include "cVector3D.h"

template <class Type> cVector3D<Type>::cVector3D(){
	x = 0;
	y = 0;
	z = 0;
}

template <class Type> cVector3D<Type>::~cVector3D(){

}

template <class Type> cVector3D<Type>::operator Type(){
	return Type(sqrt(double(x * x + y * y + z * z)));
}

template <class Type> Type cVector3D<Type>::GetLength(){
	return Type(sqrt(double(x * x + y * y + z * z)));
}

template <class Type> double cVector3D<Type>::GetXYAngle(){
// ǥ࿡   ȯ
	double Angle;
	Angle = acos(double(x) / double(GetLength()));
	if(y >= 0) return Angle;
	return (3.1416 * 2) - Angle;
}

template <class Type> void CrossProduct(const cVector3D<Type> &a, const cVector3D<Type> &b){
	x = a.y * b.z - a.z * b.y;
	y = a.z * b.x - a.x * b.z;
	z = a.x * b.y - a.y * b.x;
}

template <class Type> cVector3D<Type> CrossProduct(const cVector3D<Type> &a){
	cVector3D<Type> r;
	r.x = y * a.z - z * a.y;
	r.y = z * a.x - x * a.z;
	r.z = x * a.y - y * a.x;
}

template <class Type> Type cVector3D<Type>::GetDistance(cVector3D<Type> a){
	cVector3D<Type> r;

	r = *this - a;
	return r.GetLength();
}

template <class Type> int cVector3D<Type>::GetxyDirection8(){
	static int Directions[3][3] = {
		{ 7, 0, 1 },
		{ 6, 0, 2 },
		{ 5, 4, 3 }
	};

	int xIdx, yIdx;
	Type Len;

	Len = (Type)(sqrt((double)((x * x) + (y * y))) * 20);
	if(Len == 0)
		return 0;
	xIdx = (int)(x * 39 / Len);
	yIdx = (int)(y * 39 / Len);

	return Directions[yIdx + 1][xIdx + 1];
}


template <class Type> void cVector3D<Type>::XRotate(Type Angle){
	// { x2 } = { cos(r) -sin(r) } * { x }
	// { y2 } = { sin(r)  cos(r) }   { y }
	Type yOld, zOld;

	yOld = y;
	zOld = z;

	x = (Type)(yOld * cos(Angle) - zOld * sin(Angle));
	z = (Type)(yOld * sin(Angle) + zOld * cos(Angle));
}

template <class Type> void cVector3D<Type>::YRotate(Type Angle){
	// { x2 } = { cos(r) -sin(r) } * { x }
	// { y2 } = { sin(r)  cos(r) }   { y }
	Type xOld, zOld;

	xOld = x;
	zOld = z;

	x = (Type)(xOld * cos(Angle) - zOld * sin(Angle));
	z = (Type)(xOld * sin(Angle) + zOld * cos(Angle));
}

template <class Type> void cVector3D<Type>::ZRotate(Type Angle){
	// { x2 } = { cos(r) -sin(r) } * { x }
	// { y2 } = { sin(r)  cos(r) }   { y }
	Type xOld, yOld;

	xOld = x;
	yOld = y;

	x = (Type)(xOld * cos(Angle) - yOld * sin(Angle));
	y = (Type)(xOld * sin(Angle) + yOld * cos(Angle));
}

