/*
	template class cVector3D

*/

#ifndef cVector3D_H
#define cVector3D_H

template<class Type> 
class cVector3D{
public:
	Type x, y, z;

	cVector3D();
	cVector3D(const cVector3D &a){ x = a.x; y = a.y; z = a.z; }
	cVector3D(Type _x, Type _y, Type _z){ x = _x; y = _y; z = _z; }
	~cVector3D();


	void Set(Type _x, Type _y, Type _z){ x = _x; y = _y; z = _z; }
	void Reset(){ x = 0; y = 0; z = 0; }

	Type GetX(){ return x; }
	Type GetY(){ return y; }
	Type GetZ(){ return z; }

	void SetX(Type _x){ x = _x; }
	void SetY(Type _y){ y = _y; }
	void SetZ(Type _z){ z = _z; }

	int GetxyDirection8();

	void XRotate(Type Angle);
	void YRotate(Type Angle);
	void ZRotate(Type Angle);

//	cVector3D &operator=(cVector3D &a){ x = a.x; y = a.y; z = a.z; return *this; }
	// Vector operations
	cVector3D &operator =(const cVector3D &a){ x = a.x; y = a.y; z = a.z; return *this; }
	void operator +=(const cVector3D &a){ x += a.x; y += a.y; z += a.z; }
	void operator -=(const cVector3D &a){ x -= a.x; y -= a.y; z -= a.z; }
	void operator *=(const cVector3D &a){ x *= a.x; y *= a.y; z *= a.z; }

	// Scala Operations
	void operator *=(Type s){ x *= s; y *= s; z *= s; }
	void operator /=(Type s){ x /= s; y /= s; z /= s; }
	void operator +=(Type s){ x += s; y += s; z += s; }
	void operator -=(Type s){ x -= s; y -= s; z -= s; }
	
	inline operator Type();
	inline Type GetLength();
	double GetXYAngle();

	cVector3D operator-(){ return cVector3D(-x, -y, -z); }
	Type GetDistance(cVector3D a);

	Type DotProduct(){ return x * x + y * y + z * z; }
	Type DotProduct(const cVector3D &a){ return x * a.x + y * a.y + z * a.z; }

	void CrossProduct(const cVector3D &a, const cVector3D &b);
	cVector3D CrossProduct(const cVector3D &a);

/*

	// Compare
	friend BOOL operator==(const cVector3D &a, const cVector3D &b){ 
		if(a.x == b.x && a.y == b.y && a.z == b.z) return true; return false; } 
	friend BOOL operator!=(const cVector3D &a, const cVector3D &b){ 
		if(a.x != b.x || a.y != b.y || a.z != b.z) return true; return false; }
	friend BOOL operator<(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() < b.GetLength()) return true; return false; }
	friend BOOL operator<=(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() <= b.GetLength()) return true; return false; }
	friend BOOL operator>(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() > b.GetLength()) return true; return false; }
	friend BOOL operator>=(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() >= b.GetLength()) return true; return false; }
	*/
	friend cVector3D operator+(const cVector3D &a, const cVector3D &b){
		return cVector3D(a.x + b.x, a.y + b.y, a.z + b.z); }
	friend cVector3D operator-(const cVector3D &a, const cVector3D &b){
		return cVector3D(a.x - b.x, a.y - b.y, a.z - b.z); }
	friend cVector3D operator*(const cVector3D &a, Type s){
		cVector3D r;
		r = a; r *= s; return r;
	}
	friend cVector3D operator/(const cVector3D &a, Type s){
		cVector3D r;
		r = a; r /= s; return r;
	}
};

typedef cVector3D<int> cVector3Di;
typedef cVector3D<float> cVector3Df;


#endif
