#include "TOOL.h"
#include "cWindow.h"

//   ʱȭ Ѵ.
cWindow *cWindow::pThisObject = 0;
HINSTANCE cWindow::hInstance = 0;

cWindow::cWindow(){
	hWnd = 0;
}

cWindow::~cWindow(){
	Destroy();
}

//////////////////////////////////////////////////////////////////////
// Window Creation
//////////////////////////////////////////////////////////////////////

bool cWindow::RegisterClass(char *ClassName, DWORD Style, HICON hIcon, HCURSOR hCursor, HBRUSH hbrBackground, LPCTSTR lpszMenuName){
	WNDCLASSEX wc;

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = Style;
	wc.lpfnWndProc = DefaultProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = hIcon;
	wc.hCursor = hCursor;
	wc.hbrBackground = hbrBackground;
	wc.lpszMenuName = lpszMenuName;
	wc.lpszClassName = ClassName;
    wc.hIconSm = hIcon;

	return RegisterClassEx(&wc) != 0;
}

//////////////////////////////////////////////////////////////////////
// Window Creation
//////////////////////////////////////////////////////////////////////

bool cWindow::Create(DWORD dwExStyle, LPCTSTR lpWindowName, 
	DWORD dwStyle, int x, int y, int nWidth, int nHeight, 
	cWindow *pParent, HMENU hMenu){
	RECT rcClient;

	pThisObject = this;

	SetRect(&rcClient, 0, 0, nWidth, nHeight);
	AdjustWindowRectEx(&rcClient, dwStyle, 
		(!(dwStyle & WS_CHILD)) && (hMenu != 0),  dwExStyle);

	hWnd = ::CreateWindowEx(
		dwExStyle, GetClassName(), lpWindowName, 
		dwStyle, 
		x, y,
		rcClient.right - rcClient.left,
		rcClient.bottom - rcClient.top, 
		*pParent, hMenu, hInstance, 0);

	return hWnd != 0;
}

void cWindow::Destroy(){
	if(hWnd){
		::DestroyWindow(hWnd);
		hWnd = 0;
	}
}
//////////////////////////////////////////////////////////////////////
// Window Procedure
//////////////////////////////////////////////////////////////////////

LRESULT cWindow::DefProc(UINT msg, WPARAM w, LPARAM l){
	switch(msg){
	case WM_DESTROY:
		hWnd = 0;
		break;
	}
	return ::DefWindowProc(hWnd, msg, w, l); 
}

LRESULT CALLBACK cWindow::DefaultProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
// *   Լ̹Ƿ     ִ.
//  ڵ óϴ cWindowü ã WindowProc ȣ ش.
	cWindow *pObj;
	
	pObj = (cWindow *)::GetWindowLong(hWnd, GWL_USERDATA);
	if(pObj == 0){ // ü ó  Ǿ 
		SetWindowLong(hWnd, GWL_USERDATA, (LONG)pThisObject);
		pObj = pThisObject;
		pObj->hWnd = hWnd;
	}
	return pObj->Proc(uMsg, wParam, lParam);
}


void cWindow::OnHScroll(WPARAM wParam, LPARAM lParam){
	SCROLLINFO si;

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE | SIF_TRACKPOS;

	GetScrollInfo(SB_HORZ, &si);

	switch(LOWORD(wParam)){
	case SB_ENDSCROLL:
		break;
	case SB_LEFT:
		si.nPos = si.nMin;
		break;
	case SB_RIGHT:
		si.nPos = si.nMax;
		break;
	case SB_LINELEFT:
		si.nPos --;
		break;
	case SB_LINERIGHT:
		si.nPos ++;
		break;
	case SB_PAGELEFT:
		si.nPos -= si.nPage;
		break;
	case SB_PAGERIGHT:
		si.nPos += si.nPage;
		break;
	case SB_THUMBPOSITION:
		si.nTrackPos = HIWORD(wParam);
		break;
	case SB_THUMBTRACK :
		si.nTrackPos = HIWORD(wParam);
		si.nPos = HIWORD(wParam);
		break;
	}
	SetScrollInfo(SB_HORZ, &si);

	Invalidate();
}

void cWindow::OnVScroll(WPARAM wParam, LPARAM lParam){
	SCROLLINFO si;

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE | SIF_TRACKPOS;

	GetScrollInfo(SB_VERT, &si);

	switch(LOWORD(wParam)){
	case SB_ENDSCROLL:
		break;
	case SB_LEFT:
		si.nPos = si.nMin;
		break;
	case SB_RIGHT:
		si.nPos = si.nMax;
		break;
	case SB_LINELEFT:
		si.nPos --;
		break;
	case SB_LINERIGHT:
		si.nPos ++;
		break;
	case SB_PAGELEFT:
		si.nPos -= si.nPage;
		break;
	case SB_PAGERIGHT:
		si.nPos += si.nPage;
		break;
	case SB_THUMBPOSITION:
		si.nTrackPos = HIWORD(wParam);
		break;
	case SB_THUMBTRACK :
		si.nTrackPos = HIWORD(wParam);
		si.nPos = HIWORD(wParam);
		break;
	}
	SetScrollInfo(SB_VERT, &si);

	Invalidate();
}

//////////////////////////////////////////////////////////////////////
// Window Size and Position
//////////////////////////////////////////////////////////////////////
/*
SIZE cWindow::GetNormalClientSize(){
// 찡 ּȭ Ǿ  GetClientRectδ 
//   ũ⸦   Ƿ 
// AdjustWindowRectEx Լ ̿Ѵ.
	WINDOWPLACEMENT wndpl;
	RECT rcWindow, rcRequired;
	SIZE sz;

	//   ġ ľѴ.
	wndpl.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWnd, &wndpl);
	rcWindow = wndpl.rcNormalPosition;
	rcRequired = rcWindow;
	// required  window Ŭ̾Ʈ  ʿ  ũ⸦ 
	AdjustWindowRectEx(&rcRequired, GetWindowLong(hWnd, GWL_STYLE),
		FALSE, GetWindowLong(hWnd, GWL_EXSTYLE));
	sz.cx = rcWindow.right - (rcRequired.right - rcWindow.right)
		- (rcWindow.left + rcWindow.left - rcRequired.left);
	sz.cy = rcWindow.bottom - (rcRequired.bottom - rcWindow.bottom)
		- (rcWindow.top + rcWindow.top - rcRequired.top);

	return sz;
}
*/

void cWindow::ClientToScreen(LPRECT prc){
	::ClientToScreen(hWnd, LPPOINT(prc));
	::ClientToScreen(hWnd, LPPOINT(prc) + 1);
}

void cWindow::ScreenToClient(LPRECT prc){
	::ScreenToClient(hWnd, LPPOINT(prc));
	::ScreenToClient(hWnd, LPPOINT(prc) + 1);
}

int cWindow::GetDlgItemInt(int nIDDlgItem){
	char Text[256];

	GetDlgItemText(nIDDlgItem, Text, 256);
	return atoi(Text);
}

bool cWindow::SetDlgItemInt(int nIDDlgItem, int nValue){
	char Text[256];

	sprintf(Text, "%d", nValue);
	return SetDlgItemText(nIDDlgItem, Text);
}

//////////////////////////////////////////////////////////////////////
// Static Window Operations
//////////////////////////////////////////////////////////////////////
cWindow *cWindow::GetTopLevelParent(){
	HWND hwnd;

	hwnd = hWnd;

	while(::GetParent(hwnd)) 
		hwnd = ::GetParent(hwnd);
	return GetWindow(hwnd);
}


bool TextOut(HDC hdc, int x, int y, LPCTSTR str){
	return TextOut(hdc, x, y, str, lstrlen(str)) == TRUE;
}



