/*
	 ü  ̺귯 (TOOL; Toltin' Object Oriented Library)
	cWindow Ver 1.01

	* ܺ API Ϻ ȣȯ 
		cWindow     ڵ cWindow * ȯ  .

*/

#ifndef cWindow_H
#define cWindow_H

class cWindow{ 
protected:
	static cWindow *pThisObject; //   Լ  ü 

// ø̼ νϽ ڵ
protected:
	static HINSTANCE hInstance;
	HWND hWnd; 


protected:
	//  
	static cWindow *GetWindow(HWND hWnd){ return (cWindow *)GetWindowLong(hWnd, GWL_USERDATA); }

	// Overridables
	virtual char *GetClassName(){ return 0; }
	// Do NOT call directly
	static LRESULT CALLBACK DefaultProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	static bool RegisterClass(char *ClassName, DWORD Style, HICON hIcon = 0, HCURSOR hCursor = 0, HBRUSH hbrBackground = 0, LPCTSTR lpszMenuName = 0);
	virtual LRESULT Proc(UINT uMsg, WPARAM wParam, LPARAM lParam) = 0;

	LRESULT DefProc(UINT msg, WPARAM w, LPARAM l);
	
	void OnHScroll(WPARAM wParam, LPARAM lParam);
	void OnVScroll(WPARAM wParam, LPARAM lParam);


public:

	// 
	cWindow();
	virtual ~cWindow();

	// â  
	bool Create(DWORD dwExStyle, LPCTSTR lpWindowName, 
		DWORD dwStyle, int x, int y, int nWidth, int nHeight, 
		cWindow *pParentWindow, HMENU hMenu = 0); 
	virtual void Destroy();

	//  Ӽ
	DWORD GetStyle(){ return ::GetWindowLong(hWnd, GWL_STYLE); }
	DWORD GetExStyle(){ return ::GetWindowLong(hWnd, GWL_EXSTYLE); }

	//  
	bool IsEnabled(){ return ::IsWindowEnabled(hWnd) == TRUE; }
	bool Enable(bool bEnable){ return ::EnableWindow(hWnd, bEnable) == TRUE; }
	static cWindow *GetActiveWindow(){ return GetWindow(::GetActiveWindow()); }
	cWindow *Activate(){ return GetWindow(::SetActiveWindow(hWnd)); }
	static cWindow *GetCapture(){ return GetWindow(::GetCapture()); }
	cWindow *SetCapture(){ return GetWindow(::SetCapture(hWnd)); }
	static cWindow *GetFocus(){ return GetWindow(::GetFocus()); }
	cWindow *SetFocus(){ return GetWindow(::SetFocus(hWnd)); }
	static HWND GetDesktopWindow(){ return ::GetDesktopWindow(); }
	bool GetPlacement(WINDOWPLACEMENT *lpwndpl){ return ::GetWindowPlacement(hWnd, lpwndpl) == TRUE; }
	int GetRgn(HRGN hRgn){ return ::GetWindowRgn(hWnd, hRgn); }
	int SetRgn(HRGN hRgn, bool bRedraw){ return ::SetWindowRgn(hWnd, hRgn, bRedraw); }
	bool IsIconic(){ return ::IsIconic(hWnd) == TRUE; }
	bool IsZoomed(){ return ::IsZoomed(hWnd) == TRUE; }
	bool OpenIcon(){ return ::OpenIcon(hWnd) == TRUE; }
	bool Close(){ return ::CloseWindow(hWnd) == TRUE; }
	bool Move(int x, int y, int w, int h, bool bRedraw = true){ return ::MoveWindow(hWnd, x, y, w, h, bRedraw) == TRUE; }
	bool SetPos(cWindow *Behind, int x, int y, int cx, int cy, DWORD uFlag){ return ::SetWindowPos(hWnd, Behind->hWnd, x, y, cx, cy, uFlag) == TRUE; }
//	DWORD ArrangeIconicChilds(){ return ::ArrageIconicWindows(hWnd); }
	bool BringToTop(){ return ::BringWindowToTop(hWnd) == TRUE; }
	bool GetRect(LPRECT lpRect){ return ::GetWindowRect(hWnd, lpRect) == TRUE; }
	bool GetClientRect(LPRECT lpRect){ return ::GetClientRect(hWnd, lpRect) == TRUE; }

	//   Լ
//	cWindow *ChildFromPoint(POINT pt){ return GetWindow(::ChildWindowFromPoint(hWnd, pt)); }
//	cWindow *FindWindow(LPCTSTR pClassName, LPCTSTR pWindowName){ return GetWindow(){ ::FindWindow(pClassName, pWindowName)) };
//	cWindow *GetNextWindow(
	cWindow *GetParent(){ return GetWindow(::GetParent(hWnd)); }
	cWindow *SetParent(cWindow *pParent){ return GetWindow(::SetParent(hWnd, pParent->hWnd)); }
	cWindow *GetTop(DWORD uCmd){ return GetWindow(::GetWindow(hWnd, uCmd)); }
	cWindow *GetWindow(DWORD uCmd){ return GetWindow(::GetWindow(hWnd, uCmd)); }
	cWindow *GetLastActivePopup(){ return GetWindow(::GetLastActivePopup(hWnd)); }
	bool IsChild(cWindow *pParent){ return ::IsChild(pParent->hWnd, hWnd) == TRUE; }
//	WindowFromPoint
	cWindow *GetItem(int id){ return GetWindow(::GetDlgItem(hWnd, id)); }
	int GetCtrlID(){ return ::GetDlgCtrlID(hWnd); }
	int SetCtrlID(int id){ return ::SetWindowLong(hWnd, GWL_ID, id); }
	cWindow *GetTopLevelParent();

	//  ׸
	HDC BeginPaint(LPPAINTSTRUCT pps){ return ::BeginPaint(hWnd, pps); }
	void EndPaint(LPPAINTSTRUCT pps){ ::EndPaint(hWnd, pps); }
	bool LockUpdate(){ return ::LockWindowUpdate(hWnd) == TRUE; }
	void UnlockUpdate(){ ::LockWindowUpdate(0); }
	HDC GetDC(){ return ::GetDC(hWnd); }
	HDC GetDCEx(HRGN hClipRgn, DWORD flags){ return ::GetDCEx(hWnd, hClipRgn, flags); }
	bool Redraw(CONST RECT *prcUpdate, HRGN hUpdateRgn, DWORD flags){ return ::RedrawWindow(hWnd, prcUpdate, hUpdateRgn, flags) == TRUE; }
	HDC GetWindowDC(){ return ::GetWindowDC(hWnd); }
	int ReleaseDC(HDC hdc){ return ::ReleaseDC(hWnd, hdc); }
	bool Update(){ return ::UpdateWindow(hWnd) == TRUE; }
	bool GetUpdateRect(LPRECT prc, bool bErase){ return ::GetUpdateRect(hWnd, prc, bErase) == TRUE; }
	int GetUpdateRgn(HRGN hRgn, bool bErase){ return ::GetUpdateRgn(hWnd, hRgn, bErase); }
	bool Invalidate(bool bErase = true){ return ::InvalidateRect(hWnd, 0, bErase) == TRUE; }
	bool InvalidateRect(CONST RECT *prc = 0, bool bErase = true){ return ::InvalidateRect(hWnd, prc, bErase) == TRUE; }
	bool InvalidateRgn(HRGN hRgn, bool bErase){ return ::InvalidateRgn(hWnd, hRgn, bErase) == TRUE; }
	bool ValidateRect(LPRECT lpRect = 0){ return ::ValidateRect(hWnd, lpRect) == TRUE; }
	bool ValidateRgn(HRGN hRgn){ return ::ValidateRgn(hWnd, hRgn) == TRUE; }
	bool Show(int nCmdShow){ return ::ShowWindow(hWnd, nCmdShow) == TRUE; }
	bool IsVisible(){ return ::IsWindowVisible(hWnd) == TRUE; }
	bool ShowOwnedPopups(bool fShow){ return ::ShowOwnedPopups(hWnd, fShow) == TRUE; }
	bool EnableScrollBar(DWORD wSBFlags, DWORD wArrows){ return ::EnableScrollBar(hWnd, wSBFlags, wArrows) == TRUE; }

	// ǥ  Լ
	int MapPoints(cWindow *To, LPPOINT pts, DWORD n){ return ::MapWindowPoints(hWnd, To->hWnd, pts, n); }
	bool ClientToScreen(LPPOINT ppt){ return ::ClientToScreen(hWnd, ppt) == TRUE; }
	void ClientToScreen(LPRECT prc);
	void ScreenToClient(LPRECT prc);
	bool ScreenToClient(LPPOINT ppt){ return ::ScreenToClient(hWnd, ppt) == TRUE; }

	//  ĸ
	bool SetText(LPCTSTR str){ return ::SetWindowText(hWnd, str) == TRUE; }
	int GetText(LPTSTR str, int max){ return ::GetWindowText(hWnd, str, max); }
	int GetTextLength(){ return ::GetWindowTextLength(hWnd); }

	// ũ
	int GetScrollPos(int nBar){ return ::GetScrollPos(hWnd, nBar); }
	void SetScrollPos(int nBar, int nPos, bool bRedraw = true){ ::SetScrollPos(hWnd, nBar, nPos, bRedraw); }
	bool GetScrollRange(int nBar, LPINT pMinPos, LPINT pMaxPos){ return ::GetScrollRange(hWnd, nBar, pMinPos, pMaxPos) == TRUE; }
	bool Scroll(int xAmount, int yAmount, CONST RECT *prc = 0, CONST RECT *prcClip = 0){ return ::ScrollWindow(hWnd, xAmount, yAmount, prc, prcClip) == TRUE; }
	bool GetScrollInfo(int nBar, LPSCROLLINFO psi){ return ::GetScrollInfo(hWnd, nBar, psi) == TRUE; }
	int SetScrollInfo(int fnBar, LPSCROLLINFO psi, bool fRedraw = true){ return ::SetScrollInfo(hWnd, fnBar, psi, fRedraw); }
	bool SetScrollRange(int nBar, int nMinPos, int nMaxPos, bool bRedraw = true){ return ::SetScrollRange(hWnd, nBar, nMinPos, nMaxPos, bRedraw) == TRUE; }
	bool ShowScrollBar(int wBar, bool bShow = true){ return ::ShowScrollBar(hWnd, wBar, bShow) == TRUE; }

	//  
	void DragAcceptFiles(bool bAccept = TRUE){ ::DragAcceptFiles(hWnd, bAccept); }

	// ĳ
	static int CreateCaret(HBITMAP hbmp, int w, int h){ return CreateCaret(hbmp, w, h); }
	static bool GetCaretPos(LPPOINT ppt){ return ::GetCaretPos(ppt) == TRUE; }
	static bool SetCaretPos(int x, int y){ return ::SetCaretPos(x, y) == TRUE; }
	bool HideCaret(){ return ::HideCaret(hWnd) == TRUE; }
	bool ShowCaret(){ return ::ShowCaret(hWnd) == TRUE; }

	// ̾α ڽ ׸ Լ
	HWND GetDlgItem(int id){ return ::GetDlgItem(hWnd, id); }
	bool CheckDlgButton(int nidbtn, DWORD uCheck){ return ::CheckDlgButton(hWnd, nidbtn, uCheck) == TRUE; }
	bool CheckRadioButton(int idFirst, int idLast, int idCheck){ return ::CheckRadioButton(hWnd, idFirst, idLast, idCheck) == TRUE; }
	int DlgDirList(LPTSTR Path, int idListBox, int idPath, DWORD uFileTypes){ return ::DlgDirList(hWnd, Path, idListBox, idPath, uFileTypes); }
	int DlgDirListComboBox(LPTSTR Path, int idCombo, int idPath, DWORD uFileTypes){ return ::DlgDirListComboBox(hWnd, Path, idCombo, idPath, uFileTypes); }
	int GetDlgItemText(int id, LPTSTR str, int nMax){ return ::GetDlgItemText(hWnd, id, str, nMax); }
	cWindow *GetNextDlgGroupItem(cWindow *Ctrl, bool bPrevious = false){ return GetWindow(::GetNextDlgGroupItem(hWnd, Ctrl->hWnd, bPrevious)); }
	cWindow *GetNextDlgTabItem(cWindow *Ctrl, bool bPrevious = FALSE){ return GetWindow(::GetNextDlgTabItem(hWnd, Ctrl->hWnd, bPrevious)); }
	bool IsDlgButtonChecked(int id){ return ::IsDlgButtonChecked(hWnd, id) == TRUE; }
	bool IsDialogMessage(LPMSG pmsg){ return ::IsDialogMessage(hWnd, pmsg) == TRUE; }
	int SendDlgItemMessage(int id, DWORD Msg, WPARAM wParam, LPARAM lParam){ return ::SendDlgItemMessage(hWnd, id, Msg, wParam, lParam); }
	bool SetDlgItemText(int id, LPCTSTR str){ return ::SetDlgItemText(hWnd, id, str) == TRUE; }

	void EndDialog(int Result){
		::EndDialog(hWnd, Result); }
	long GetDialogBaseUnits(){ return ::GetDialogBaseUnits(); }
	int GetDlgCtrlID(){ return ::GetDlgCtrlID(hWnd); }
	int GetDlgItemInt(int nIDDlgItem, BOOL *lpTranslated, BOOL bSigned){ return ::GetDlgItemInt(hWnd, nIDDlgItem, lpTranslated, bSigned); }
	bool MapDialogRect(LPRECT lpRect){ return ::MapDialogRect(hWnd, lpRect) == TRUE; }
	bool SetDlgItemInt(int nIDDlgItem, UINT uValue, BOOL bSigned){ return ::SetDlgItemInt(hWnd, nIDDlgItem, uValue, bSigned) == TRUE; }
	int GetDlgItemInt(int nIDDlgItem);
	bool SetDlgItemInt(int nIDDlgItem, int nValue);



	// ޴ Լ
	HMENU GetMenu(){ return ::GetMenu(hWnd); }
	bool SetMenu(HMENU hMenu){ return ::SetMenu(hWnd, hMenu) == TRUE; }
	bool DrawMenuBar(){ return ::DrawMenuBar(hWnd) == TRUE; }
	HMENU GetSystemMenu(bool bRevert = false){ return ::GetSystemMenu(hWnd, bRevert); }
	bool HiliteMenuItem(HMENU hMenu, DWORD Item, DWORD Flag){ return ::HiliteMenuItem(hWnd, hMenu, Item, Flag) == TRUE; }
	
	// Ÿ̸ Լ
	DWORD SetTimer(DWORD id, DWORD Elapse){ return ::SetTimer(hWnd, id, Elapse, 0); }
	bool KillTimer(DWORD id){ return ::KillTimer(hWnd, id) == TRUE; }

	// 溸 Լ
	bool Flash(DWORD Flag){ return ::FlashWindow(hWnd, Flag) == TRUE; }
	int MessageBox(LPCTSTR text, LPCTSTR caption = 0, DWORD type = MB_OK){ return ::MessageBox(hWnd, text, caption, type); }

	// ޽ Լ
	LRESULT SendMessage(DWORD msg, WPARAM wParam = 0, LPARAM lParam = 0){ return ::SendMessage(hWnd, msg, wParam, lParam); }
	bool PostMessage(DWORD msg, WPARAM wParam = 0, LPARAM lParam = 0){ return ::PostMessage(hWnd, msg, wParam, lParam) == TRUE; }
	bool SendNotifyMessage(DWORD msg, WPARAM w, LPARAM l){ return ::SendNotifyMessage(hWnd, msg, w, l) == TRUE; }

	//  ؽƮ
	int GetWindowText(LPTSTR pString, int nMaxCount){ return ::GetWindowText(hWnd, pString, nMaxCount); }
	int GetWindowTextLength(){ return ::GetWindowTextLength(hWnd); }
	BOOL SetWindowText(LPCTSTR pString){ return ::SetWindowText(hWnd, pString); }

	
	// Auto Type casting
	operator HWND(){ if(this) return hWnd; return 0; } 
	HWND GetWindowHandle(){ return hWnd; };
	static void SetInstanceHandle(HINSTANCE _hInstance){ hInstance = _hInstance; }
	// 
};

// GDI Լ
bool TextOut(HDC hdc, int x, int y, LPCTSTR str);

#endif 
