#include <stdlib.h>
#include <ctype.h>
#include "cAsmLine.h"

bool cAssemblyLine::Read(cFile &File){
	char Buffer[500];
	long n;

	// Reset All Properties
	Reset();

	if(!File.ReadLine(Buffer, 500)) return ALM_EOF;

	if(Buffer[0] == '\n') return ALM_NONE;
	Create(Buffer);

	n = Find(';'); // regard ; as end of string
	if(n >= 0) Set(n, '\0');
	n = GetChar().GetLength();
	if(n == 0) return ALM_NONE; // if the line is empty return NONE?
	Position -= n;

	bLabel = ExtractLabel();
	bOperator = ExtractOperator();

}

bool cAssemblyLine::ExtractLabel(){
	cString Token, Token2;
	long OldPosition = Position;

	Token = GetId();
	if(Token.GetLength() == 0){
		return false;
	}
	Token2 = GetChar();

	if(Token2 == ":"){
		LabelName = Token;
		printf("Label '%s' found.\n", LabelName.Get());
		return true;
	}
	Position = OldPosition;
	return false;
}

bool cAssemblyLine::ExtractOperator(){
	cString Token;
	long n;

	Token = GetId();
	if(Token.GetLength() == 0) return false;

	n = GetChar().GetLength();
	if(n == 0) return true; // there is no parameters?
	Position -= n;

	// Extract Operand1;
	ExtractOperand();
	ExtractOperand();

	return true;
}
void cAssemblyLine::ExtractOperand(){
// <operand> ::= <reg> | <mem> | <num>
// <num> ::= 0(b|d|x)digit(digit)*
// <mem> ::= [<num>] | [(S|D)I] | [BX] | [B(X|P) + (S|D)I |
//			[B(X|P) + (S|D)I + <num>] |
//			[B[
// REG
//
	cString Token, Token2, RegisterName;
	long OldPosition, n;

	OldPosition = Position;
	Token = GetChar();
	if(Token.GetLength() == 0) return;
	Position = OldPosition;

	if(isdigit(Token.Get(0))){ // number
		Token = GetId();
		ImmediateValue = GetImmediateValue(Token);
	}else if(Token.Get(0) == '['){ // memory
		Position ++;
		GetAddressingMode();
	}else{ // may be register
		Token = GetAlpha();
		if(RegisterMode == -1) RegisterMode = GetRegisterCode(Token);
		else if(RegisterCode == -1) RegisterCode = GetRegisterCode(Token);
		else{
			puts("Too Many Operands");
			Error = true;
			return;
		}
		if(RegisterCode < 0) Error = true;
	}
}
void cAssemblyLine::GetAddressingMode(){
	cString Token;
	int r;
	long n;
	bool PlusExpected = false;

	n = Find(']');
	if(n < 0){
		puts("']' is missed.");
		Error = true;
		return;
	}
	if(n == Position){
		puts("no description.");
		Error = true;
		return;
	}
	while(true){
		Token = GetChar();
		if(Token.GetLength() == 0){
			puts("Syntax Error.");
			Error = true;
			return;
		}
		Position --;
		if(Token == "]"){
			break;
		}else if(Token == "+"){
			PlusExpected = false;
		}else if(isdigit(Token.Get(0))){
			if(PlusExpected){
				puts("'+' expected.");
				Error = true;
				return;
			}
			Token = GetId();
			MemoryIndexValue = GetImmediateValue(Token);
			PlusExpected = true;
		}else if(isalpha(Token.Get(0))){
			Token = GetAlpha();
			r = GetRegisterCode(Token);
			switch(r){
			case 3: bBX = true; break;
			case 5: bBP = true; break;
			case 6: bSI = true; break;
			case 7: bDI = true; break;
			default:
				puts("wrong index register.");
				Error = true;
				return;
			}
			PlusExpected = true;
		}else{
			puts("wrong Character.");
			Error = true;
			return;
		}
	}
}
int cAssemblyLine::GetRegisterCode(cString &Name){
	static const struct sRegisterSelection{
		char *Name;
		int Code;
	} Regs[] = {
		"AL", 0, "CL", 1, "DL", 2, "BL", 3, "AH", 4, "CH", 5, "DH", 6, "BH", 7,
		"AX", 0, "CX", 1, "DX", 2, "BX", 3, "SP", 4, "BP", 5, "SI", 6, "DI", 7
	};

	for(int i = 0; i < 16; i ++){
		if(Name == Regs[i].Name) return Regs[i].Code;
	}
	return -1;
}
