#include <stdio.h>
#include <string.h>
#include "cOperatorTable.h"
#include "cFile.h"

#include "cHash.cpp"

cOperatorTable::cOperatorTable(){
	Create(200);
}

bool cOperatorTable::Load(char *FileName){
	char Buffer[256];
	char Name[100], Operand1[100], Operand2[100], Code1[100], Code2[100];
	cFile File;
	cOperator Operator;
	bool Error = false;
	int Count, i;

	Operators = 0;

	if(!File.Open(FileName, "rt")) return false;

	while(!Error){
		if(!File.SkipSpace()) break;
		if(!File.GetString(Buffer, 256)) break;
		strlwr(Buffer);
		if(*Buffer == ';') continue;
		if(sscanf(Buffer, "%s%d", Name, &Count) == 2){
			if(!Operator.Create(Name, Count)){
				Error = true; break;
			}
			for(i = 0; i < Count; i ++){
				if(!File.SkipSpace()){
					Error = true; break;
				}
				if(!File.GetString(Buffer, 256)){
					Error = true; break;
				}
				if(sscanf(Buffer, "%s%s%s%s", Operand1, Operand2, Code1, Code2) == 4){
					if(!Operator.SetOpCode(i, Operand1, Operand2, Code1, Code2)){
						Error = true; break;
					}
				}else{
					Error = true; break;
				}
			}
			if(Error) break;
		}
		if(Error) break;
		if(!Insert(Operator)){
			printf("Error: Can't insert operator to hash table: %s\n", Name);
			Error = true;
			break;
		}
		Operators ++;
	}
	File.Close();

	return Error == false;
}
//////////////////// Get Machine Code Size //////////////////////
bool cOperatorTable::GetMachineCodeSize(char *nName, 
						eOperandType nType1, eOperandType nType2, 
						sOpCodeInfo OpCodeInfo, int &nSize){
	int StaticSize, i;
	eOperandType Type1, Type2;
 	cOperator Operator;

	// Get Correct Operator From Operator Table
	Operator.SetName(nName);
	if(!Get(Operator)){
		printf("Error: Operator '%s' not found.\n", nName);
		return false;
	}
	// Find Matching Operand Pattern
	for(i = 0; i < Operator.GetSortCount(); i ++){
		Operator.GetOpCodeSizeInfo(i, Type1, Type2, StaticSize);
		if(IsEqualOperand(Type1, nType1) && IsEqualOperand(Type2, nType2)){
			nSize = StaticSize 
				+ GetExtendCodeSize(Type1, OpCodeInfo) 
				+ GetExtendCodeSize(Type2, OpCodeInfo);
			return true;
		}
	}
	printf("Error: No matching operand pattern.\n");
	printf("Operand Pattern: %d %d\n", nType1, nType2);
	return false;
}

bool cOperatorTable::GetMachineCode(char *nName, 
					eOperandType nType1, eOperandType nType2, 
					sOpCodeInfo OpCodeInfo, int &nSize, 
					int Address, byte *Code){
	int StaticSize, i;
	eOperandType Type1, Type2;
	cOperator Operator;
	char Code1[8], Code2[8];

	// Get Correct Operator From Operator Table
	Operator.SetName(nName);
	if(!Get(Operator)){
		printf("Error: Operator '%s' not found.\n", nName);
		return false;
	}

	// Find Matching Operand Pattern
	for(i = 0; i < Operator.GetSortCount(); i ++){
		Operator.GetOpCode(i, Type1, Type2, Code1, Code2, StaticSize);
		if(IsEqualOperand(Type1, nType1) && IsEqualOperand(Type2, nType2)){
			nSize = StaticSize 
				+ GetExtendCodeSize(Type1, OpCodeInfo) 
				+ GetExtendCodeSize(Type2, OpCodeInfo);
			if(Type1 == OP_LABEL16 || Type2 == OP_LABEL16
				|| Type1 == OP_LABEL8 || Type2 == OP_LABEL8){
				OpCodeInfo.imm -= Address + nSize;
			}
			return Encode(Type1, Type2, Code, Code1, Code2, OpCodeInfo, StaticSize);

		}
	}
	printf("Error: No matching operand pattern.%d\n", i);
	return false;
}

bool cOperatorTable::IsEqualOperand(eOperandType Type1, eOperandType Type2){
	switch(Type1){
	case OP_REG:
		if(Type2 == OP_REG8 || Type2 == OP_REG16) return true;
		break;
	case OP_MEM:
		if(Type2 == OP_MEM8 || Type2 == OP_MEM16) return true;
		break;
	case OP_LABEL8:
		if(Type2 == OP_IMM8) return true;
		break;
	case OP_LABEL16:
		if(Type2 == OP_IMM16) return true;
		break;
	case OP_IMM: 
		if(Type2 == OP_IMM8 || Type2 == OP_IMM16) return true;
		break;
	}
	if(Type1 == Type2) return true;
	return false;
}

int cOperatorTable::GetExtendCodeSize(eOperandType Type, sOpCodeInfo OpCodeInfo){
	switch(Type){
	case OP_MEM: case OP_MEM8: case OP_MEM16:
		if(OpCodeInfo.rm == 6 && OpCodeInfo.mod == 0) return 2;
		if(OpCodeInfo.mod == 2) return 2;
		if(OpCodeInfo.mod == 1) return 1;
		return 0;
	case OP_IMM:
		if(OpCodeInfo.w) return 2;
		return 1;
	case OP_IMM8: case OP_LABEL8:
		return 1;
	case OP_IMM16: case OP_LABEL16:
		return 2;
	}
	return 0;
}

bool cOperatorTable::Encode(eOperandType Type1, eOperandType Type2, byte *Code, char *Code1, char *Code2, sOpCodeInfo OpCodeInfo, int StaticSize){
	char *Ptr[2];
	byte Bit;
	int i,j, L;

	Ptr[0] = Code1;
	Ptr[1] = Code2;
	
	for(i = 0; i < StaticSize; i ++){
		Bit = 0x80;
		Code[i] = '\0';
		for(j = 0; j < 8; j ++){
			if(Ptr[i][j] == '0'){
				Bit >>= 1;
			}else if(Ptr[i][j] == '1'){
				Code[i] |= Bit;
				Bit >>= 1;
			}else if(Ptr[i][j] == 'w'){
				if(OpCodeInfo.w) Code[i] |= Bit;
				Bit >>= 1;
			}else if(Ptr[i][j] == 's'){
				//Code[i] |= Bit;
				Bit >>= 1;
			}else if(Ptr[i][j] == 'r' && Ptr[i][j + 1] == 'e' && Ptr[i][j + 2] == 'g'){
				Code[i] |= (byte)OpCodeInfo.reg << (5 - j);
				Bit >>= 3;
				j += 2;
			}else if(Ptr[i][j] == 's' && Ptr[i][j + 1] == 'r'){
				Code[i] |= (byte)OpCodeInfo.sreg << (6 - j);
				Bit >>= 2;
				j ++;
			}else if(Ptr[i][j] == 'r' && Ptr[i][j + 1] == '/' && Ptr[i][j + 2] == 'm'){
				Code[i] |= (byte)OpCodeInfo.rm << (5 - j);
				Bit >>= 3;
				j += 2;
			}else if(Ptr[i][j] == 'm' && Ptr[i][j + 1] == 'd'){
				Code[i] |= (byte)OpCodeInfo.mod << (6 - j);
				Bit >>= 2;
				j ++;
			}
		}
	}
	L = StaticSize;
	if(Type1 == OP_MEM || Type2 == OP_MEM){
		if((OpCodeInfo.rm == 6 && OpCodeInfo.mod == 0) || OpCodeInfo.mod == 2){
			Code[L] = (byte)((unsigned)OpCodeInfo.disp & 0xFF);
			L ++;
			Code[L] = (byte)((unsigned)OpCodeInfo.disp >> 8);
			L ++;
		}else if(OpCodeInfo.mod == 1){
			Code[L] = (byte)OpCodeInfo.disp;
			L ++;
		}
	}
	if(Type1 == OP_IMM || Type2 == OP_IMM){
		if(!OpCodeInfo.w){
			Code[L] = (byte)OpCodeInfo.imm;
			L ++;
		}else{
			Code[L] = (byte)((unsigned)OpCodeInfo.imm & 0xFF);
			L ++;
			Code[L] = (byte)((unsigned)OpCodeInfo.imm >> 8);
			L ++;
		}
	}else if(Type1 == OP_IMM8 || Type2 == OP_IMM8 
		|| Type1 == OP_LABEL8 || Type2 == OP_LABEL8){
		Code[L] = (byte)OpCodeInfo.imm;
		L ++;
	}else if(Type1 == OP_IMM16 || Type2 == OP_IMM16 
		|| Type1 == OP_LABEL16 || Type2 == OP_LABEL16){
		Code[L] = (byte)((unsigned)OpCodeInfo.imm & 0xFF);
		L ++;
		Code[L] = (byte)((unsigned)OpCodeInfo.imm >> 8);
		L ++;
	}
	Code[L] = '\0';
	return true;
}
