#ifndef H_cOperatorTable
#define H_cOperatorTable

#include "cHash.h"
#include "cOperator.h"

class cOperatorTable:public cHash<cOperator>{
protected:
	int Operators;

	bool IsEqualOperand(eOperandType Type1, eOperandType Type2);
	int GetExtendCodeSize(eOperandType Type, sOpCodeInfo OpCodeInfo);
	bool Encode(eOperandType Type1, eOperandType Type2, byte *Code, char *Code1, char *Code2, sOpCodeInfo OpCodeInfo, int StaticSize);
public:
	cOperatorTable();
	bool Load(char *FileName);
	bool GetMachineCodeSize(char *nName, eOperandType Type1, eOperandType Type2, sOpCodeInfo OpCodeInfo, int &nSize);
	bool GetMachineCode(char *nName, eOperandType Type1, eOperandType Type2, sOpCodeInfo OpCodeInfo, int &nSize, int Address, byte *Code);

};

#endif