#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "Default.h"

/////////////////////// Get Directive ID /////////////////////////
eDirective GetDirectiveID(char *s){
	const int Directives = 7;
	static struct sDirective{
		char *Name;
		eDirective Identifier;
	} DirectiveList[Directives] = {
		"db", D_DB,
		"dbs", D_DBS,
		"dw", D_DW,
		"dws", D_DWS,
		"ds", D_DS,
		"equ", D_EQU,
		"org", D_ORG
	};
	int i;

	for(i = 0; i < Directives; i ++){
		if(strcmp(s, DirectiveList[i].Name) == 0) 
			return DirectiveList[i].Identifier;
	}
	return D_NONE;
}


bool GetStringSize(char *String, int &nSize){
	int Size = 0;

	while(isspace(*String)) String ++;
	if(*String != '\"') return false;
	String ++;
	while(*String != '\"'){
		if(*String == '\0') return false;
		if(*String == '\\'){
			String ++;
			switch(*String){
			case 'a': case 'b': case 'f': case 'n': 
			case 'r': case 't': case 'v': case '\'': 
			case '\\': case '?': case '\"':
				String ++;
				Size ++;
				break;
			case 'x': // ASCII character in octal notation
				String ++;
				while(isxdigit(*String)) String ++;
				Size ++;
				break;
			case '0': case '1': case '2': case '3':
			case '4': case '5': case '6': case '7':
				// ASCII character in hexadecimal notation
				while(isdigit(*String) && *String != '8' && *String != '9')
					String ++;
				Size ++;
				break;
			default:
				return false;
			}
		}else{
			String ++;
			Size ++;
		}
	}
	nSize = Size;
	return true;
}

int ExtractString(char *Dest, char *Src){
	int Value;
	int Count = 0;

	*Dest = '\0';

	while(isspace(*Src)) Src ++;
	if(*Src != '\"') return 0;

	Src ++;
	while(*Src != '\"'){
		if(*Src == '\0') return 0;
		if(*Src == '\\'){
			Src ++;
			switch(*Src){
			case 'a': *Dest == '\a'; Src ++; Dest ++; break;
			case 'b': *Dest == '\b'; Src ++; Dest ++; break;
			case 'f': *Dest == '\f'; Src ++; Dest ++; break;
			case 'n': *Dest == '\n'; Src ++; Dest ++; break;
			case 'r': *Dest == '\r'; Src ++; Dest ++; break;
			case 't': *Dest == '\t'; Src ++; Dest ++; break;
			case 'v': *Dest == '\v'; Src ++; Dest ++; break;
			case '\'': *Dest == '\''; Src ++; Dest ++; break;
			case '\\': *Dest == '\\'; Src ++; Dest ++; break;
			case '?': *Dest == '\?'; Src ++; Dest ++; break;
			case '\"': *Dest == '\"'; Src ++; Dest ++; break;
			case 'x':
				// ASCII character in hexadecimal notation
				Src ++;
				Value = 0;
				while(isxdigit(*Src)){
					Value <<= 4;
					if(*Src >= '0' && *Src <= '9'){
						Value += (*Src) - '0';
					}else{
						Value += toupper(*Src) - 'A' + 10;
					}
					Src ++;
				}
				*Dest = (char)Value;
				Dest ++;
				break;
			case '0': case '1': case '2': case '3':
			case '4': case '5': case '6': case '7':
				// ASCII character in octal notation
				Value = 0;
				while(isdigit(*Src) && *Src != '8' && *Src != '9'){
					Value <<= 4;
					Value += (*Src) - '0';

					Src ++;
				}
				*Dest = (char)Value;
				Dest ++;
				break;
			default:
				return 0;
			}
			Count ++;
		}else{
			*Dest = *Src;
			Src ++;
			Dest ++;
			Count ++;
		}
	}
	*Dest = '\0';
	return Count;
}

void PrintHexa(byte *String, int Size){
	char Table[] = "0123456789ABCDEF";
	int i, Low, High;
	for(i = 0; i < Size; i ++){
		Low = String[i] & 15;
		High = String[i] >> 4;
		printf("%c", Table[High]);
		printf("%c", Table[Low]);
	}
}
