#ifndef H_cAssembler
#define H_cAssembler

#include "Default.h"
#include "cFile.h"
#include "cOperatorTable.h"
#include "cUserSymbolTable.h"

class cAssembler{
protected:
	cFile SourceFile, ObjectFile;

	cOperatorTable OperatorTable;
	cUserSymbolTable UserSymbolTable;

	int LineMode;
	int	Address;

	bool IsFirstPass;

	bool ProcessParameter(int Params, char **Param);

	bool FirstPass();
	bool SecondPass();

	bool ProcessFirstDirective(char *Label, eDirective Directive, char *Operand);
	bool ProcessSecondDirective(char *Label, eDirective Directive, char *Operand);

	bool GetMachineCodeSize(char *Operator, char *Operand, int &nSize);
	bool WriteMachineCode(char *Operator, char *Operand);
	

	void Close();

	bool GetImmCount(char *String, int &Count);

	bool WriteByte(char *nString, int &Size);
	bool WriteWord(char *nString, int &Size);
	bool WriteString(char *nString, int &Size);
	// Parsing Functions
	char *String;

	char Token[256];


	bool SolveOperands(eOperandType &Type1, eOperandType &Type2, sOpCodeInfo &OpCodeInfo);
	eOperandType SolveOperand(sOpCodeInfo &OpCodeInfo);
	eOperandType SolveRegister(sOpCodeInfo &OpCodeInfo);
	eOperandType SolveImm(sOpCodeInfo &OpCodeInfo);
	eOperandType SolveMemref(sOpCodeInfo &OpCodeInfo);

	bool Solve(char *nMatter, int &ReturnValue);
	bool SolveExpr(int &ReturnValue);
	bool SolveTerm(int &ReturnValue);
	bool SolvePrimary(int &ReturnValue);

	bool SkipSpace();
	// Extracting Source Line
	bool GetIdentifier(char *Id);
	int ExtractLine(char *Label, char *Operator, eDirective &Directive, char *Operand);

	// 
	void Title();

public:
	cAssembler();
	~cAssembler();
	int Run(int Params, char **Param); // Call me.
};

#endif