// Lexical Analyser
#include <ctype.h>
#include <string.h>
#include "cAssemblyFile.h"

////////////////////////////////////////////////////////////////
cAssemblyFile::cAssemblyFile(){
}

cAssemblyFile::~cAssemblyFile(){
}
////////////////////////// Get Identifier //////////////////////
bool cAssemblyFile::GetIdentifier(char *Identifier){
	int Char, Len = 0;

	*Identifier = '\0';

	Char = Getc();
	if(Char == EOF) return false;
	if(!isalpha(Char)) return false;
	while(Char != EOF){
		if(isalpha(Char) || isdigit(Char) || (char)Char == '_'){
			*Identifier ++ = (char)Char;
			Len ++;
		}else{
			Ungetc(Char);
			if(Len == 0) return false;
			* Identifier = '\0';
			return true;
		}
		Char = Getc();
	}
	return false;

}
////////////////////////// Get Unit ////////////////////////////
int cAssemblyFile::GetUnit(char *Label, char *Operator, eDirective &Directive, char *Operand){
// Extract Label, Operator, Directive, Operand
	int LineMode = LM_NONE;
	char Buffer[256];
	int Char;

	* Label = '\0';
	* Operator = '\0';
	Directive = D_NONE;
	* Operand = '\0';

	while(true){
		// Skip non assembly tokens
		if(!SkipSpace()) return LM_NONE;
		Char = Getc();
		if(Char == '\n') continue;
		if(Char == ';'){ // Skip Remark
			if(!FindChar('\n')) return LM_NONE;
			Getc(); // Skip ;
			continue;
		}
		Ungetc(Char);

		// Extract Label
		if(!GetIdentifier(Buffer)) return LM_ERROR;
		Char = Getc();
		if(Char == ':'){ // If that is an label
			strlwr(Buffer);
			strcpy(Label, Buffer);
			LineMode |= LM_LABEL;
			if(!SkipSpace()) return LineMode;
			if(!GetIdentifier(Buffer)) return LineMode;
		}else{
			Ungetc(Char);
		}
		// Extract Operator
		strlwr(Buffer);
		Directive = GetDirectiveID(Buffer);
		if(Directive == D_NONE){
			strcpy(Operator, Buffer);
			LineMode |= LM_OPERATOR;
		}else{
			LineMode |= LM_DIRECTIVE;
		}
		// Extract Operand
		*Operand = '\0';
		if(!SkipSpace()) return LineMode;
		Char = Getc();
		while(Char != EOF && Char != '\n' && Char != ';'){
			* Operand ++ = (char)Char;
			Char = Getc();
		}
		* Operand = '\0';
		Ungetc(Char);
		LineMode |= LM_OPERAND;
		return LineMode;
	}
}
/////////////////////// Get Directive ID/////////////////////////
eDirective cAssemblyFile::GetDirectiveID(char *s){
	const int Directives = 7;
	static struct sDirective{
		char *Name;
		eDirective Identifier;
	} DirectiveList[Directives] = {
		"db", D_DB,
		"dbs", D_DBS,
		"dw", D_DW,
		"dws", D_DWS,
		"ds", D_DS,
		"equ", D_EQU,
		"org", D_ORG
	};
	int i;

	for(i = 0; i < Directives; i ++){
		if(strcmp(s, DirectiveList[i].Name) == 0) 
			return DirectiveList[i].Identifier;
	}

	return D_NONE;
}

