#include <stdio.h>
#include <ctype.h>
#include "cCalculator.h"


bool cCalculator::Solve(char *nString, int &ReturnValue){
	String = nString;

	if(SolveExpr(ReturnValue)) return true;
	
	return false;
}

bool cCalculator::SolveExpr(int &ReturnValue){
// <expr> ::= <term> + <expr> | <term> - <expr> | <term>
	int a, b;
	if(!SolveTerm(a)) return false;
	if(!SkipSpace()){
		ReturnValue = a;
		return true;
	}
	switch(*String){
	case '+':
		String ++;
		if(!SolveExpr(b)) return false;
		ReturnValue = a + b;
		return true;
	case '-':
		String ++;
		if(!SolveExpr(b)) return false;
		ReturnValue = a - b;
		return true;
	}
	ReturnValue = a;
	return true;
}

bool cCalculator::SolveTerm(int &ReturnValue){
// <term> ::= <primary> * <term> | <primary> / <term> | <primary> % <term> | <primary>
	int a, b;

	if(!SolvePrimary(a)) return false;
	if(!SkipSpace()){
		ReturnValue = a;
		return true;
	}
	switch(*String){
	case '*':
		String ++;
		if(!SolveTerm(b)) return false;
		ReturnValue = a * b;
		return true;
	case '/':
		String ++;
		if(!SolveTerm(b)) return false;
		ReturnValue = a / b;
		return true;
	case '%':
		String ++;
		if(!SolveTerm(b)) return false;
		ReturnValue = a % b;
		return true;
	}
	ReturnValue = a;
	return true;
}


bool cCalculator::SolvePrimary(int &ReturnValue){
// <primary> ::= (<expr>) | <id> | <number> 
	int i;
	// Skip Space
	if(!SkipSpace()) return false;

	if(isdigit(*String) || *String == '-'){ // Number
		if( *String == '-' || !( *String == '0' && !isdigit(*(String + 1)) ) ){ // Decimal Number
			// Extract Decimal Number
			i = 0;
			if(*String == '-'){ 
				Token[i] = '-'; String ++; i ++;
			}
			while(isdigit(*String)){
				Token[i] = *String; String ++; i ++;
			}
			Token[i] = '\0';
			if(sscanf(Token, "%d", &ReturnValue) == 1) return true;
			return false;
		}
		// Another Number
		switch(*(String + 1)){
		case 'x': case 'X':
			String += 2;
			i = 0;
			while(isxdigit(*String)){
				Token[i] = *String; String ++; i ++;
			}
			Token[i] = '\0';
			if(sscanf(Token, "%x", &ReturnValue) == 1) return true;
			return false;
		}
		// Error
		return false;
	}else if(*String == '('){
		String ++;
		if(!SolveExpr(ReturnValue)) return false;
		if(!SkipSpace()) return false;
		if(*String == ')'){ 
			String ++; 
			return true;
		}
		return false;
	}
	return false;
}

bool cCalculator::SkipSpace(){
	while(isspace(*String)) String ++;
	if(*String == '\0') return false;
	return true;
}
