#include <string.h>
#include <stdio.h>
#include "cOperator.h"

#define min(a, b)  (((a) < (b)) ? (a) : (b)) 
/////////////////////////////////////////////////////////////////
/////////////////////////// cOpCode /////////////////////////////
cOpCode::cOpCode(){
	Operand1 = OP_VOID;
	Operand2 = OP_VOID;
	StaticSize = 0;
}
cOpCode::cOpCode(cOpCode &A){
	Operand1 = A.Operand1;
	Operand2 = A.Operand2;
	strncpy(Code1, A.Code1, 8);
	strncpy(Code2, A.Code2, 8);
	StaticSize = A.StaticSize;
}

bool cOpCode::Set(eOperandType nOperand1, eOperandType nOperand2, char *nCode1, char *nCode2){
	Operand1 = nOperand1;
	Operand2 = nOperand2;

	strncpy(Code1, nCode1, 8);
	strncpy(Code2, nCode2, 8);
	strlwr(Code1);
	strlwr(Code2);

	if(*Code2 == '-') StaticSize = 1;
	else StaticSize = 2;

	return true;
}

void cOpCode::Get(eOperandType &Type1, eOperandType &Type2, char *nCode1, char *nCode2, int &nStaticSize){
	Type1 = Operand1;
	Type2 = Operand2;

	strncpy(nCode1, Code1, 8);
	strncpy(nCode2, Code2, 8);

	nStaticSize = StaticSize;
}
void cOpCode::GetSizeInfo(eOperandType &Type1, eOperandType &Type2, int &nStaticSize){
	Type1 = Operand1;
	Type2 = Operand2;
	nStaticSize = StaticSize;	
}

void cOpCode::GetType(eOperandType &Type1, eOperandType &Type2){
	Type1 = Operand1;
	Type2 = Operand2;
}

void cOpCode::GetCode(char *nCode1, char *nCode2){
	strncpy(nCode1, Code1, 8);
	strncpy(nCode2, Code2, 8);
}
////////////////////////////////////////////////////////////////
/////////////////////////// cOperator ///////////////////////////
cOperator::cOperator(){
	*Name = 0;
	OpCode = NULL;
}

cOperator::cOperator(cOperator &A){
	Create(A.Name, A.SortCount);
	for(int i = 0; i < SortCount; i ++){
		OpCode[i] = A.OpCode[i];
	}
}
void cOperator::operator=(cOperator &A){
	Create(A.Name, A.SortCount);
	for(int i = 0; i < SortCount; i ++){
		OpCode[i] = A.OpCode[i];
	}
}

void cOperator::Destroy(){
	if(OpCode) delete [] OpCode;
	OpCode = NULL;
}
//////////////////////////// Create ////////////////////////////
bool cOperator::Create(char *nName, int n){
	Destroy();
	strcpy(Name, nName);
	strlwr(Name);
	SortCount = n;
	OpCode = new cOpCode[n];
	if(!OpCode) return false;
	return true;
}

void cOperator::SetName(char *nName){
	strncpy(Name, nName, 8);
}
void cOperator::GetName(char *nName){
	strcpy(nName, Name);
}
////////////////////////////////////////////////////////////////
bool cOperator::SetOpCode(int n, char *nOperand1, char *nOperand2, char *nCode1, char *nCode2){
	return OpCode[n].Set(
		GetOperandType(nOperand1),
		GetOperandType(nOperand2),
		nCode1, nCode2);
}
void cOperator::GetOpCode(int n, eOperandType &Type1, eOperandType &Type2, char *nCode1, char *nCode2, int &nStaticSize){
	OpCode[n].Get(Type1, Type2, nCode1, nCode2, nStaticSize);
}
void cOperator::GetOpCodeSizeInfo(int n, eOperandType &Type1, eOperandType &Type2, int &nStaticSize){
	OpCode[n].GetSizeInfo(Type1, Type2, nStaticSize);
}

eOperandType cOperator::GetOperandType(char *Operand){
	static struct sOperandType{
		char *Name;
		eOperandType Type;
	} OperandType[] = {
		"-", OP_VOID, 
		"REG", OP_REG, 
		"REG8", OP_REG8, 
		"REG16", OP_REG16,
		"MEM",	OP_MEM, 
		"MEM8", OP_MEM8,
		"MEM16", OP_MEM16, 
		"IMM", OP_IMM, 
		"IMM8", OP_IMM8,
		"IMM16", OP_IMM16, 
		"SREG", OP_SREG, 
		"LABEL8", OP_LABEL8,
		"LABEL16", OP_LABEL16
	};
	strupr(Operand);
	for(int i = 0; i < 13; i ++){
		if(strcmp(Operand, OperandType[i].Name) == 0) return OperandType[i].Type;
	}
	return OP_VOID;
}
int cOperator::GetSortCount(){
	return SortCount;
}

/////////////////////////// Functions For Hash Table
int cOperator::GetHashNumber(){
	int Len = min(strlen(Name), 5);
	long l = 0, i;

	for(i = 0; i < Len; i ++){
		l += Name[i] - 'a';
		l <<= 5;
	}
	return l % 200;
}

bool cOperator::operator==(cOperator &A){
	if(strcmp(A.Name, Name) == 0) return true;
	return false;
}
